/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Alert
extends JDialog {
    public static final int TYPE_STOP = 0;
    public static final int TYPE_CAUTION = 1;
    public static final int TYPE_NOTE = 2;
    public static final int TYPE_MISC = 3;
    public static final int BUTTON_YES = 1;
    public static final int BUTTON_NO = 2;
    public static final int BUTTON_OK = 4;
    public static final int BUTTON_CANCEL = 8;
    public static final int BUTTON_HELP = 16;
    public static final int BUTTON_USER = 32;
    private String m_message;
    private int m_alertType;
    private JButton[] m_buttons = new JButton[6];
    private String[] m_titles = new String[]{"YES", "NO", "OK", "CANCEL", "HELP", "USER"};
    private JLabel m_label;
    private JPanel m_buttonsPane = new JPanel(new GridLayout(1, 6));
    private int m_defaultButton;
    private int m_clickedButton = 0;
    private ActionListener m_actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            for (int i2 = 0; i2 < 6; ++i2) {
                if (evt.getSource() != Alert.this.m_buttons[i2]) continue;
                Alert.this.m_clickedButton = (int)Math.pow(2.0, i2);
                if (Alert.this.m_clickedButton == 16) continue;
                Alert.this.setVisible(false);
            }
        }
    };

    public Alert(Dialog parent, String message, int alertType, int buttons) {
        super(parent, message, true);
        this.alertInit(message, alertType, buttons);
    }

    public Alert(Frame parent, String message, int alertType, int buttons) {
        super(parent, message, true);
        this.alertInit(message, alertType, buttons);
    }

    public int getDefaultButton() {
        return this.m_defaultButton;
    }

    public void setDefaultButton(int button) {
        this.m_defaultButton = button;
    }

    private void alertInit(String message, int alertType, int buttons) {
        this.setSize(200, 100);
        this.setLocationRelativeTo(this.getParent());
        this.m_message = message;
        this.m_alertType = alertType;
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.m_label = new JLabel(this.m_message);
        this.m_label.setHorizontalAlignment(0);
        contentPane.add((Component)this.m_label, "Center");
        contentPane.add((Component)this.m_buttonsPane, "South");
        this.createButtons(buttons);
    }

    private void createButtons(int buttons) {
        for (int i2 = 0; i2 < 6; ++i2) {
            if ((buttons & (int)Math.pow(2.0, i2)) == 0) continue;
            this.m_buttons[i2] = new JButton(this.m_titles[i2]);
            this.m_buttons[i2].setActionCommand(Integer.toString(i2));
            this.m_buttons[i2].addActionListener(this.m_actionListener);
            this.m_buttonsPane.add(this.m_buttons[i2]);
        }
    }

    public int runAlert() {
        this.setVisible(true);
        return this.m_clickedButton;
    }
}

