/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.dialog.propertylayout;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bm.dialog.propertylayout.GOne;
import oracle.bm.dialog.propertylayout.PropertyComponentGroup;
import oracle.bm.dialog.propertylayout.PropertyComponentGroupLayout;
import oracle.bm.dialog.propertylayout.PropertyComponentGroupLayoutConstraints;
import oracle.bm.dialog.propertylayout.PropertyPageLayout;
import oracle.bm.dialog.propertylayout.PropertyPageLayoutConstraints;
import oracle.bm.dialog.propertylayout.PropertyRadioGroup;
import oracle.bm.util.ResourcePicker;

public class PropertyDialogPanel
extends JPanel {
    protected Vector m_panels;
    protected Hashtable m_radioButtons;
    protected PropertyPageLayoutConstraints m_radioConstraints;

    public PropertyDialogPanel(String title, ResourcePicker picker) {
        this.setLayout(new PropertyPageLayout());
        this.m_panels = new Vector();
        this.m_radioButtons = new Hashtable();
        this.m_radioConstraints = new PropertyPageLayoutConstraints();
        this.m_radioConstraints.setKeptWithNextVertical(true);
    }

    protected void addControlGroup(PropertyComponentGroup group, boolean g) {
        JPanel groupPanel = new JPanel();
        this.m_panels.addElement(groupPanel);
        PropertyComponentGroupLayoutConstraints keep = new PropertyComponentGroupLayoutConstraints(true);
        PropertyComponentGroupLayoutConstraints newline = new PropertyComponentGroupLayoutConstraints();
        PropertyComponentGroupLayoutConstraints keepIndent = new PropertyComponentGroupLayoutConstraints(true);
        keepIndent.setIndented(true);
        PropertyComponentGroupLayoutConstraints newlineIndent = new PropertyComponentGroupLayoutConstraints();
        newlineIndent.setIndented(true);
        groupPanel.setLayout(group.getLayoutManager() == null ? new PropertyComponentGroupLayout() : group.getLayoutManager());
        for (int i2 = 0; i2 < group.getComponents().length; ++i2) {
            PropertyComponentGroupLayoutConstraints constraints = null;
            if (groupPanel.getLayout() instanceof PropertyComponentGroupLayout) {
                constraints = group.getComponentConstraints()[i2] == null ? (i2 < group.getComponents().length - 1 ? (group.getComponents()[i2 + 1] instanceof JButton ? (g ? keepIndent : keep) : (g ? newlineIndent : newline)) : (g ? newlineIndent : newline)) : group.getComponentConstraints()[i2];
            }
            groupPanel.add(group.getComponents()[i2], constraints);
        }
        this.createBorderForGroup(group, groupPanel);
        this.add((Component)groupPanel, new PropertyPageLayoutConstraints());
    }

    public void addControlGroup(PropertyComponentGroup g) {
        this.addControlGroup(g, false);
    }

    public void addRadioGroup(PropertyRadioGroup prg) {
        Enumeration groups = prg.getGroupNames();
        while (groups.hasMoreElements()) {
            String thisGroup = (String)groups.nextElement();
            JRadioButton radio = new JRadioButton(thisGroup);
            this.m_radioButtons.put(thisGroup, radio);
            this.add((Component)radio, this.m_radioConstraints);
            this.addControlGroup(prg.getGroup(thisGroup), true);
        }
    }

    public void addRadioListener(String radioButtonName, ActionListener s) {
        ((JRadioButton)this.m_radioButtons.get(radioButtonName)).addActionListener(s);
    }

    public void removeRadioListener(String radioButtonName, ActionListener s) {
        ((JRadioButton)this.m_radioButtons.get(radioButtonName)).removeActionListener(s);
    }

    public static void main(String[] args) {
        JFrame testFrame = new JFrame();
        PropertyDialogPanel pdp = new PropertyDialogPanel("bvlah", null);
        testFrame.getContentPane().add(pdp);
        for (int i2 = 0; i2 < 10; ++i2) {
            pdp.addControlGroup(new GOne());
        }
        PropertyRadioGroup rg = new PropertyRadioGroup();
        for (int i3 = 0; i3 < 3; ++i3) {
            rg.addGroup("Group" + i3, new GOne());
        }
        pdp.addRadioGroup(rg);
        testFrame.pack();
        testFrame.setVisible(true);
    }

    protected void createBorderForGroup(PropertyComponentGroup grp, JPanel pan) {
        if (grp.isBorderVisible()) {
            pan.setBorder(BorderFactory.createTitledBorder(grp.getGroupTitle()));
        }
    }
}

