/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.dialog.propertylayout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.bm.dialog.propertylayout.PropertyComponentGroupLayoutConstraints;
import oracle.bm.util.ui.HackFixComboBox;

public class PropertyComponentGroupLayout
implements LayoutManager2 {
    public static final int DEFAULT_SPACING = 5;
    public static final int MINIMUM_FIELDWIDTH = 275;
    public static final int INDENT_SIZE = 10;
    protected Vector m_items = new Vector();
    protected Hashtable m_constraints = new Hashtable();
    protected int m_max_width = 275;
    protected int m_running_width = 0;
    protected int m_spacing = 5;

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, new PropertyComponentGroupLayoutConstraints());
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        this.m_items.addElement(comp);
        if (constraints != null) {
            this.m_constraints.put(comp, constraints);
            if (constraints instanceof PropertyComponentGroupLayoutConstraints) {
                PropertyComponentGroupLayoutConstraints pcons = (PropertyComponentGroupLayoutConstraints)constraints;
                this.m_running_width += comp.getPreferredSize().width;
                if (!pcons.isKeptWithNext()) {
                    this.m_max_width = Math.max(this.m_max_width, this.m_running_width);
                    this.m_running_width = 0;
                }
            }
        } else {
            this.m_max_width = Math.max(this.m_max_width, this.m_running_width);
            this.m_running_width = 0;
        }
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int currentX = insets.left;
        int currentY = insets.right;
        int currentW = 0;
        int currentH = 0;
        if (parent.getSize().width > 0) {
            this.m_max_width = Math.min(this.m_max_width, parent.getSize().width);
        }
        for (int i2 = 0; i2 < this.m_items.size(); ++i2) {
            Component curComp = (Component)this.m_items.elementAt(i2);
            PropertyComponentGroupLayoutConstraints curCons = (PropertyComponentGroupLayoutConstraints)this.m_constraints.get(curComp);
            if (curCons != null && curCons.isIndented()) {
                currentX = 10;
            }
            currentH = curComp.getPreferredSize().height;
            if (curComp instanceof JTextField || curComp instanceof HackFixComboBox) {
                currentW = this.m_max_width;
                if (i2 < this.m_items.size() - 1 && this.m_items.elementAt(i2 + 1) instanceof JButton && curCons != null && curCons.isKeptWithNext()) {
                    currentW = currentW - ((JButton)this.m_items.elementAt((int)(i2 + 1))).getPreferredSize().width - this.m_spacing;
                }
            } else {
                currentW = curComp.getPreferredSize().width;
            }
            curComp.setBounds(currentX, currentY, currentW, currentH);
            if (curCons != null && curCons.isKeptWithNext()) {
                currentX += currentW + this.m_spacing;
                continue;
            }
            currentX = insets.left;
            currentY += currentH + this.m_spacing;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int currentX = 0;
        int currentY = 0;
        int currentW = 0;
        int currentH = 0;
        int runningW = 0;
        int runningH = 0;
        int keptH = 0;
        int keptW = 0;
        Insets insets = parent.getInsets();
        for (int i2 = 0; i2 < this.m_items.size(); ++i2) {
            Component curComp = (Component)this.m_items.elementAt(i2);
            PropertyComponentGroupLayoutConstraints curCons = (PropertyComponentGroupLayoutConstraints)this.m_constraints.get(curComp);
            currentH = curComp.getPreferredSize().height;
            if (curComp instanceof JTextField || curComp instanceof HackFixComboBox) {
                currentW = this.m_max_width;
                if (i2 < this.m_items.size() - 1 && this.m_items.elementAt(i2 + 1) instanceof JButton && curCons != null && curCons.isKeptWithNext()) {
                    currentW = currentW - ((JButton)this.m_items.elementAt((int)(i2 + 1))).getPreferredSize().width - this.m_spacing;
                }
            } else {
                currentW = curComp.getPreferredSize().width;
            }
            keptW += currentW;
            keptH = Math.max(keptH, currentH);
            if (curCons != null && curCons.isKeptWithNext()) {
                keptW += this.m_spacing;
                currentX = currentW + this.m_spacing;
                continue;
            }
            currentX = 0;
            currentY += currentH + this.m_spacing;
            runningH += keptH + this.m_spacing;
            keptH = 0;
            runningW = Math.max(runningW, keptW);
            keptW = 0;
        }
        return new Dimension(runningW + insets.left + insets.right, runningH + insets.top + insets.bottom);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.reevaluateMaxWidth();
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    protected void reevaluateMaxWidth() {
    }

    public static void main(String[] args) {
        JFrame testFrame = new JFrame();
        PropertyComponentGroupLayoutConstraints keepCons = new PropertyComponentGroupLayoutConstraints(true);
        PropertyComponentGroupLayoutConstraints normCons = new PropertyComponentGroupLayoutConstraints();
        testFrame.getContentPane().setLayout(new PropertyComponentGroupLayout());
        testFrame.getContentPane().add((Component)new JLabel("Name"), normCons);
        testFrame.getContentPane().add((Component)new JTextField(), keepCons);
        testFrame.getContentPane().add((Component)new JButton("Browse"), normCons);
        testFrame.getContentPane().add((Component)new JLabel("Address"), normCons);
        testFrame.getContentPane().add((Component)new JTextField(), normCons);
        testFrame.getContentPane().add((Component)new JCheckBox("Option 1"), keepCons);
        testFrame.getContentPane().add((Component)new JCheckBox("Option 2"), keepCons);
        testFrame.getContentPane().add((Component)new JCheckBox("Option 3"), keepCons);
        testFrame.getContentPane().add((Component)new JCheckBox("Option 4"), normCons);
        testFrame.getContentPane().add((Component)new JLabel("Another Field"), normCons);
        testFrame.getContentPane().add((Component)new JTextField(), normCons);
        testFrame.pack();
        testFrame.setVisible(true);
    }
}

