/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.dialog;

import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bm.dialog.ObmDialogPanel;
import oracle.bm.util.MergeCloneable;
import oracle.bm.util.ResourcePicker;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;

public class ObmDialog {
    private boolean m_isResizable;
    private int m_isCancellable = 2;
    private Frame m_frame;
    private ResourcePicker m_resourcePicker;
    private ObmDialogPanel m_contentPanel;
    private boolean m_isValid;
    private Object m_object;
    private Object m_editObject;

    public ObmDialog(Frame parent) {
        this.m_frame = parent;
    }

    public void setMainPanel(ObmDialogPanel contentPanel) {
        if (contentPanel == null) {
            throw new IllegalArgumentException("Missing content panel");
        }
        this.m_contentPanel = contentPanel;
    }

    public void setCancellable(boolean cancellable) {
        this.m_isCancellable = cancellable ? 2 : 0;
    }

    protected void copyUpPanels(Object input) {
        this.m_contentPanel.copyUpPanel(input);
    }

    protected Object copyDownPanels() {
        return this.m_contentPanel.copyDownPanel(this.m_editObject);
    }

    public Object showDialog(Object input) {
        return this.showDialogIntern(input, input);
    }

    public Object showDialog(MergeCloneable input) {
        return this.showDialogIntern(input, input.clone());
    }

    private Object showDialogIntern(Object object, Object editObject) {
        JEWTDialog dialog = JEWTDialog.createDialog((Component)this.m_frame, (String)this.m_contentPanel.getTitleName(), (int)(1 | this.m_isCancellable | 4));
        dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if ("closed".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue()) && !ObmDialog.this.m_contentPanel.contentsValid()) {
                    throw new PropertyVetoException("Invalid", evt);
                }
            }
        });
        dialog.setResizable(this.m_isResizable);
        this.m_object = object;
        this.m_editObject = editObject;
        Component header = this.m_contentPanel.getHeader();
        if (header != null) {
            this.m_resourcePicker.fillComponent(header);
            dialog.setDialogHeader(header);
        }
        this.m_contentPanel.initPanel();
        this.copyUpPanels(this.m_editObject);
        this.m_resourcePicker.fillComponent(this.m_contentPanel);
        dialog.setContent((Component)this.m_contentPanel);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_contentPanel, this.m_contentPanel.getTopic());
        dialog.setInitialFocus(this.m_contentPanel.getInitialFocusComponent());
        if (WizardLauncher.runDialog((JDialog)dialog)) {
            this.m_isValid = true;
            if (this.m_object instanceof MergeCloneable) {
                Object returnedObject = this.copyDownPanels();
                ((MergeCloneable)this.m_object).copy(returnedObject);
            } else {
                this.m_object = this.copyDownPanels();
            }
            return this.m_object;
        }
        return null;
    }

    public boolean isValid() {
        return this.m_isValid;
    }

    public ResourcePicker getResourcePicker() {
        return this.m_resourcePicker;
    }

    public void setResourcePicker(ResourcePicker res) {
        this.m_resourcePicker = res;
    }

    public void setResizable(boolean resizable) {
        this.m_isResizable = resizable;
    }
}

