/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.browse.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.bm.browse.util.IconNode;

public class MultiTreeModel
implements TreeModel {
    private static final int NODES_CHANGED = 0;
    private static final int NODES_INSERTED = 1;
    private static final int NODES_REMOVED = 2;
    private static final int STRUCTURE_CHANGED = 3;
    private final Object m_root = new IconNode(){

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public String getText() {
            return "Root";
        }
    };
    private final MultiNode[] m_categories;
    private final ArrayList m_listeners = new ArrayList();

    public MultiTreeModel(TreeModel[] models) {
        if (models == null || models.length == 0) {
            throw new IllegalArgumentException("Missing models");
        }
        this.m_categories = new MultiNode[models.length];
        for (int i2 = models.length - 1; i2 >= 0; --i2) {
            TreeModel model = models[i2];
            if (model == null) {
                throw new IllegalArgumentException("Missing model");
            }
            this.m_categories[i2] = new MultiNode(model, model.getRoot());
            model.addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                    TreePath path = MultiTreeModel.this.transformPath(e);
                    MultiTreeModel.this.fireTreeModelEvent(0, path, e.getChildIndices(), this.getLast(path).getChildren(e.getChildIndices()));
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                    TreePath path = MultiTreeModel.this.transformPath(e);
                    this.getLast(path).insert(e.getChildIndices());
                    MultiTreeModel.this.fireTreeModelEvent(1, path, e.getChildIndices(), this.getLast(path).getChildren(e.getChildIndices()));
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                    TreePath path = MultiTreeModel.this.transformPath(e);
                    this.getLast(path).remove(e.getChildIndices());
                    MultiTreeModel.this.fireTreeModelEvent(2, path, e.getChildIndices(), null);
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                    Object mnode;
                    TreePath path = MultiTreeModel.this.transformPath(e);
                    MultiNode node = this.getLast(path);
                    if (path.getPathCount() == 2 && (mnode = e.getTreePath().getLastPathComponent()) != node.getNode()) {
                        node.setNode(mnode);
                        path = path.getParentPath();
                    }
                    node.structureChanged();
                    MultiTreeModel.this.fireTreeModelEvent(3, path, null, null);
                }

                private MultiNode getLast(TreePath path) {
                    return (MultiNode)path.getLastPathComponent();
                }
            });
        }
        Arrays.sort(this.m_categories, new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }

            public boolean equals(Object o1, Object o2) {
                return this.compare(o1, o2) == 0;
            }
        });
    }

    @Override
    public Object getRoot() {
        return this.m_root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (this.m_root == parent) {
            if (index >= 0 && index < this.m_categories.length) {
                return this.m_categories[index];
            }
        } else {
            return ((MultiNode)parent).getChild(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        return this.m_root == parent ? this.m_categories.length : ((MultiNode)parent).getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.m_root == node ? false : ((MultiNode)node).isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        Object[] nodes = path.getPath();
        Object[] newPath = new Object[nodes.length - 1];
        int i2 = nodes.length - 1;
        while (i2 > 0) {
            MultiNode mn = (MultiNode)nodes[i2];
            newPath[--i2] = mn.getNode();
        }
        TreeModel model = ((MultiNode)nodes[1]).getModel();
        model.valueForPathChanged(new TreePath(newPath), newValue);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (child == null || parent == null) {
            return -1;
        }
        if (this.m_root == parent) {
            for (int i2 = this.m_categories.length - 1; i2 >= 0; --i2) {
                if (this.m_categories[i2] != child) continue;
                return i2;
            }
            return -1;
        }
        return ((MultiNode)parent).getIndexOfChild(child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.m_listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.m_listeners.remove(l);
    }

    private void fireTreeModelEvent(int type, TreePath path, int[] childIndices, Object[] children) {
        if (this.m_listeners.size() > 0) {
            TreeModelListener[] listeners = this.m_listeners.toArray(new TreeModelListener[this.m_listeners.size()]);
            TreeModelEvent e = new TreeModelEvent((Object)this, path, childIndices, children);
            block6: for (int i2 = listeners.length - 1; i2 >= 0; --i2) {
                TreeModelListener l = listeners[i2];
                switch (type) {
                    case 0: {
                        l.treeNodesChanged(e);
                        continue block6;
                    }
                    case 1: {
                        l.treeNodesInserted(e);
                        continue block6;
                    }
                    case 2: {
                        l.treeNodesRemoved(e);
                        continue block6;
                    }
                    case 3: {
                        l.treeStructureChanged(e);
                    }
                }
            }
        }
    }

    private TreePath transformPath(TreeModelEvent e) {
        int i2;
        TreeModel model = (TreeModel)e.getSource();
        TreePath path = e.getTreePath();
        Object[] entries = path.getPath();
        Object[] newPath = new Object[entries.length + 1];
        newPath[0] = this.m_root;
        for (i2 = this.m_categories.length - 1; i2 >= 0; --i2) {
            if (model != this.m_categories[i2].getModel()) continue;
            newPath[1] = this.m_categories[i2];
            break;
        }
        i2 = 1;
        while (i2 < entries.length) {
            MultiNode parent = (MultiNode)newPath[i2];
            Object child = entries[i2];
            newPath[++i2] = parent.getChild(model.getIndexOfChild(parent.getNode(), child));
        }
        return new TreePath(newPath);
    }

    public static final class MultiNode
    implements IconNode {
        private TreeModel m_model;
        private Object m_node;
        private ArrayList m_children;

        public MultiNode(TreeModel model, Object node) {
            this.m_model = model;
            this.m_node = node;
        }

        private TreeModel getModel() {
            return this.m_model;
        }

        public Object getNode() {
            return this.m_node;
        }

        private void setNode(Object node) {
            this.m_node = node;
        }

        private Object getChild(int i2) {
            this.initChildren();
            Object node = this.m_children.get(i2);
            if (node == null) {
                node = new MultiNode(this.m_model, this.m_model.getChild(this.m_node, i2));
                this.m_children.set(i2, node);
            }
            return node;
        }

        private int getChildCount() {
            this.initChildren();
            return this.m_children.size();
        }

        private Object[] getChildren(int[] indices) {
            if (indices == null) {
                return null;
            }
            Object[] children = new Object[indices.length];
            for (int i2 = indices.length - 1; i2 >= 0; --i2) {
                children[i2] = this.getChild(indices[i2]);
            }
            return children;
        }

        private boolean isLeaf() {
            return this.m_model.isLeaf(this.m_node);
        }

        private int getIndexOfChild(Object child) {
            this.initChildren();
            return this.m_children.indexOf(child);
        }

        private void insert(int[] childIndices) {
            if (!this.initChildren()) {
                for (int i2 = 0; i2 < childIndices.length; ++i2) {
                    this.m_children.add(childIndices[i2], null);
                }
            }
        }

        private void remove(int[] childIndices) {
            if (!this.initChildren()) {
                for (int i2 = childIndices.length - 1; i2 >= 0; --i2) {
                    this.m_children.remove(childIndices[i2]);
                }
            }
        }

        private void structureChanged() {
            this.m_children = null;
        }

        @Override
        public Icon getIcon() {
            return this.m_node instanceof IconNode ? ((IconNode)this.m_node).getIcon() : null;
        }

        @Override
        public String getText() {
            return this.m_node instanceof IconNode ? ((IconNode)this.m_node).getText() : this.m_node.toString();
        }

        public String toString() {
            return this.getText();
        }

        private boolean initChildren() {
            if (this.m_children == null) {
                int size = this.m_model.getChildCount(this.m_node);
                this.m_children = new ArrayList(size);
                for (int i2 = size - 1; i2 >= 0; --i2) {
                    this.m_children.add(null);
                }
                return true;
            }
            return false;
        }
    }
}

