/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.browse;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import javax.swing.tree.TreeModel;
import oracle.bm.browse.SelectableTypeRecognizer;

public class SelectableTypeRecognizerRegistry {
    private static final SelectableTypeRecognizerRegistry INSTANCE = new SelectableTypeRecognizerRegistry();
    private ArrayList m_recognizers = new ArrayList();

    private SelectableTypeRecognizerRegistry() {
    }

    public void register(SelectableTypeRecognizer str) {
        if (str == null) {
            throw new IllegalArgumentException("Missing recognizer");
        }
        this.m_recognizers.add(str);
    }

    public TreeModel[] createTreeModels(Transferable context, Object[] selectableTypes, DataFlavor[] flavors) {
        if (context == null) {
            throw new IllegalArgumentException("Missing context");
        }
        if (selectableTypes == null) {
            throw new IllegalArgumentException("Missing types");
        }
        if (flavors == null) {
            throw new IllegalArgumentException("Missing flavors");
        }
        ArrayList<TreeModel> models = new ArrayList<TreeModel>(this.m_recognizers.size());
        for (int i2 = this.m_recognizers.size() - 1; i2 >= 0; --i2) {
            TreeModel tm = ((SelectableTypeRecognizer)this.m_recognizers.get(i2)).createTreeModel(context, selectableTypes, flavors);
            if (tm == null || tm.getRoot() == null || tm.getChildCount(tm.getRoot()) <= 0) continue;
            models.add(tm);
        }
        return models.toArray(new TreeModel[models.size()]);
    }

    public static SelectableTypeRecognizerRegistry getInstance() {
        return INSTANCE;
    }
}

