/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.browse;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.bm.browse.BrowseTree;
import oracle.bm.browse.CompositeCreator;
import oracle.bm.browse.util.AbstractItemPicker;
import oracle.bm.browse.util.MultiTreeModel;
import oracle.bm.util.ResourcePicker;
import oracle.bm.util.ui.EnablingJPanel;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.BundleLoader;

public class ElementPicker
extends AbstractItemPicker {
    private DataFlavor[] m_selectableFlavors;
    private JTree m_tree;
    private boolean m_createPanelEnabled = true;
    private EnablingJPanel m_createPanel;
    private DefaultComboBoxModel m_typeList;
    private JComboBox m_typeField;
    private JTextField m_nameField;
    private JButton m_newButton;
    private Component m_component;
    private boolean m_isItemSelected = false;

    public ElementPicker(TreeModel[] models, boolean canMultiSelect, boolean canCreate, DataFlavor[] selectableFlavors) {
        if (selectableFlavors == null || selectableFlavors.length == 0) {
            throw new IllegalArgumentException("Missing selectables");
        }
        this.m_tree = new BrowseTree(new MultiTreeModel(models), canMultiSelect);
        this.m_selectableFlavors = selectableFlavors;
        this.m_component = new JScrollPane(this.m_tree);
        class TreeListener
        extends MouseAdapter
        implements TreeSelectionListener {
            TreeListener() {
            }

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ElementPicker.this.m_isItemSelected = ElementPicker.this.checkItemSelected();
                ElementPicker.this.firePropertyChange();
                ElementPicker.this.updateCreatePanel();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ElementPicker.this.fireActionPerformed();
                }
            }
        }
        TreeListener listener = new TreeListener();
        this.m_tree.addTreeSelectionListener(listener);
        this.m_tree.addMouseListener(listener);
        if (canCreate) {
            this.m_createPanel = new EnablingJPanel();
            this.m_createPanel.setBorder(new EmptyBorder(15, 0, 0, 0));
            JLabel typeLabel = new JLabel();
            typeLabel.setName("ElementPicker.typefield");
            this.m_typeList = new DefaultComboBoxModel();
            this.m_typeField = new JComboBox(this.m_typeList);
            typeLabel.setLabelFor(this.m_typeField);
            JLabel nameLabel = new JLabel();
            nameLabel.setName("ElementPicker.namefield");
            this.m_nameField = new JTextField();
            nameLabel.setLabelFor(this.m_nameField);
            this.m_newButton = new JButton();
            this.m_newButton.setName("ElementPicker.newbutton");
            LayoutBuilder builder = new LayoutBuilder();
            builder.setDefaultAnchor(17);
            builder.add((Component)typeLabel, LayoutBuilder.LABEL_INSETS, 1, false, false);
            builder.add((Component)this.m_typeField, LayoutBuilder.CONTROL_INSETS, 1, false, true);
            builder.nl();
            builder.add((Component)nameLabel, LayoutBuilder.LABEL_INSETS, 1, false, false);
            builder.add((Component)this.m_nameField, LayoutBuilder.CONTROL_INSETS, 1, false, true);
            builder.addHGap(10);
            builder.add((Component)this.m_newButton, null, 1, false, false);
            builder.addToPanel((Container)this.m_createPanel);
            final ResourcePicker rp = new ResourcePicker(BundleLoader.getBundle((String)"oracle.bm.browse.res.ModelBrowserResources"));
            rp.fillComponent(this.m_createPanel);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add(this.m_component, "Center");
            panel.add((Component)this.m_createPanel, "South");
            this.m_component = panel;
            class CreateCompositeAction
            implements ActionListener,
            TreeModelListener,
            DocumentListener {
                private TreePath m_longestPath;

                CreateCompositeAction() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    Object node = ElementPicker.this.m_tree.getLastSelectedPathComponent();
                    node = ((MultiTreeModel.MultiNode)node).getNode();
                    this.m_longestPath = null;
                    ElementPicker.this.m_tree.getModel().addTreeModelListener(this);
                    try {
                        ((CompositeCreator)node).createComposite(ElementPicker.this.m_typeList.getSelectedItem(), ElementPicker.this.m_nameField.getText());
                        if (this.m_longestPath != null) {
                            ElementPicker.this.m_tree.setSelectionPath(this.m_longestPath);
                            ElementPicker.this.m_nameField.setText("");
                        }
                    }
                    catch (CompositeCreator.CreationFailureException cfe) {
                        MessageDialog.error((Component)ElementPicker.this.m_component, (Object)cfe.getMessage(), (String)rp.getString("CreationFailed.dialogtitle"), (String)cfe.getHelpTag());
                    }
                    finally {
                        ElementPicker.this.m_tree.getModel().removeTreeModelListener(this);
                        if (ElementPicker.this.m_createPanelEnabled) {
                            ElementPicker.this.m_nameField.requestFocusInWindow();
                        } else {
                            ElementPicker.this.m_tree.requestFocusInWindow();
                        }
                    }
                }

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                    this.setPath(e.getTreePath());
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                    this.setPath(e.getTreePath().pathByAddingChild(e.getChildren()[0]));
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                    this.m_longestPath = null;
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                    this.m_longestPath = null;
                }

                private void setPath(TreePath path) {
                    if (this.m_longestPath == null || path != null && path.getPathCount() > this.m_longestPath.getPathCount()) {
                        this.m_longestPath = path;
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.enableNewButton();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.enableNewButton();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.enableNewButton();
                }

                private void enableNewButton() {
                    ElementPicker.this.enableNewButton(true);
                }
            }
            CreateCompositeAction cca = new CreateCompositeAction();
            this.m_nameField.getDocument().addDocumentListener(cca);
            this.m_newButton.addActionListener(cca);
            this.updateCreatePanel();
        }
    }

    public boolean addSelectedItems(Transferable[] selectedItems) {
        for (int i2 = selectedItems.length - 1; i2 >= 0; --i2) {
            if (this.checkItemSelectable(selectedItems[i2]) != null) continue;
            return false;
        }
        return true;
    }

    public boolean canAcceptFlavors(DataFlavor[] flavors) {
        block0: for (int i2 = flavors.length - 1; i2 >= 0; --i2) {
            for (int j = this.m_selectableFlavors.length - 1; j >= 0; --j) {
                if (this.m_selectableFlavors[j].equals(flavors[i2])) continue block0;
            }
            return false;
        }
        return true;
    }

    public void deselectAll() {
        this.m_tree.clearSelection();
    }

    public Transferable[] getAllSelectableItems() {
        return NO_TRANSFERABLES;
    }

    public Component getComponent() {
        return this.m_component;
    }

    public Transferable[] getSelectedItems() {
        TreePath[] paths = this.m_tree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return NO_TRANSFERABLES;
        }
        ArrayList<Transferable> list = new ArrayList<Transferable>(paths.length);
        for (int i2 = 0; i2 < paths.length; ++i2) {
            Transferable node = this.checkItemSelectable(paths[i2].getLastPathComponent());
            if (node == null) continue;
            list.add(node);
        }
        return list.toArray(new Transferable[list.size()]);
    }

    public DataFlavor[] getSelectionDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[this.m_selectableFlavors.length];
        System.arraycopy(this.m_selectableFlavors, 0, flavors, 0, this.m_selectableFlavors.length);
        return flavors;
    }

    public boolean isItemSelected() {
        return this.m_isItemSelected;
    }

    public boolean isSelectableItemPresent() {
        return this.m_tree.getRowCount() > 0;
    }

    public void removeAllSelectableItems() {
        this.deselectAll();
    }

    public void removeSelectedItems() {
        this.deselectAll();
    }

    private boolean checkItemSelected() {
        TreePath[] paths = this.m_tree.getSelectionPaths();
        if (paths != null) {
            for (int i2 = 0; i2 < paths.length; ++i2) {
                if (this.checkItemSelectable(paths[i2].getLastPathComponent()) == null) continue;
                return true;
            }
        }
        return false;
    }

    private void updateCreatePanel() {
        if (this.m_createPanel != null) {
            Object node;
            if (this.m_tree.getSelectionCount() == 1 && (node = ((MultiTreeModel.MultiNode)this.m_tree.getLastSelectedPathComponent()).getNode()) instanceof CompositeCreator) {
                Object oldSelection = this.m_typeList.getSelectedItem();
                Object[] types = ((CompositeCreator)node).getCompositeTypes();
                if (types != null && types.length > 0) {
                    this.m_typeList.removeAllElements();
                    for (int i2 = 0; i2 < types.length; ++i2) {
                        this.m_typeList.addElement(types[i2]);
                    }
                    if (oldSelection != null && this.m_typeList.getIndexOf(oldSelection) != -1) {
                        this.m_typeList.setSelectedItem(oldSelection);
                    }
                    this.enableCreatePanel(true);
                    return;
                }
            }
            this.enableCreatePanel(false);
        }
    }

    private void enableCreatePanel(final boolean enable) {
        if (this.m_createPanelEnabled ^ enable) {
            this.m_createPanelEnabled = enable;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ElementPicker.this.m_createPanel.setEnabled(enable);
                    ElementPicker.this.m_typeField.setEnabled(enable);
                    ElementPicker.this.m_nameField.setEnabled(enable);
                    ElementPicker.this.enableNewButton(enable);
                }
            });
        }
    }

    private void enableNewButton(boolean enable) {
        this.m_newButton.setEnabled(enable && this.m_nameField.getDocument().getLength() > 0);
    }

    private Transferable checkItemSelectable(Object o) {
        if (o instanceof MultiTreeModel.MultiNode) {
            o = ((MultiTreeModel.MultiNode)o).getNode();
        }
        if (o instanceof Transferable) {
            Transferable t = (Transferable)o;
            for (int i2 = this.m_selectableFlavors.length - 1; i2 >= 0; --i2) {
                if (!t.isDataFlavorSupported(this.m_selectableFlavors[i2])) continue;
                return t;
            }
        }
        return null;
    }
}

