/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vcs;

import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.vcs.VCSListener;
import oracle.ide.vcs.VCSTask;
import oracle.javatools.jndi.Names;

public abstract class VCSManager
implements Addin {
    private static final Collection<String> _workspaceArtifactPaths = new HashSet<String>();
    private static final String VCS_MANAGER_NAME = "ide/vcs-manager";

    public static VCSManager getVCSManager() {
        VCSManager vcsManager = (VCSManager)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)VCS_MANAGER_NAME);
        return vcsManager != null ? vcsManager : NullVCSManager.getInstance();
    }

    public static void setVCSManager(VCSManager vcsManager) {
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)VCS_MANAGER_NAME, (Object)vcsManager);
    }

    public abstract Future<Boolean> checkOutUsingUI(VCSTask var1);

    public abstract boolean checkOut(URL[] var1);

    public abstract boolean isVersioned(URL var1);

    @Deprecated
    public abstract boolean isAutoCheckOutEnabled(URL var1);

    public abstract boolean canCheckOut(URL var1);

    @Deprecated
    public abstract boolean setReadWrite(URL[] var1);

    @Deprecated
    public abstract boolean checkOutNode(Node var1);

    @Deprecated
    public abstract boolean checkOutNode(Node var1, CommandProcessor var2);

    public abstract String getCheckOutCommand(Node var1);

    public abstract void validateStatus(URL var1);

    public abstract void validateStatus(URLFilter var1);

    public abstract void addVCSListener(VCSListener var1, URLFilter var2);

    public abstract void removeVCSListener(VCSListener var1);

    public abstract String getVersionName(URL var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerWorkspaceArtifact(String path) {
        Collection<String> collection = _workspaceArtifactPaths;
        synchronized (collection) {
            _workspaceArtifactPaths.add(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Collection<String> getWorkspaceArtifacts() {
        Collection<String> collection = _workspaceArtifactPaths;
        synchronized (collection) {
            return Collections.unmodifiableCollection(new ArrayList<String>(_workspaceArtifactPaths));
        }
    }

    @Deprecated
    public final void deregisterWorkspaceArtifact(String path) {
    }

    public abstract boolean containsConflicts(URL var1);

    public abstract InputStream openConflictsStreamAsContributor(URL var1) throws IOException;

    public abstract ContextMenuListener[] getContextMenuListeners();

    public abstract Locatable[] getContextLocatables(Context var1);

    protected abstract boolean executeTaskImpl(VCSTask var1);

    protected final Map getTaskProperties(VCSTask task) {
        return task.getProperties();
    }

    public final void deleteRecursively(URL url) throws IOException, InterruptedException {
        this.deleteRecursively(url, null, false);
    }

    public void deleteRecursively(URL url, URLFilter filter, boolean tolerant) throws IOException, InterruptedException {
        if (EventQueue.isDispatchThread()) {
            new IllegalStateException("deleteRecursively() called from AWT event thread").printStackTrace();
        }
        if (!this._deleteRecursively(url, filter, tolerant, true, new boolean[1])) {
            throw new IOException("Unable to delete " + URLFileSystem.getPath((URL)url));
        }
    }

    private final boolean _deleteRecursively(URL url, URLFilter filter, boolean tolerant, boolean success, boolean[] var_filtered) throws IOException, InterruptedException {
        URLFileSystem.FileInfo[] children;
        if (filter != null && !filter.accept(url)) {
            var_filtered[0] = true;
            return success;
        }
        boolean[] filtered = new boolean[1];
        if (URLFileSystem.isDirectory((URL)url) && (children = URLFileSystem.ls((URL)url)) != null) {
            for (URLFileSystem.FileInfo child : children) {
                success = success && this._deleteRecursively(child.getURL(), filter, tolerant, success, filtered);
            }
            if (children.length > 0 && Thread.interrupted()) {
                throw new InterruptedException();
            }
        }
        if (filtered[0]) {
            var_filtered[0] = true;
            return success;
        }
        if (URLFileSystem.delete((URL)url)) {
            return success;
        }
        if (tolerant) {
            return false;
        }
        throw new IOException("Unable to delete " + URLFileSystem.getPath((URL)url));
    }

    private static class NullVCSManager
    extends VCSManager {
        private static final NullVCSManager _instance = new NullVCSManager();

        private NullVCSManager() {
        }

        public static NullVCSManager getInstance() {
            return _instance;
        }

        @Override
        public void initialize() {
        }

        @Override
        public Future<Boolean> checkOutUsingUI(VCSTask task) {
            return this.executeNullTask();
        }

        private final Future<Boolean> executeNullTask() {
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return false;
                }
            });
            task.run();
            return task;
        }

        @Override
        public boolean checkOut(URL[] urls) {
            for (URL url : urls) {
                if (!URLFileSystem.isReadOnly((URL)url)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isVersioned(URL url) {
            return false;
        }

        @Override
        @Deprecated
        public boolean isAutoCheckOutEnabled(URL url) {
            return false;
        }

        @Override
        public boolean canCheckOut(URL url) {
            return false;
        }

        @Override
        @Deprecated
        public boolean checkOutNode(Node node) {
            return false;
        }

        @Override
        @Deprecated
        public boolean checkOutNode(Node node, CommandProcessor processor) {
            return false;
        }

        @Override
        public String getCheckOutCommand(Node node) {
            return null;
        }

        @Override
        public void validateStatus(URL url) {
        }

        @Override
        public void validateStatus(URLFilter filter) {
        }

        @Override
        public void addVCSListener(VCSListener listener, URLFilter filter) {
        }

        @Override
        public void removeVCSListener(VCSListener listener) {
        }

        @Override
        public String getVersionName(URL url) {
            return null;
        }

        @Override
        @Deprecated
        public boolean setReadWrite(URL[] urls) {
            return false;
        }

        @Override
        public boolean containsConflicts(URL url) {
            return false;
        }

        @Override
        public InputStream openConflictsStreamAsContributor(URL url) throws IOException {
            return URLFileSystem.openInputStream((URL)url);
        }

        @Override
        public ContextMenuListener[] getContextMenuListeners() {
            return new ContextMenuListener[0];
        }

        @Override
        public Locatable[] getContextLocatables(Context context) {
            if (context.getSelection() == null) {
                return new Locatable[0];
            }
            ArrayList<Locatable> locatables = new ArrayList<Locatable>();
            for (Element element : context.getSelection()) {
                if (!(element instanceof Locatable) || ((Locatable)((Object)element)).getURL() == null) continue;
                locatables.add((Locatable)((Object)element));
            }
            return locatables.toArray(new Locatable[0]);
        }

        @Override
        protected boolean executeTaskImpl(VCSTask task) {
            return false;
        }
    }
}

