/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util.dnd;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.ide.util.dnd.DragHelper;
import oracle.ide.util.dnd.DropHelper;

public class DragDropManager {
    private HashMap registry = new HashMap();
    private static DragDropManager instance;

    private DragDropManager() {
    }

    public static DragDropManager getInstance() {
        if (instance == null) {
            instance = new DragDropManager();
        }
        return instance;
    }

    public void registerDragHelperForInstance(DragHelper helper, Class supportedClass) {
        this.registerDragHelper(helper, supportedClass, false);
    }

    public void registerDragHelperForType(DragHelper helper, Class supportedClass) {
        this.registerDragHelper(helper, supportedClass, true);
    }

    public void unRegisterDragHelperForInstance(DragHelper helper, Class dragClass) {
        this.unRegisterDragHelper(helper, dragClass, false);
    }

    public void unRegisterDragHelperForType(DragHelper helper, Class cls) {
        this.unRegisterDragHelper(helper, cls, true);
    }

    public Iterator getDragHelpers(Class registeredClass) {
        ArrayList<DragHelper> list = new ArrayList<DragHelper>();
        if (this.registry.keySet().contains(registeredClass)) {
            RegInfo info = (RegInfo)this.registry.get(registeredClass);
            list.addAll(info.getDragHelpers(true));
        }
        for (Class cls : this.registry.keySet()) {
            if (!cls.isAssignableFrom(registeredClass)) continue;
            RegInfo info = (RegInfo)this.registry.get(cls);
            for (DragHelper dh : info.getDragHelpers(false)) {
                if (list.contains(dh)) continue;
                list.add(dh);
            }
        }
        return list.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDragHelper(DragHelper helper, Class cls, boolean isExactMatch) {
        if (helper == null) {
            throw new IllegalArgumentException("The DropHelper cannot be null.");
        }
        if (cls == null) {
            throw new IllegalArgumentException("The supplied class cannot be null.");
        }
        HashMap hashMap = this.registry;
        synchronized (hashMap) {
            if (!this.registry.containsKey(cls)) {
                RegInfo info = new RegInfo();
                info.addDragHelper(helper, isExactMatch);
                this.registry.put(cls, info);
            } else {
                RegInfo info = (RegInfo)this.registry.get(cls);
                info.addDragHelper(helper, isExactMatch);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unRegisterDragHelper(DragHelper helper, Class cls, boolean isExactMatch) {
        if (helper == null || cls == null) {
            return;
        }
        HashMap hashMap = this.registry;
        synchronized (hashMap) {
            if (this.registry.containsKey(cls)) {
                RegInfo info = (RegInfo)this.registry.get(cls);
                info.removeDragHelper(helper, isExactMatch);
                if (info.shouldCleanUp()) {
                    info = null;
                    this.registry.remove(cls);
                }
            }
        }
    }

    public void registerDropHelperForInstance(DropHelper helper, Class supportedClass) {
        this.registerDropHelper(helper, supportedClass, false);
    }

    public void registerDropHelperForType(DropHelper helper, Class supportedClass) {
        this.registerDropHelper(helper, supportedClass, true);
    }

    public void unRegisterDropHelperForInstance(DropHelper helper, Class registeredClass) {
        this.unRegisterDropHelper(helper, registeredClass, false);
    }

    public void unRegisterDropHelperForType(DropHelper helper, Class registeredClass) {
        this.unRegisterDropHelper(helper, registeredClass, true);
    }

    public Iterator getDropHelpers(Class registeredClass) {
        ArrayList<DropHelper> list = new ArrayList<DropHelper>();
        if (this.registry.keySet().contains(registeredClass)) {
            RegInfo info = (RegInfo)this.registry.get(registeredClass);
            list.addAll(info.getDropHelpers(true));
        }
        for (Class cls : this.registry.keySet()) {
            if (!cls.isAssignableFrom(registeredClass)) continue;
            RegInfo info = (RegInfo)this.registry.get(cls);
            for (DropHelper dh : info.getDropHelpers(false)) {
                if (list.contains(dh)) continue;
                list.add(dh);
            }
        }
        return list.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDropHelper(DropHelper helper, Class cls, boolean isExactMatch) {
        if (helper == null) {
            throw new IllegalArgumentException("The DropHelper cannot be null.");
        }
        if (cls == null) {
            throw new IllegalArgumentException("The supplied class cannot be null.");
        }
        HashMap hashMap = this.registry;
        synchronized (hashMap) {
            if (!this.registry.containsKey(cls)) {
                RegInfo info = new RegInfo();
                info.addDropHelper(helper, isExactMatch);
                this.registry.put(cls, info);
            } else {
                RegInfo info = (RegInfo)this.registry.get(cls);
                info.addDropHelper(helper, isExactMatch);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unRegisterDropHelper(DropHelper helper, Class cls, boolean isExactMatch) {
        if (helper == null || cls == null) {
            return;
        }
        HashMap hashMap = this.registry;
        synchronized (hashMap) {
            if (this.registry.containsKey(cls)) {
                RegInfo info = (RegInfo)this.registry.get(cls);
                info.removeDropHelper(helper, isExactMatch);
                if (info.shouldCleanUp()) {
                    info = null;
                    this.registry.remove(cls);
                }
            }
        }
    }

    private final class HelperData {
        ArrayList drag = new ArrayList(2);
        ArrayList drop = new ArrayList(2);

        public List getDragHelpers() {
            return this.drag;
        }

        public void addDragHelper(DragHelper helper) {
            if (!this.drag.contains(helper)) {
                this.drag.add(helper);
            }
        }

        public void removeDragHelper(DragHelper helper) {
            this.drag.remove(helper);
        }

        public List getDropHelpers() {
            return this.drop;
        }

        public void addDropHelper(DropHelper helper) {
            if (!this.drop.contains(helper)) {
                this.drop.add(helper);
            }
        }

        public void removeDropHelper(DropHelper helper) {
            this.drop.remove(helper);
        }
    }

    private final class RegInfo {
        HelperData matchInstance;
        HelperData matchExactType;

        public RegInfo() {
            this.matchInstance = new HelperData();
            this.matchExactType = new HelperData();
        }

        public boolean shouldCleanUp() {
            return this.matchInstance.getDragHelpers().size() == 0 && this.matchInstance.getDropHelpers().size() == 0 && this.matchExactType.getDragHelpers().size() == 0 && this.matchExactType.getDropHelpers().size() == 0;
        }

        public void addDragHelper(DragHelper helper, boolean strictTyping) {
            if (strictTyping) {
                this.matchExactType.addDragHelper(helper);
            } else {
                this.matchInstance.addDragHelper(helper);
            }
        }

        public List getDragHelpers(boolean exactMatch) {
            if (exactMatch) {
                return this.matchExactType.getDragHelpers();
            }
            return this.matchInstance.getDragHelpers();
        }

        public void removeDragHelper(DragHelper helper, boolean exactMatch) {
            if (exactMatch) {
                this.matchExactType.removeDragHelper(helper);
            } else {
                this.matchInstance.removeDragHelper(helper);
            }
        }

        public void addDropHelper(DropHelper helper, boolean strictTyping) {
            if (strictTyping) {
                this.matchExactType.addDropHelper(helper);
            } else {
                this.matchInstance.addDropHelper(helper);
            }
        }

        public List getDropHelpers(boolean exactMatch) {
            if (exactMatch) {
                return this.matchExactType.getDropHelpers();
            }
            return this.matchInstance.getDropHelpers();
        }

        public void removeDropHelper(DropHelper helper, boolean exactMatch) {
            if (exactMatch) {
                this.matchExactType.removeDropHelper(helper);
            } else {
                this.matchInstance.removeDropHelper(helper);
            }
        }
    }

    private static class WeightComparator
    implements Comparator {
        private WeightComparator() {
        }

        public int compare(Object o1, Object o2) {
            DropHelper dh1 = (DropHelper)o1;
            DropHelper dh2 = (DropHelper)o2;
            if (dh1.getWeight() < dh2.getWeight()) {
                return -1;
            }
            if (dh1.getWeight() > dh2.getWeight()) {
                return 1;
            }
            return 0;
        }
    }
}

