/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util.dnd;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.List;

public class DefaultDropTargetListener
implements DropTargetListener {
    public static final DataFlavor JAVA_FILELIST_FLAVOR = DataFlavor.javaFileListFlavor;
    private DropSite _dropSite;

    public DefaultDropTargetListener(DropSite dropSite) {
        this._dropSite = dropSite;
        new DropTarget(dropSite.getComponent(), dropSite.getActions(), this);
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        this.doDefaultAction(event);
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
        this.doDefaultAction(event);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
        this.doDefaultAction(event);
    }

    @Override
    public void dragExit(DropTargetEvent event) {
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        if ((event.getSourceActions() & this.getActions()) == 0) {
            event.rejectDrop();
            return;
        }
        try {
            Transferable transferable = event.getTransferable();
            for (DataFlavor flavor : this.getFlavors()) {
                if (!event.isDataFlavorSupported(flavor)) continue;
                this._dropSite.handleDrop(flavor, event, transferable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            event.rejectDrop();
        }
    }

    protected void doDefaultAction(DropTargetDragEvent event) {
        if (!this.isDragOK(event)) {
            event.rejectDrag();
            return;
        }
        event.acceptDrag(event.getDropAction());
    }

    protected boolean isDragOK(DropTargetDragEvent event) {
        if ((event.getDropAction() & this.getActions()) == 0) {
            return false;
        }
        return this.isDataFlavorSupported(event);
    }

    protected boolean isDataFlavorSupported(DropTargetDragEvent event) {
        for (DataFlavor flavor : this.getFlavors()) {
            if (!event.isDataFlavorSupported(flavor)) continue;
            return this._dropSite.canDrop(flavor, event);
        }
        return false;
    }

    private int getActions() {
        return this._dropSite.getActions();
    }

    private List getFlavors() {
        return this._dropSite.getFlavors();
    }

    public static interface DropSite {
        public Component getComponent();

        public int getActions();

        public List getFlavors();

        public boolean canDrop(DataFlavor var1, DropTargetDragEvent var2);

        public void handleDrop(DataFlavor var1, DropTargetDropEvent var2, Transferable var3) throws IOException, UnsupportedFlavorException;
    }
}

