/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import net.jcip.annotations.GuardedBy;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.view.View;
import oracle.javatools.util.WeightedList;

public class WeightedController
implements Controller {
    public static final Controller USE_ACTIVE_VIEW_CONTROLLER = new Controller(){

        @Override
        public boolean update(IdeAction action, Context context) {
            Controller controller;
            View view = context.getView();
            if (view != null && (controller = view.getController()) != null) {
                return controller.update(action, context);
            }
            return false;
        }

        @Override
        public boolean handleEvent(IdeAction action, Context context) {
            Controller controller;
            View view = context.getView();
            if (view != null && (controller = view.getController()) != null) {
                return controller.handleEvent(action, context);
            }
            return false;
        }
    };
    public static final Controller NOOP_CONTROLLER = new Controller(){

        @Override
        public boolean update(IdeAction action, Context context) {
            action.setEnabled(false);
            return true;
        }

        @Override
        public boolean handleEvent(IdeAction action, Context context) {
            return true;
        }
    };
    @GuardedBy(value="itself")
    private WeightedList<Controller> _controllers = new WeightedList(3);
    private static final String ACTION_CONTROLLER = "WeightedController";

    public WeightedController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WeightedController(Controller firstController, Controller lastController) {
        WeightedList<Controller> weightedList = this._controllers;
        synchronized (weightedList) {
            if (firstController != null) {
                this._controllers.add((Object)firstController, Double.MIN_VALUE);
            }
            if (lastController != null) {
                this._controllers.add((Object)lastController, Double.MAX_VALUE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addController(Controller controller, double weight) {
        if (controller == null || weight == Double.MAX_VALUE || weight == Double.MIN_VALUE) {
            throw new IllegalArgumentException();
        }
        WeightedList<Controller> weightedList = this._controllers;
        synchronized (weightedList) {
            this._controllers.add((Object)controller, weight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeController(Controller controller) {
        WeightedList<Controller> weightedList = this._controllers;
        synchronized (weightedList) {
            this._controllers.remove((Object)controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(IdeAction action, Context context) {
        Iterator iterator;
        boolean ret = false;
        String key = "WeightedController.update()";
        WeightedList<Controller> weightedList = this._controllers;
        synchronized (weightedList) {
            iterator = this._controllers.iterator();
        }
        while (!ret && iterator.hasNext()) {
            Controller controller = (Controller)iterator.next();
            ret = controller.update(action, context);
            if (!ret) continue;
            action.putValue(ACTION_CONTROLLER, new WeakReference<Controller>(controller));
            if (!IdeAction.DEBUG) continue;
            action.putValue("controller-handling-update", controller.getClass().getName());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        Iterator iterator;
        WeakReference weakReference = (WeakReference)action.getValue(ACTION_CONTROLLER);
        if (weakReference != null) {
            Controller controller = (Controller)weakReference.get();
            if (controller != null && controller.handleEvent(action, context)) {
                return true;
            }
            action.putValue(ACTION_CONTROLLER, null);
        }
        WeightedList<Controller> weightedList = this._controllers;
        synchronized (weightedList) {
            iterator = this._controllers.iterator();
        }
        while (iterator.hasNext()) {
            Controller controller = (Controller)iterator.next();
            if (!controller.handleEvent(action, context)) continue;
            return true;
        }
        return false;
    }
}

