/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.ArrayList;
import oracle.ide.util.PatternFilter;

public class PatternFiltersOptimizer {
    private static final String ASTERISK_ASTERISK = "**";
    private static final String ASTERISK_ASTERISK_SLASH = "**/";
    private static final String ASTERISK = "*";
    private ArrayList<Evaluator> m_endsWithEvaluators = new ArrayList();
    private ArrayList<Evaluator> m_containsEvaluators = new ArrayList();
    private ArrayList<Evaluator> m_vanillaEvaluators = new ArrayList();

    public void setPatternFilters(PatternFilter[] filters) {
        this.categorizeFilters(filters);
    }

    public PatternFilter getMatchingFilter(String target) {
        for (Evaluator evaluator : this.m_endsWithEvaluators) {
            if (!evaluator.matches(target)) continue;
            return evaluator.getFilter();
        }
        for (Evaluator evaluator : this.m_containsEvaluators) {
            if (!evaluator.matches(target)) continue;
            return evaluator.getFilter();
        }
        for (Evaluator evaluator : this.m_vanillaEvaluators) {
            if (!evaluator.matches(target)) continue;
            return evaluator.getFilter();
        }
        return null;
    }

    private void categorizeFilters(PatternFilter[] filters) {
        this.m_endsWithEvaluators.clear();
        this.m_containsEvaluators.clear();
        this.m_vanillaEvaluators.clear();
        if (filters == null) {
            return;
        }
        for (PatternFilter patternFilter : filters) {
            String pattern = patternFilter.getPattern();
            if (this.startsWithAsteriskAsteriskSlash(pattern)) {
                String patternSuffixAfterAAS = pattern.substring(ASTERISK_ASTERISK_SLASH.length());
                if (!this.endWithAsterisk(patternSuffixAfterAAS) && this.containsSingleOrNoneAstreisk(patternSuffixAfterAAS)) {
                    this.m_endsWithEvaluators.add(new EndsWithEvaluator(patternFilter));
                    continue;
                }
                this.m_containsEvaluators.add(new SequenceContainsEvaluator(patternFilter));
                continue;
            }
            this.m_vanillaEvaluators.add(new VanillaEvaluator(patternFilter));
        }
    }

    private boolean startsWithAsteriskAsteriskSlash(String source) {
        return source.startsWith(ASTERISK_ASTERISK_SLASH);
    }

    private boolean endWithAsterisk(String source) {
        return source.endsWith(ASTERISK);
    }

    private boolean containsSingleOrNoneAstreisk(String source) {
        int indexOfAsterisk = source.indexOf(ASTERISK);
        if (indexOfAsterisk != -1) {
            return indexOfAsterisk == source.lastIndexOf(ASTERISK);
        }
        return true;
    }

    public ArrayList<Evaluator> getEndsWithEvaluators() {
        return this.m_endsWithEvaluators;
    }

    public ArrayList<Evaluator> getContainsEvaluators() {
        return this.m_containsEvaluators;
    }

    public ArrayList<Evaluator> getOtherEvaluators() {
        return this.m_vanillaEvaluators;
    }

    class VanillaEvaluator
    extends Evaluator {
        private final boolean isAsteriskAsterisk;

        public VanillaEvaluator(PatternFilter filter) {
            super(filter);
            this.isAsteriskAsterisk = PatternFiltersOptimizer.ASTERISK_ASTERISK.equals(filter.getPattern());
        }

        @Override
        public boolean matches(String target) {
            return this.isAsteriskAsterisk ? true : this.getFilter().matches(target);
        }
    }

    class SequenceContainsEvaluator
    extends Evaluator {
        private String[] m_tokens;

        public SequenceContainsEvaluator(PatternFilter filter) {
            super(filter);
            String patternToMatchAgainst = filter.getPattern();
            this.m_tokens = patternToMatchAgainst.split("\\*{1,2}");
        }

        @Override
        public boolean matches(String target) {
            int currentIndex = 0;
            for (String token : this.m_tokens) {
                if (token.equals("")) continue;
                int indexOfNextMatch = target.indexOf(token, currentIndex);
                if (indexOfNextMatch == -1) {
                    return false;
                }
                currentIndex += token.length();
            }
            return true;
        }
    }

    class EndsWithEvaluator
    extends Evaluator {
        private final String m_suffix;

        public EndsWithEvaluator(PatternFilter filter) {
            super(filter);
            String patternToMatchAgainst = filter.getPattern();
            int indexOfAsterisk = patternToMatchAgainst.lastIndexOf(PatternFiltersOptimizer.ASTERISK);
            this.m_suffix = indexOfAsterisk != -1 ? (indexOfAsterisk + 1 < patternToMatchAgainst.length() ? (patternToMatchAgainst.charAt(indexOfAsterisk + 1) == '/' ? patternToMatchAgainst.substring(indexOfAsterisk + 2) : patternToMatchAgainst.substring(indexOfAsterisk + 1)) : patternToMatchAgainst) : filter.getPattern();
        }

        @Override
        public boolean matches(String target) {
            return target.endsWith(this.m_suffix);
        }
    }

    abstract class Evaluator {
        private final PatternFilter m_filter;

        public Evaluator(PatternFilter filter) {
            this.m_filter = filter;
        }

        PatternFilter getFilter() {
            return this.m_filter;
        }

        abstract boolean matches(String var1);
    }
}

