/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.awt.Rectangle;
import java.util.HashSet;
import javax.swing.JLayeredPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.ide.Ide;
import oracle.javatools.ui.ghost.GhostPalette;

public final class GhostPaletteUtil {
    private static final HashSet<String> showing = new HashSet(3);

    public static void show(final GhostPalette palette, final String key, JLayeredPane layeredPane, boolean fadeIn) {
        if (showing.contains(key)) {
            return;
        }
        final String xKey = key + ".x";
        final String yKey = key + ".y";
        String xStr = Ide.getProperty(xKey);
        String yStr = Ide.getProperty(yKey);
        int x = -1;
        int y = -1;
        if (xStr != null && yStr != null) {
            try {
                x = Integer.parseInt(xStr);
                y = Integer.parseInt(yStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        showing.add(key);
        AncestorListener listener = new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent e) {
                Rectangle r = palette.getBounds();
                Ide.setProperty(xKey, Integer.toString(r.x));
                Ide.setProperty(yKey, Integer.toString(r.y));
                palette.removeAncestorListener((AncestorListener)this);
                showing.remove(key);
            }

            @Override
            public void ancestorAdded(AncestorEvent e) {
            }

            @Override
            public void ancestorMoved(AncestorEvent e) {
            }
        };
        palette.addAncestorListener(listener);
        if (x != -1 && y != -1) {
            palette.setLocation(x, y);
            palette.show(layeredPane, false, fadeIn);
        } else {
            palette.show(layeredPane, true, fadeIn);
        }
    }

    public static void show(final GhostPalette palette, final String key, JLayeredPane layeredPane, boolean fadeIn, int w, int h) {
        if (showing.contains(key)) {
            return;
        }
        final String wKey = key + ".width";
        final String hKey = key + ".height";
        final String xKey = key + ".x";
        final String yKey = key + ".y";
        String wStr = Ide.getProperty(wKey);
        String hStr = Ide.getProperty(hKey);
        String xStr = Ide.getProperty(xKey);
        String yStr = Ide.getProperty(yKey);
        if (wStr != null && hStr != null) {
            try {
                w = Integer.parseInt(wStr);
                h = Integer.parseInt(hStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int x = -1;
        int y = -1;
        if (xStr != null && yStr != null) {
            try {
                x = Integer.parseInt(xStr);
                y = Integer.parseInt(yStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        showing.add(key);
        AncestorListener listener = new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent e) {
                Rectangle r = palette.getBounds();
                Ide.setProperty(wKey, Integer.toString(r.width));
                Ide.setProperty(hKey, Integer.toString(r.height));
                Ide.setProperty(xKey, Integer.toString(r.x));
                Ide.setProperty(yKey, Integer.toString(r.y));
                palette.removeAncestorListener((AncestorListener)this);
                showing.remove(key);
            }

            @Override
            public void ancestorAdded(AncestorEvent e) {
            }

            @Override
            public void ancestorMoved(AncestorEvent e) {
            }
        };
        palette.addAncestorListener(listener);
        if (x != -1 && y != -1) {
            palette.setBounds(x, y, w, h);
            palette.show(layeredPane, false, fadeIn);
        } else {
            palette.setBounds(new Rectangle(w, h));
            palette.show(layeredPane, true, fadeIn);
        }
    }

    private GhostPaletteUtil() {
    }
}

