/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.util.DefaultPropertyAccess;
import oracle.ide.util.IteratorFilter;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DefaultStructuredPropertyAccess
extends DefaultPropertyAccess
implements StructuredPropertyAccess {
    private String _name;
    private ArrayList _childNodes = new ArrayList();
    private static final String ESCAPE_STRING = "_escaped";
    private static final String ESCAPE_VALUE_STRING = "_escapedValue";
    private static final String TEXT = "TEXT";
    private static final Pattern pattern = Pattern.compile("^[./$<> ]|[/$<> ]+|^[0-9]$");

    public DefaultStructuredPropertyAccess(String name) {
        this.setName(name);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public Iterator getChildNodes() {
        return this._childNodes.iterator();
    }

    @Override
    public Iterator getChildNodes(final String name) {
        return new IteratorFilter(this.getChildNodes()){

            @Override
            protected boolean isValid(Object o) {
                StructuredPropertyAccess child = (StructuredPropertyAccess)o;
                return name.equals(child.getName());
            }
        };
    }

    @Override
    public StructuredPropertyAccess getChildNode(String name) {
        int size = this._childNodes.size();
        for (int i = 0; i < size; ++i) {
            StructuredPropertyAccess structuredPropertyAccess = (StructuredPropertyAccess)this._childNodes.get(i);
            if (!name.equals(structuredPropertyAccess.getName())) continue;
            return structuredPropertyAccess;
        }
        return null;
    }

    @Override
    public void insertChild(int position, StructuredPropertyAccess childNode) {
        this._childNodes.add(position, childNode);
    }

    @Override
    public void appendChild(StructuredPropertyAccess childNode) {
        this._childNodes.add(childNode);
    }

    private static boolean contains(StructuredPropertyAccess parent, StructuredPropertyAccess child) {
        if (parent == child) {
            return true;
        }
        Iterator childNodes = parent.getChildNodes();
        while (childNodes.hasNext()) {
            StructuredPropertyAccess childNode = (StructuredPropertyAccess)childNodes.next();
            if (!DefaultStructuredPropertyAccess.contains(childNode, child)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addAll(StructuredPropertyAccess other) {
        Iterator properties = other.getProperties();
        while (properties.hasNext()) {
            String key = (String)properties.next();
            String value = other.getProperty(key, null);
            this.setProperty(key, value);
        }
        Iterator childNodes = other.getChildNodes();
        while (childNodes.hasNext()) {
            StructuredPropertyAccess child = (StructuredPropertyAccess)childNodes.next();
            this.appendChild(child);
        }
    }

    @Override
    public void setBooleanProperty(String key, boolean value) {
        this.setProperty(key, Boolean.toString(value));
    }

    @Override
    public boolean getBooleanProperty(String key, boolean defaultValue) {
        Object property = this.get(key);
        boolean ret = property != null ? Boolean.valueOf(property.toString()) : defaultValue;
        return ret;
    }

    @Override
    public void setIntegerProperty(String key, int value) {
        this.setProperty(key, Integer.toString(value));
    }

    @Override
    public int getIntegerProperty(String key, int defaultValue) {
        Object property = this.get(key);
        int ret = property != null ? Integer.valueOf(property.toString()) : defaultValue;
        return ret;
    }

    @Override
    public void removeChild(StructuredPropertyAccess childNode) {
        this._childNodes.remove(childNode);
    }

    public void removeAllChildren() {
        this._childNodes.clear();
    }

    public boolean hasAttributes() {
        return !this._map.isEmpty();
    }

    public boolean hasChildNodes() {
        return !this._childNodes.isEmpty();
    }

    @Override
    public Iterator getProperties() {
        return this._map.keySet().iterator();
    }

    public static void saveToXML(StructuredPropertyAccess structuredPropertyAccess, File file) throws IOException {
        XMLDocument xmlDocument = new XMLDocument();
        Element element = DefaultStructuredPropertyAccess.saveToElement(structuredPropertyAccess, xmlDocument);
        xmlDocument.appendChild((Node)element);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        xmlDocument.print((OutputStream)bufferedOutputStream);
        bufferedOutputStream.close();
    }

    private static Element saveToElement(StructuredPropertyAccess structuredPropertyAccess, XMLDocument ownerDocument) {
        Element element;
        String nodeName = structuredPropertyAccess.getName();
        if (DefaultStructuredPropertyAccess.isValidKey(nodeName)) {
            try {
                element = ownerDocument.createElement(nodeName);
            }
            catch (DOMException e) {
                FeedbackManager.addFeedback("Failed to create element [" + nodeName + "]");
                throw e;
            }
        } else {
            element = ownerDocument.createElement(ESCAPE_STRING);
            element.setAttribute(ESCAPE_VALUE_STRING, nodeName);
        }
        int invalidKeys = 0;
        Iterator properties = structuredPropertyAccess.getProperties();
        while (properties.hasNext()) {
            String key = (String)properties.next();
            String property = structuredPropertyAccess.getProperty(key, null);
            if (DefaultStructuredPropertyAccess.isValidKey(key)) {
                element.setAttribute(key, property);
                continue;
            }
            element.setAttribute(ESCAPE_STRING + invalidKeys, property);
            element.setAttribute(ESCAPE_VALUE_STRING + invalidKeys, key);
            ++invalidKeys;
        }
        Iterator childNodes = structuredPropertyAccess.getChildNodes();
        while (childNodes.hasNext()) {
            StructuredPropertyAccess childPropertyAccess = (StructuredPropertyAccess)childNodes.next();
            try {
                Element childElement = DefaultStructuredPropertyAccess.saveToElement(childPropertyAccess, ownerDocument);
                element.appendChild(childElement);
            }
            catch (DOMException e) {
                FeedbackManager.reportException(e);
            }
        }
        return element;
    }

    private static boolean isValidKey(String name) {
        boolean valid;
        if (name == null || name.trim().length() == 0) {
            Logger.getAnonymousLogger().info("Invalid key - empty or null string");
            return false;
        }
        Matcher m = pattern.matcher(name);
        boolean bl = valid = !m.find();
        if (!valid) {
            Logger.getAnonymousLogger().info("Invalid key = " + name);
        }
        return valid;
    }

    public static DefaultStructuredPropertyAccess loadFromXML(File file) throws SAXException, XMLParseException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        DOMParser domParser = new DOMParser();
        domParser.setPreserveWhitespace(false);
        domParser.parse((InputStream)bufferedInputStream);
        XMLDocument xmlDocument = domParser.getDocument();
        Element root = xmlDocument.getDocumentElement();
        DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = DefaultStructuredPropertyAccess.loadFromElement(root);
        return defaultStructuredPropertyAccess;
    }

    private static DefaultStructuredPropertyAccess loadFromElement(Element root) {
        String escapedKeyKey;
        String escapedKey;
        String nodeName = root.getNodeName();
        DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = new DefaultStructuredPropertyAccess(nodeName);
        NamedNodeMap attributes = root.getAttributes();
        int attributesLength = attributes.getLength();
        for (int i = 0; i < attributesLength; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String key = attribute.getNodeName();
            String value = attribute.getNodeValue();
            defaultStructuredPropertyAccess.setProperty(key, value);
        }
        if (ESCAPE_STRING.equals(nodeName)) {
            String realNodeName = defaultStructuredPropertyAccess.getProperty(ESCAPE_VALUE_STRING, "");
            defaultStructuredPropertyAccess.setName(realNodeName);
            defaultStructuredPropertyAccess.removeProperty(ESCAPE_VALUE_STRING);
        }
        int escapedKeyCounter = 0;
        while ((escapedKey = defaultStructuredPropertyAccess.getProperty(escapedKeyKey = ESCAPE_STRING + escapedKeyCounter, null)) != null) {
            defaultStructuredPropertyAccess.removeProperty(escapedKeyKey);
            String escapedValueKey = ESCAPE_VALUE_STRING + escapedKeyCounter;
            String escapedValue = defaultStructuredPropertyAccess.getProperty(escapedValueKey, null);
            if (escapedValue == null) continue;
            defaultStructuredPropertyAccess.removeProperty(ESCAPE_VALUE_STRING + escapedKeyCounter);
            defaultStructuredPropertyAccess.setProperty(escapedKey, escapedValue);
        }
        NodeList childNodes = root.getChildNodes();
        int childrenLength = childNodes.getLength();
        block7: for (int i = 0; i < childrenLength; ++i) {
            Node childNode = childNodes.item(i);
            short nodeType = childNode.getNodeType();
            switch (nodeType) {
                case 1: {
                    Element element = (Element)childNode;
                    DefaultStructuredPropertyAccess child = DefaultStructuredPropertyAccess.loadFromElement(element);
                    defaultStructuredPropertyAccess.appendChild(child);
                    continue block7;
                }
                case 3: {
                    DefaultStructuredPropertyAccess child = new DefaultStructuredPropertyAccess(TEXT);
                    String value = childNode.getNodeValue();
                    child.put(TEXT, value);
                    defaultStructuredPropertyAccess.appendChild(child);
                    continue block7;
                }
                case 8: {
                    continue block7;
                }
            }
        }
        return defaultStructuredPropertyAccess;
    }
}

