/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.boot.IdeInvoker;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLPath;
import oracle.ide.test.internal.TipURLFileSystemHelper;
import oracle.ide.test.internal.TipURLStreamHandlerFactory;
import oracle.javatools.util.UnexpectedExceptionError;

public class IdeFixture
implements IdeInvoker {
    private static IdeFixture fixture;
    private boolean started;
    private boolean runner;
    private Set<String> legacyTests = new HashSet<String>();
    private Throwable startException;
    private String productId;
    private URL installationDirectory;
    private URL userDirectory;
    private URL workDirectoryPendingSet;
    private URL workDirectory;
    private URL dataDirectory;
    private URL testClassDirectory;
    private Map<String, String> shroudedExtensions = new HashMap<String, String>();
    private Map<String, String> unshroudedExtensions = new HashMap<String, String>();
    private Class testClass;
    private String testName;
    private Map nodes = new HashMap();
    private boolean verbose;

    protected IdeFixture(String productId) {
        this.productId = productId;
        this.output("created fixture for product " + productId);
    }

    public static IdeFixture getIdeFixture() {
        if (fixture == null) {
            fixture = new IdeFixture("oracle.ide");
        }
        return fixture;
    }

    public void start() {
    }

    public void start(Class testClass, String testName) {
        this.start(testClass, testName, false);
    }

    public void start(Class testClass, String testName, boolean runner) {
        if (testClass == null) {
            throw new IllegalArgumentException("testClass null");
        }
        if (testName == null) {
            throw new IllegalArgumentException("testName null");
        }
        this.testClass = testClass;
        this.testClassDirectory = null;
        this.testName = testName;
        if (!runner) {
            this.legacyTests.add(testClass.getName());
        }
        if (!this.started) {
            this.started = true;
            this.runner = runner;
            try {
                this.startIde();
            }
            catch (Throwable e) {
                this.startException = e;
                throw new StartFailedException(this.startException, true);
            }
        }
        if (this.startException != null) {
            throw new StartFailedException(this.startException, false);
        }
        if (runner != this.runner) {
            throw new IllegalStateException("All IDE fixture tests in module must use JDevRunner if any do. The following tests still use JDevFixture#start(): " + this.legacyTests);
        }
        this.setActive(null, null);
        Workspaces workspaces = Ide.getWorkspaces();
        for (Node node : this.nodes.values()) {
            try {
                node.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (node instanceof Workspace) {
                workspaces.remove(node);
                UpdateMessage.fireChildRemoved(workspaces, node);
            }
            NodeFactory.uncache(node.getURL());
        }
        this.nodes.clear();
        this.workDirectory = null;
        workspaces = Ide.getWorkspaces();
        if (workspaces != null) {
            Iterator i = workspaces.getChildren();
            while (i.hasNext()) {
                Object child = i.next();
                if (!(child instanceof Workspace)) continue;
                Workspace workspace = (Workspace)child;
                URL url = workspace.getURL();
                if (!URLFileSystem.isBaseURLFor((URL)this.getWorkDirectory(), (URL)url)) continue;
                workspaces.remove(workspace);
                UpdateMessage.fireChildRemoved(workspaces, workspace);
                NodeFactory.uncache(workspace.getURL());
            }
        }
        if (this.isVerbose()) {
            this.output("Deleting contents of " + URLFileSystem.getPlatformPathName((URL)this.getWorkDirectory()));
        }
        IdeFixture.deleteChildren(this.getWorkDirectory());
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        catch (InterruptedException e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
        this.output("started test " + testName + " in " + testClass.getName());
        this.output("work directory " + URLFileSystem.getPlatformPathName((URL)this.getWorkDirectory()));
        this.output("test data directory " + URLFileSystem.getPlatformPathName((URL)this.getTestDataDirectory()));
    }

    protected void startIde() {
        URLFileSystem.addURLStreamHandlerFactory((URLStreamHandlerFactory)new TipURLStreamHandlerFactory());
        URLFileSystem.registerHelper((String)"tip", (URLFileSystemHelper)new TipURLFileSystemHelper());
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        ArrayList<String> extensions = new ArrayList<String>(registry.getDisabledExtensions());
        if (!extensions.isEmpty()) {
            Collections.sort(extensions);
            System.out.println("FIXTURE: disabled extensions:");
            for (String id : extensions) {
                StringBuilder builder = new StringBuilder(" ");
                builder.append(id);
                builder.append(": ");
                int i = 24 - id.length();
                while (i-- > 0) {
                    builder.append(' ');
                }
                builder.append(registry.getNotLoadedReason(id));
                System.out.println(builder.toString());
            }
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getProductId() {
        return this.productId;
    }

    public URL getInstallationDirectory() {
        if (this.installationDirectory == null) {
            String ideHome = System.getProperty("ide.home");
            String built = System.getProperty("BUILT");
            if (ideHome != null) {
                this.installationDirectory = URLFactory.newDirURL((String)ideHome);
            } else if (built != null) {
                this.installationDirectory = URLFactory.newDirURL((String)(built + "/jdeveloper/jdev"));
            } else {
                String classPath = System.getProperty("java.class.path");
                StringTokenizer i = new StringTokenizer(classPath, File.pathSeparator);
                String FIXTURE_SUFFIX = "/built/ideimpl/junit-classes".replace('/', File.separatorChar);
                while (i.hasMoreTokens()) {
                    String path = i.nextToken();
                    if (!path.endsWith(FIXTURE_SUFFIX)) continue;
                    URL oracle = URLFactory.newDirURL((String)path.substring(0, path.length() - FIXTURE_SUFFIX.length()));
                    this.installationDirectory = URLFactory.newDirURL((URL)oracle, (String)"jdeveloper/jdev");
                    break;
                }
            }
        }
        if (this.installationDirectory == null) {
            throw new IllegalArgumentException("Failed to find the home directory");
        }
        return this.installationDirectory;
    }

    public void setInstallationDirectory(URL installationDirectory) {
        if (Ide.isRunning()) {
            throw new IllegalStateException("IDE running");
        }
        this.installationDirectory = installationDirectory;
    }

    public URL getUserDirectory() {
        if (this.userDirectory == null) {
            this.userDirectory = URLFactory.newDirURL((URL)this.getInstallationDirectory(), (String)"unit-tests");
            URLFileSystem.mkdirs((URL)this.userDirectory);
        }
        return this.userDirectory;
    }

    public void setUserDirectory(URL userDirectory) {
        if (Ide.isRunning()) {
            throw new IllegalStateException("IDE running");
        }
        this.userDirectory = userDirectory;
    }

    public URL getWorkDirectory() {
        if (this.workDirectory == null) {
            if (this.workDirectoryPendingSet != null) {
                this.workDirectory = this.workDirectoryPendingSet;
                this.workDirectoryPendingSet = null;
            } else {
                String tmp = System.getProperty("unit.tests.tmp.dir");
                this.workDirectory = tmp != null ? URLFactory.newDirURL((String)tmp) : URLFactory.newDirURL((URL)this.getInstallationDirectory(), (String)"mywork/unit-tests");
                this.workDirectory = URLFactory.newDirURL((URL)this.workDirectory, (String)(this.getTestClass().getName() + '_' + this.getTestName()));
            }
        }
        return this.workDirectory;
    }

    public void setWorkDirectory(URL workDirectory) {
        this.workDirectoryPendingSet = workDirectory;
    }

    public URL getDataDirectory() {
        if (this.dataDirectory == null) {
            String path = System.getProperty("fixture.data.dir");
            if (path == null) {
                path = System.getProperty("unit.tests.ref.dir");
            }
            if (path == null) {
                return null;
            }
            this.dataDirectory = URLFactory.newDirURL((URL)this.getInstallationDirectory(), (String)path);
        }
        return this.dataDirectory;
    }

    public void setDataDirectory(URL dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public String unshroudExtension(String shroudedExtension) {
        String extension;
        if ("".equals(shroudedExtension)) {
            return shroudedExtension;
        }
        if (shroudedExtension.charAt(0) != '.') {
            shroudedExtension = '.' + shroudedExtension;
        }
        if ((extension = this.shroudedExtensions.get(shroudedExtension)) == null) {
            extension = shroudedExtension;
        }
        return extension;
    }

    public String shroudExtension(String unshroudedExtension) {
        String extension;
        if ("".equals(unshroudedExtension)) {
            return unshroudedExtension;
        }
        if (unshroudedExtension.charAt(0) != '.') {
            unshroudedExtension = '.' + unshroudedExtension;
        }
        if ((extension = this.unshroudedExtensions.get(unshroudedExtension)) == null) {
            extension = unshroudedExtension;
        }
        return extension;
    }

    public void addShroudedExtension(String shroudedExtension, String unshroudedExtension) {
        if (shroudedExtension.charAt(0) != '.') {
            shroudedExtension = '.' + shroudedExtension;
        }
        if (unshroudedExtension.charAt(0) != '.') {
            unshroudedExtension = '.' + unshroudedExtension;
        }
        this.shroudedExtensions.put(shroudedExtension, unshroudedExtension);
        this.unshroudedExtensions.put(unshroudedExtension, shroudedExtension);
    }

    public void removeShroudedExtension(String shroudedExtension) {
        if (shroudedExtension.charAt(0) != '.') {
            shroudedExtension = '.' + shroudedExtension;
        }
        String unshroudedExtension = this.shroudedExtensions.remove(shroudedExtension);
        this.unshroudedExtensions.remove(unshroudedExtension);
    }

    public Class getTestClass() {
        return this.testClass;
    }

    public URL getTestClassDirectory() {
        if (this.testClassDirectory == null) {
            String className = this.getTestClass().getName();
            int slash = className.lastIndexOf(46);
            if (slash >= 0) {
                className = className.substring(slash + 1);
            }
            String path = className + ".class";
            URL file = this.testClass.getResource(path);
            this.testClassDirectory = URLFileSystem.getParent((URL)file);
        }
        return this.testClassDirectory;
    }

    public String getTestName() {
        return this.testName;
    }

    public URL getLocalTestDataDirectory() {
        String className = this.getTestClass().getName();
        int dot = className.lastIndexOf(46);
        if (dot > 0) {
            className = className.substring(dot + 1);
        }
        return URLFactory.newURL((URL)this.getTestClassDirectory(), (String)("data-files/" + className + "_" + this.getTestName()));
    }

    public URL getTestDataDirectory() {
        URL base = this.getDataDirectory();
        if (base == null) {
            return null;
        }
        String path = this.getTestClass().getName().replace('.', '/') + '/' + this.getTestName();
        return URLFactory.newDirURL((URL)base, (String)path);
    }

    public Node getNode(URL url) {
        String path = URLFileSystem.toRelativeSpec((URL)url, (URL)this.getWorkDirectory(), (boolean)true);
        return (Node)this.nodes.get(path);
    }

    public Node getNode(String path) {
        return (Node)this.nodes.get(path);
    }

    protected void addNode(String path, Node node) {
        String name;
        if (this.nodes.containsKey(path) && this.nodes.get(path) != node) {
            this.nodes.put(path, null);
            throw new IllegalArgumentException("multiple nodes at path " + path);
        }
        this.nodes.put(path, node);
        int slash = path.lastIndexOf(47);
        if (slash > 0 && !this.nodes.containsKey(name = path.substring(slash + 1))) {
            this.nodes.put(name, node);
        }
    }

    public Workspace createWorkspace() {
        return this.createWorkspace(null);
    }

    public Workspace createWorkspace(String path) {
        if (path == null) {
            path = "workspace.jws";
        }
        if (this.getNode(path) != null) {
            throw new IllegalArgumentException("node " + this.getNode(path) + " at " + path + " already created");
        }
        URL file = URLFactory.newURL((URL)this.getWorkDirectory(), (String)path);
        URLFileSystem.mkdirs((URL)URLFileSystem.getParent((URL)file));
        try {
            if (this.isVerbose()) {
                this.output("Creating workspace " + URLFileSystem.getPlatformPathName((URL)file));
            }
            Workspace workspace = (Workspace)NodeFactory.findOrCreate(Workspace.class, file);
            this.addNode(path, workspace);
            workspace.save();
            Workspaces workspaces = Ide.getWorkspaces();
            workspaces.add(workspace);
            UpdateMessage.fireChildAdded(workspaces, workspace);
            return workspace;
        }
        catch (Exception e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
    }

    public void addProjectToWorkspace(Project project, Workspace workspace) {
        if (workspace == null) {
            workspace = this.createWorkspace(null);
        }
        workspace.add(project);
        UpdateMessage.fireChildAdded(workspace, project);
    }

    public Project createProject(String path) {
        if (path == null) {
            path = "project.jpr";
        }
        Project project = this.createProjectNoSave(path);
        try {
            project.save();
        }
        catch (IOException e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
        return project;
    }

    protected Project createProjectNoSave(String path) {
        Project project;
        if (path == null) {
            path = "project.jpr";
        }
        if (this.getNode(path) != null) {
            throw new IllegalArgumentException("node " + this.getNode(path) + " at " + path + " already created");
        }
        URL file = URLFactory.newURL((URL)this.getWorkDirectory(), (String)path);
        URL directory = URLFileSystem.getParent((URL)file);
        if (this.isVerbose()) {
            this.output("Creating directory " + URLFileSystem.getPlatformPathName((URL)directory));
        }
        URLFileSystem.mkdirs((URL)directory);
        try {
            this.output("Creating project " + URLFileSystem.getPlatformPathName((URL)file));
            project = this.createProject(file);
            this.addNode(path, project);
        }
        catch (Exception e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
        return project;
    }

    protected Project createProject(URL file) throws IllegalAccessException, InstantiationException, IOException {
        return (Project)NodeFactory.findOrCreate(Project.class, file);
    }

    public URL createDirectory(String path) {
        URL url = URLFactory.newURL((URL)this.getWorkDirectory(), (String)path);
        URLFileSystem.mkdirs((URL)url);
        return url;
    }

    public URL getDataUrl(String path) {
        ArrayList<URL> tried = new ArrayList<URL>();
        URL resource = null;
        if (!"".equals(path) && (resource = this.getDataUrl(this.getTestClassDirectory(), path, tried)) != null) {
            return resource;
        }
        resource = this.getDataUrl(this.getLocalTestDataDirectory(), path, tried);
        if (resource != null) {
            return resource;
        }
        resource = this.getDataUrl(this.getTestDataDirectory(), path, tried);
        if (resource != null) {
            return resource;
        }
        resource = this.getDataUrl(this.getDataDirectory(), path, tried);
        if (resource != null) {
            return resource;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("data path \"");
        buffer.append(path);
        buffer.append("\" not found; tried:");
        for (URL url : tried) {
            buffer.append('\n');
            buffer.append(URLFileSystem.getPlatformPathName((URL)url));
        }
        return null;
    }

    private URL getDataUrl(URL root, String path, List<URL> tried) {
        if (root == null) {
            return null;
        }
        URL resolvedRoot = this.resolveUrl(root);
        if (resolvedRoot != null) {
            URL shroudedUrl;
            URL url = URLFactory.newURL((URL)resolvedRoot, (String)path);
            if (URLFileSystem.exists((URL)url)) {
                return url;
            }
            String unshroudedExtension = URLFileSystem.getSuffix((URL)url);
            String shroudedExtension = this.shroudExtension(unshroudedExtension);
            if (!shroudedExtension.equals(this.unshroudedExtensions) && URLFileSystem.exists((URL)(shroudedUrl = URLFileSystem.convertSuffix((URL)url, (String)unshroudedExtension, (String)shroudedExtension)))) {
                return shroudedUrl;
            }
            tried.add(url);
        } else {
            tried.add(root);
        }
        return null;
    }

    protected URL resolveUrl(URL directory) {
        if (directory == null || URLFileSystem.exists((URL)directory)) {
            return directory;
        }
        URL zip = URLFileSystem.convertSuffix((URL)directory, (String)"", (String)".zip");
        if (URLFileSystem.exists((URL)zip)) {
            return URLFactory.newJarURL((URL)zip, (String)"");
        }
        URL jar = URLFileSystem.convertSuffix((URL)directory, (String)"", (String)".jar");
        if (URLFileSystem.exists((URL)jar)) {
            return URLFactory.newJarURL((URL)jar, (String)"");
        }
        URL tip = URLFileSystem.convertSuffix((URL)directory, (String)"", (String)".tip");
        if (URLFileSystem.exists((URL)tip)) {
            return TipURLFileSystemHelper.newTipUrl(tip, "");
        }
        return null;
    }

    public Reader getDataReader(String path) throws IOException {
        return new InputStreamReader(URLFileSystem.openInputStream((URL)this.getDataUrl(path)));
    }

    public String getDataText(String path) {
        try {
            int size;
            URL url = this.getDataUrl(path);
            if (url == null) {
                throw new IllegalArgumentException("contents \"" + path + "\" not found relative to " + this.testClass.getName());
            }
            int length = (int)URLFileSystem.getLength((URL)url);
            BufferedReader reader = new BufferedReader(new InputStreamReader(URLFileSystem.openInputStream((URL)url)));
            StringWriter writer = new StringWriter(length);
            char[] buffer = new char[4096];
            while ((size = reader.read(buffer)) >= 0) {
                writer.write(buffer, 0, size);
            }
            return writer.toString();
        }
        catch (IOException e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
    }

    public Node createFile(String path) {
        Node node;
        if (this.getNode(path) != null) {
            throw new IllegalArgumentException("node " + this.getNode(path) + " at " + path + " already created");
        }
        URL file = URLFactory.newURL((URL)this.getWorkDirectory(), (String)path);
        URLFileSystem.mkdirs((URL)URLFileSystem.getParent((URL)file));
        try {
            if (this.isVerbose()) {
                this.output("Creating file " + URLFileSystem.getPlatformPathName((URL)file));
            }
            node = NodeFactory.findOrCreate(file);
            this.addNode(path, node);
        }
        catch (Exception e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
        return node;
    }

    public Node createFile(String path, String contents) {
        Node node;
        URL file = URLFactory.newURL((URL)this.getWorkDirectory(), (String)path);
        URLFileSystem.mkdirs((URL)URLFileSystem.getParent((URL)file));
        try {
            if (this.isVerbose()) {
                this.output("Creating file " + URLFileSystem.getPlatformPathName((URL)file));
            }
            OutputStreamWriter writer = new OutputStreamWriter(URLFileSystem.openOutputStream((URL)file));
            writer.write(contents);
            ((Writer)writer).close();
            node = NodeFactory.findOrCreate(file);
            this.addNode(path, node);
        }
        catch (Exception e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
        return node;
    }

    public Node createFileRelative(String path, String contentsPath) {
        return this.createFile(path, this.getDataUrl(contentsPath));
    }

    public Node createFile(String path, URL contentsURL) {
        Node node;
        URL file = URLFactory.newURL((URL)this.getWorkDirectory(), (String)path);
        URLFileSystem.mkdirs((URL)URLFileSystem.getParent((URL)file));
        try {
            if (this.isVerbose()) {
                this.output("Copying " + URLFileSystem.getPlatformPathName((URL)contentsURL) + " to " + URLFileSystem.getPlatformPathName((URL)file));
            }
            URLFileSystem.copy((URL)contentsURL, (URL)file);
            node = NodeFactory.findOrCreate(file);
            this.addNode(path, node);
        }
        catch (Exception e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
        return node;
    }

    public URL createFiles(String path, URL contentsURL) {
        if (contentsURL == null) {
            throw new IllegalArgumentException("contentsURL null");
        }
        URL root = URLFactory.newURL((URL)this.getWorkDirectory(), (String)path);
        this.copyFiles(contentsURL, root, new String[]{""}, null);
        return root;
    }

    public URL createFilesRelative(String path, String contentsPath) {
        return this.createFiles(path, this.getDataUrl(contentsPath));
    }

    protected void copyFiles(URL source, URL target, String[] indexes, URLPath roots) {
        if (this.isVerbose()) {
            this.output("Creating directory " + URLFileSystem.getPlatformPathName((URL)target));
        }
        URLFileSystem.mkdirs((URL)target);
        source = this.unlockArchiveUrl(source);
        URL[] urls = URLFileSystem.list((URL)source);
        for (int i = 0; i < urls.length; ++i) {
            URL targetChild;
            URL sourceChild = urls[i];
            String childName = URLFileSystem.getFileName((URL)sourceChild);
            if (URLFileSystem.isDirectory((URL)sourceChild)) {
                String[] childIndexes = new String[indexes.length];
                for (int j = 0; j < indexes.length; ++j) {
                    String index = indexes[j];
                    if (index.equals("")) {
                        childIndexes[j] = childName;
                        continue;
                    }
                    if (index.endsWith("..")) {
                        if (index.equals("..")) {
                            childIndexes[j] = "";
                            continue;
                        }
                        childIndexes[j] = index.substring(0, index.length() - 3);
                        continue;
                    }
                    childIndexes[j] = index + "/" + childName;
                }
                targetChild = URLFactory.newDirURL((URL)target, (String)childName);
                if (roots != null) {
                    this.copyFiles(sourceChild, targetChild, childIndexes, null);
                    roots.add(targetChild);
                    continue;
                }
                this.copyFiles(sourceChild, targetChild, childIndexes, null);
                continue;
            }
            try {
                int dot2 = childName.lastIndexOf(46);
                if (dot2 > childName.lastIndexOf(47)) {
                    String extension = this.unshroudExtension(childName.substring(dot2));
                    childName = childName.substring(0, dot2) + extension;
                }
                targetChild = URLFactory.newURL((URL)target, (String)childName);
                if (this.isVerbose()) {
                    this.output("Copying " + URLFileSystem.getPlatformPathName((URL)sourceChild) + " to " + URLFileSystem.getPlatformPathName((URL)targetChild));
                }
                URLFileSystem.copy((URL)sourceChild, (URL)targetChild);
                Node node = NodeFactory.findOrCreate(targetChild);
                for (int j = 0; j < indexes.length; ++j) {
                    String path = indexes[j];
                    if (path.equals("")) {
                        this.addNode(childName, node);
                        continue;
                    }
                    if (path.endsWith("..")) continue;
                    this.addNode(path + "/" + childName, node);
                }
                continue;
            }
            catch (IOException e) {
                throw new UnexpectedExceptionError((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new UnexpectedExceptionError((Throwable)e);
            }
            catch (InstantiationException e) {
                throw new UnexpectedExceptionError((Throwable)e);
            }
        }
    }

    protected URL unlockArchiveUrl(URL url) {
        if ("file".equals(url.getProtocol())) {
            String suffix = URLFileSystem.getSuffix((URL)url);
            if (".jar".equals(suffix) || ".zip".equals(suffix)) {
                url = URLFactory.newJarURL((URL)url, (String)"");
            } else if (".tip".equals(suffix)) {
                url = URLFactory.newURL((String)"tip", (String)(url.toString() + "!/"));
            }
        }
        return url;
    }

    public Context createContext() {
        return new Context(null, Ide.getActiveWorkspace(), Ide.getActiveProject(), null);
    }

    public Context createContext(Workspace workspace, Project project, Node node, Element[] selection) {
        assert (selection != null && selection.length > 0);
        Context context = new Context(null, workspace, project, node);
        context.setSelection(selection);
        return context;
    }

    public Context createContext(Workspace workspace, Project project, Node node) {
        assert (node != null);
        return new Context(null, workspace, project, node);
    }

    public void setActive(Workspace workspace, Project project) {
        if (workspace != null) {
            workspace.setActiveProject(project);
        }
        Ide.setActiveWorkspace(workspace);
        Ide.setActiveProject(project);
    }

    public static void deleteChildren(URL url) {
        URL[] urls = URLFileSystem.list((URL)url);
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                IdeFixture.delete(urls[i]);
            }
        }
    }

    public static void delete(URL url) {
        URL[] urls = URLFileSystem.list((URL)url);
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                IdeFixture.delete(urls[i]);
            }
        }
        URLFileSystem.delete((URL)url);
    }

    public void assertEquals(URL expectedURL, String actualPath) {
        if (expectedURL == null) {
            throw new IllegalArgumentException("expectedURL null");
        }
        URL actualURL = URLFactory.newURL((URL)this.getWorkDirectory(), (String)actualPath);
        this.assertEquals(this.unlockArchiveUrl(expectedURL), actualURL);
    }

    public void assertEqualsFromResource(String expectedPath, String actualPath) {
        this.assertEquals(this.getDataUrl(expectedPath), actualPath);
    }

    public void assertEquals(URL expectedRootURL, URL actualRootURL) {
        if (expectedRootURL == null) {
            throw new IllegalArgumentException("expectedURL null");
        }
        if (actualRootURL == null) {
            throw new IllegalArgumentException("actualURL null");
        }
        LinkedHashMap expectedMap = new LinkedHashMap();
        this.scan("", expectedRootURL, expectedMap, true);
        LinkedHashMap actualMap = new LinkedHashMap();
        this.scan("", actualRootURL, actualMap, false);
        this.compare(expectedMap, actualMap);
    }

    private void scan(String path, URL url, Map map, boolean unshroud) {
        URL[] children = URLFileSystem.list((URL)url);
        for (int i = 0; i < children.length; ++i) {
            String shrouded;
            URL child;
            URL adjustedChild = child = children[i];
            if (unshroud && (shrouded = URLFileSystem.getSuffix((URL)child)).length() > 0) {
                adjustedChild = URLFileSystem.convertSuffix((URL)child, (String)shrouded, (String)this.unshroudExtension(shrouded));
            }
            String childName = URLFileSystem.getFileName((URL)adjustedChild);
            String childPath = path.equals("") ? childName : path + "/" + childName;
            map.put(childPath, child);
            if (!URLFileSystem.isDirectory((URL)child)) continue;
            this.scan(childPath, child, map, unshroud);
        }
    }

    private void compare(Map expectedMap, Map actualMap) {
        for (Map.Entry entry : expectedMap.entrySet()) {
            String path = (String)entry.getKey();
            URL expectedURL = (URL)entry.getValue();
            URL actualURL = (URL)actualMap.remove(path);
            if (URLFileSystem.isDirectory((URL)expectedURL)) continue;
            try {
                BufferedReader expected = new BufferedReader(new InputStreamReader(URLFileSystem.openInputStream((URL)expectedURL)));
                BufferedReader actual = new BufferedReader(new InputStreamReader(URLFileSystem.openInputStream((URL)actualURL)));
                expected.close();
                actual.close();
            }
            catch (IOException e) {
                throw new UnexpectedExceptionError((Throwable)e);
            }
        }
    }

    protected void output(String message) {
        System.out.println("FIXTURE: " + message);
    }

    protected void errors(String message) {
        System.err.println("FIXTURE ERROR: " + message);
    }

    private class StartFailedException
    extends Error {
        public StartFailedException(Throwable cause, boolean firstTime) {
            super(firstTime ? "IDE fixture startup failed" : "IDE fixture startup failed when attempted for previous test", cause);
        }
    }
}

