/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.javatools.util.Copyable;

public class FilePath
implements Copyable {
    private final ArrayList _entriesList = new ArrayList();
    private transient File[] _entries;
    private transient boolean _mustRecalcEntries = true;

    public FilePath() {
    }

    public FilePath(File entry) {
        this.addEntry(entry);
    }

    public FilePath(File[] entries) {
        this.addEntries(entries);
    }

    public FilePath(FilePath filePath) {
        if (filePath != null) {
            filePath.copyToImpl(this);
        }
    }

    public Object copyTo(Object object) {
        FilePath copy = object != null ? (FilePath)object : new FilePath();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(FilePath copy) {
        copy._entriesList.clear();
        copy._entriesList.addAll(this._entriesList);
    }

    public File[] getEntries() {
        if (this._mustRecalcEntries) {
            List entriesList = this.getEntriesListDirectly();
            this._entries = new File[entriesList.size()];
            int i = 0;
            Iterator iter = entriesList.iterator();
            while (iter.hasNext()) {
                this._entries[i++] = (File)iter.next();
            }
        }
        return (File[])this._entries.clone();
    }

    public void setEntries(File[] entries) {
        List entriesList = this.getEntriesListDirectly();
        entriesList.clear();
        if (entries != null) {
            this.addEntries(entries);
            this._entries = (File[])entries.clone();
            this._mustRecalcEntries = false;
        } else {
            this._mustRecalcEntries = true;
        }
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((FilePath)o);
    }

    protected final boolean equalsImpl(FilePath filePath) {
        return ModelUtil.areEqual((Object)this._entriesList, (Object)filePath._entriesList);
    }

    public String toString() {
        StringBuffer filePath = new StringBuffer();
        List entriesList = this.getEntriesListDirectly();
        for (File file : entriesList) {
            String path = file.getAbsolutePath();
            filePath.append(path).append(File.pathSeparatorChar);
        }
        int len = filePath.length();
        if (len > 0) {
            filePath.setLength(len - 1);
        }
        return filePath.toString();
    }

    public void addEntry(File entry) {
        if (entry == null) {
            return;
        }
        List entriesList = this.getEntriesListDirectly();
        if (!entriesList.contains(entry)) {
            entriesList.add(entry);
            this._mustRecalcEntries = true;
        }
    }

    public void addEntries(File[] entries) {
        if (entries == null) {
            return;
        }
        int numEntries = entries.length;
        for (int i = 0; i < numEntries; ++i) {
            this.addEntry(entries[i]);
        }
    }

    public void addEntries(FilePath filePath) {
        List entriesList = this.getEntriesListDirectly();
        List otherEntriesList = filePath.getEntriesListDirectly();
        entriesList.addAll(otherEntriesList);
    }

    public URLPath toURLPath() {
        List entriesList = this.getEntriesListDirectly();
        URLPath urlPath = new URLPath();
        for (File file : entriesList) {
            URL url = URLFactory.newFileURL((File)file);
            urlPath.add(url);
        }
        return urlPath;
    }

    public static FilePath newFilePathFromString(String entries) {
        FilePath filePath = new FilePath();
        if (entries != null) {
            StringTokenizer st = new StringTokenizer(entries, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String path = st.nextToken();
                File file = new File(path);
                filePath.addEntry(file);
            }
        }
        return filePath;
    }

    protected final List getEntriesListDirectly() {
        return this._entriesList;
    }
}

