/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.navigator;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.navigator.DeleteActionHandler;

public final class DeleteHandlerService {
    private static Map<Class<? extends Element>, Class<? extends DeleteActionHandler>> m_class2HandlerMap = new HashMap<Class<? extends Element>, Class<? extends DeleteActionHandler>>();
    private static ArrayList<DeleteActionHandler.LookupHelper> m_lookupHelpers = new ArrayList<DefaultLookupHelper>(Collections.singletonList(new DefaultLookupHelper()));

    private DeleteHandlerService() {
    }

    public static void registerDeleteActionHandler(Class<? extends Element> classKey, Class<? extends DeleteActionHandler> deleteActionHandlerClass) {
        m_class2HandlerMap.put(classKey, deleteActionHandlerClass);
    }

    public static Class<? extends DeleteActionHandler> unregisterDeleteActionHandler(Class<? extends Element> classKey) {
        return m_class2HandlerMap.remove(classKey);
    }

    public static DeleteActionHandler createDeleteHandler(Context context) {
        Element[] selections = context.getSelection();
        List<Class<? extends Element>> selectedSubtypes = DeleteHandlerService.getAllSelectedNodeSubtypes(context.getSelection());
        for (Class<? extends Element> nodeSubtype : selectedSubtypes) {
            Class<? extends DeleteActionHandler> actionHandlerClass = DeleteHandlerService.getHandlerClass(nodeSubtype, context);
            if (actionHandlerClass == null) continue;
            try {
                final ArrayList<Element> selectedNodes = new ArrayList<Element>();
                for (Element e : selections) {
                    if (nodeSubtype.isInstance(e)) {
                        selectedNodes.add(e);
                        continue;
                    }
                    Class<? extends DeleteActionHandler> nextElementHandlerClass = DeleteHandlerService.getHandlerClass(e.getClass(), context);
                    if (nextElementHandlerClass == null || !actionHandlerClass.equals(nextElementHandlerClass)) continue;
                    selectedNodes.add(e);
                }
                Constructor<? extends DeleteActionHandler> c = actionHandlerClass.getConstructor(Context.class);
                context.setProperty(DeleteActionHandler.SelectedNodesProvider.class.getName(), new DeleteActionHandler.SelectedNodesProvider(){

                    public List<? extends Element> getSelectedNodes() {
                        return selectedNodes;
                    }
                });
                return c.newInstance(context);
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (NoSuchMethodException e) {
            }
        }
        return null;
    }

    public static void registerLookupHelper(DeleteActionHandler.LookupHelper lookupHelper) {
        m_lookupHelpers.add(0, lookupHelper);
    }

    private static List<Class<? extends Element>> getAllSelectedNodeSubtypes(Element[] elements) {
        ArrayList<Class<? extends Element>> subtypes = new ArrayList<Class<? extends Element>>();
        for (Element e : elements) {
            if (subtypes.contains(e.getClass())) continue;
            subtypes.add(e.getClass());
        }
        return subtypes;
    }

    private static Class<? extends DeleteActionHandler> getHandlerClass(Class<? extends Element> nodeClass, Context context) {
        for (DeleteActionHandler.LookupHelper helper : m_lookupHelpers) {
            Class<? extends DeleteActionHandler> c = helper.lookup(nodeClass, context);
            if (c == null) continue;
            return c;
        }
        return new DefaultLookupHelper().lookup(nodeClass, context);
    }

    private static class DefaultLookupHelper
    implements DeleteActionHandler.LookupHelper {
        private DefaultLookupHelper() {
        }

        @Override
        public Class<? extends DeleteActionHandler> lookup(Class<? extends Element> elementClass, Context context) {
            Class handlerClass = (Class)m_class2HandlerMap.get(elementClass);
            Class<? extends Element> superClass = elementClass;
            while (handlerClass == null && superClass != null && !superClass.equals(Node.class)) {
                if ((superClass = superClass.getSuperclass()) == null) continue;
                handlerClass = (Class)m_class2HandlerMap.get(superClass);
            }
            return handlerClass;
        }
    }
}

