/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model.panels;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.SettingsUIRegistry;
import oracle.ide.dialogs.DialogRunnerCallback;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.HashStructureNode;
import oracle.ide.model.panels.ProjectContentNavigable;
import oracle.ide.model.panels.ProjectPropertiesMDDPanel;
import oracle.ide.panels.MDDPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.resource.ProjectPropertiesArb;
import oracle.ide.util.Namespace;
import oracle.javatools.data.ChangeBuffer;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.util.ModelUtil;

public final class PropertiesDialog {
    private final String _internalKey;
    private final ArrayList _rootNavigables = new ArrayList();
    private String[] _oldPath = null;
    private boolean _loadedExtensionPages;
    private String _objectLabel;
    private static final HashMap _dialogs = new HashMap();

    private PropertiesDialog(String internalKey) {
        this._internalKey = internalKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final PropertiesDialog getInstance(String internalKey) {
        HashMap hashMap = _dialogs;
        synchronized (hashMap) {
            Object obj = _dialogs.get(internalKey);
            if (obj == null) {
                obj = new PropertiesDialog(internalKey);
                _dialogs.put(internalKey, obj);
            }
            return (PropertiesDialog)obj;
        }
    }

    final void addPanel(Navigable navigable) {
        if (navigable != null && !this._rootNavigables.contains(navigable)) {
            this._rootNavigables.add(navigable);
        }
    }

    public final boolean hasPanel() {
        this.getRootNavigables();
        return !this._rootNavigables.isEmpty();
    }

    public final void showDialog(HashStructureNode node) {
        this.showDialog(null, (Frame)((Object)Ide.getMainWindow()), node, null);
    }

    public final void showDialog(Context context, HashStructureNode node) {
        this.showDialog(context, (Frame)((Object)Ide.getMainWindow()), node, false, null);
    }

    public final void showDialog(Frame parent, HashStructureNode node, String[] selectionPath) {
        IllegalStateException e = new IllegalStateException("Call to deprecated PropertiesDialog.showDialog() should be fixed.");
        e.fillInStackTrace();
        FeedbackManager.reportException(e);
        Context lavContext = Ide.getLastActiveNavigator().getContext();
        this.showDialog(lavContext, parent, node, false, selectionPath);
    }

    public final void showDialog(Context context, Frame parent, HashStructureNode node, String[] selectionPath) {
        if (context == null) {
            context = Context.newIdeContext(node);
        }
        this.showDialog(context, parent, node, false, selectionPath);
    }

    private void showDialog(Context context, Frame parent, final HashStructureNode node, boolean useDetailTree, String[] selectionPath) {
        MDDPanel panel;
        if (node == null || node.getUserPropertiesOnly() == null) {
            return;
        }
        parent.setCursor(Cursor.getPredefinedCursor(3));
        boolean isDefault = node.isDefault();
        if (isDefault) {
            node.ensureOpen();
        }
        HashStructureNode nodeCopy = (HashStructureNode)node.copyTo(null);
        final ChangeBuffer nodeChangeBuffer = new ChangeBuffer();
        nodeCopy.getSharedPropertiesOnly().addStructureChangeListener((StructureChangeListener)nodeChangeBuffer);
        final ChangeBuffer userChangeBuffer = new ChangeBuffer();
        nodeCopy.getUserPropertiesOnly().addStructureChangeListener((StructureChangeListener)userChangeBuffer);
        Namespace data = new Namespace();
        data.put(Context.class.getName(), (Object)context);
        data.put(this._internalKey, (Object)nodeCopy);
        data.put("IsDefaultProject", (Object)isDefault);
        data.put("PropertyData", (Object)nodeCopy.getSharedPropertiesOnly());
        data.put("IsUserPropertyData", (Object)Boolean.FALSE);
        data.put("ChainedPropertyData", (Object)nodeCopy.getProperties());
        data.put("UserOnlyPropertyData", (Object)nodeCopy.getUserPropertiesOnly());
        Navigable[] rootNavigables = this.getRootNavigables();
        if (isDefault) {
            panel = new MDDPanel(rootNavigables, useDetailTree);
            panel.setChildComparator((Comparator)new Navigable.NavigableComparator(ProjectContentNavigable.PROPERTIES_NODE_LABEL));
        } else {
            Namespace customData = new Namespace();
            customData.put(this._internalKey, (Object)nodeCopy);
            customData.put(Context.class.getName(), (Object)context);
            customData.put("IsDefaultProject", (Object)isDefault);
            customData.put("PropertyData", (Object)nodeCopy.getPropertiesForOverriding());
            customData.put("IsUserPropertyData", (Object)Boolean.TRUE);
            panel = new ProjectPropertiesMDDPanel(rootNavigables, useDetailTree, customData, this._objectLabel);
            panel.setChildComparator((Comparator)new Navigable.NavigableComparator(ProjectContentNavigable.PROPERTIES_NODE_LABEL));
        }
        panel.setDefaultChildComparator(Navigable.NAVIGABLE_COMPARATOR);
        panel.setTitleDepth(2);
        String title = ProjectPropertiesArb.format(5, this._objectLabel, node.getLongLabel());
        if (isDefault) {
            title = ProjectPropertiesArb.format(6, this._objectLabel);
        }
        SizeKeeperCallback skc = new SizeKeeperCallback(this._internalKey + ".settings");
        TDialogLauncher launcher = new TDialogLauncher((Component)parent, title, (Traversable)panel, data, (DialogRunnerCallback)skc);
        if (selectionPath != null) {
            panel.setTree1SelectionPath(selectionPath);
        } else if (this._oldPath != null) {
            panel.setTree1SelectionPath(this._oldPath);
        }
        parent.setCursor(Cursor.getDefaultCursor());
        boolean okSelected = launcher.showDialog();
        nodeCopy.getSharedPropertiesOnly().removeStructureChangeListener((StructureChangeListener)nodeChangeBuffer);
        nodeCopy.getUserPropertiesOnly().removeStructureChangeListener((StructureChangeListener)userChangeBuffer);
        launcher.dispose();
        this._oldPath = panel.getTree1SelectionPath();
        if (okSelected && ModelUtil.areDifferent((Object)node, (Object)nodeCopy)) {
            node.applyBatchChanges(new Runnable(){

                @Override
                public void run() {
                    node.ensureOpen();
                    node.getSharedPropertiesOnly().applyChanges(nodeChangeBuffer.getChanges());
                    node.getUserPropertiesOnly().applyChanges(userChangeBuffer.getChanges());
                }
            });
            try {
                node.saveUserProperties();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (isDefault) {
                try {
                    node.save();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            nodeCopy.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Navigable[] getRootNavigables() {
        if (!this._loadedExtensionPages) {
            this._loadedExtensionPages = true;
            Collection<Navigable> extensionNavigables = SettingsUIRegistry.getExtensionNavigables(this._internalKey);
            for (Navigable n : extensionNavigables) {
                this.addPanel(n);
            }
            this._objectLabel = SettingsUIRegistry.getObjectLabel(this._internalKey);
        }
        Navigable[] rootNavigables = this._rootNavigables.toArray(new Navigable[0]);
        return rootNavigables;
    }
}

