/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.DefaultSubDirtyable;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Folder;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeMigrationTracker;
import oracle.ide.model.ObservableFolder;
import oracle.ide.model.SubDirtyable;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.ModelArb;
import oracle.javatools.annotations.NotNull;
import oracle.javatools.util.ModelUtil;

public class Workspaces
extends ObservableFolder
implements SubDirtyable {
    public static final String WORKSPACES = "Workspaces";
    private URL _workDirectory;
    private transient Workspace _activeWorkspace;
    private URL _activeWorkspaceURL;
    private SubDirtyable _subDirtyable = new DefaultSubDirtyable();
    private Map _activeProjectMap;

    public Workspaces() {
        this.getAttributes().clear();
        this.getAttributes().set(ElementAttributes.BUILDABLE);
    }

    public Workspaces(Workspaces workspaces) {
        this();
        if (workspaces != null) {
            workspaces.copyToImpl(this);
        }
    }

    @Override
    public Object copyTo(Object object) {
        Workspaces copy = object != null ? (Workspaces)object : new Workspaces();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(Workspaces copy) {
        super.copyToImpl(copy);
        copy._workDirectory = this._workDirectory;
    }

    public URL getWorkDirectory() {
        return this._workDirectory;
    }

    public void setWorkDirectory(URL workDirectory) {
        if (!URLFileSystem.equals((URL)this._workDirectory, (URL)workDirectory)) {
            this._workDirectory = workDirectory;
            this.markDirty(true);
        }
    }

    public URL getActiveWorkspaceURL() {
        return this._activeWorkspaceURL;
    }

    public void setActiveWorkspaceURL(URL workspaceURL) {
        if (ModelUtil.areEqual((Object)this._activeWorkspaceURL, (Object)workspaceURL)) {
            return;
        }
        this._activeWorkspaceURL = workspaceURL;
        this._activeWorkspace = (Workspace)NodeFactory.find(this._activeWorkspaceURL);
        if (this._activeWorkspace != null && !this.containsChild(this._activeWorkspace)) {
            this._activeWorkspace = null;
            this._activeWorkspaceURL = null;
        }
        this.markDirty(true);
    }

    @NotNull
    public Collection<Workspace> workspaces() {
        ArrayList<Workspace> workspaces = new ArrayList<Workspace>();
        Iterator i = this.getChildren();
        while (i.hasNext()) {
            Object e = i.next();
            if (!(e instanceof Workspace)) continue;
            workspaces.add((Workspace)e);
        }
        return Collections.unmodifiableCollection(workspaces);
    }

    @Override
    public String getShortLabel() {
        return ModelArb.getString(41);
    }

    @Override
    public Icon getIcon() {
        return ModelArb.getIcon(13);
    }

    @Override
    public boolean canAdd(Element element) {
        return element instanceof Workspace;
    }

    @Override
    public boolean remove(Element doc) {
        boolean removeOk = super.remove(doc);
        if (removeOk && (doc == this._activeWorkspace || this.size() == 0)) {
            this._activeWorkspaceURL = null;
            this._activeWorkspace = null;
        }
        return removeOk;
    }

    @Override
    public void setListOfChildren(List list) {
        super.setListOfChildren(list);
        this.initActiveProjects();
        Collection<Workspace> workspaces = this.workspaces();
        for (Workspace wkspc : workspaces) {
            if (!NodeMigrationTracker.getInstance().needsMigration(wkspc.getURL())) continue;
            this.remove(wkspc);
        }
    }

    @Override
    public boolean isDirty() {
        return this._subDirtyable.isDirty();
    }

    @Override
    public void markDirty(boolean dirty) {
        this._subDirtyable.markDirty(dirty);
    }

    public void setOwner(Dirtyable owner) {
        this._subDirtyable.setOwner(owner);
    }

    public Workspace currentActiveWorkspace() {
        if (this._activeWorkspace != null) {
            return this._activeWorkspace;
        }
        if (this._activeWorkspaceURL != null) {
            try {
                this._activeWorkspace = (Workspace)NodeFactory.findOrCreate(this._activeWorkspaceURL);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this._activeWorkspace;
    }

    public void setActiveWorkspace(Workspace workspace) {
        if (this._activeWorkspace == workspace) {
            return;
        }
        if (this.size() == 0) {
            return;
        }
        this._activeWorkspace = workspace;
        if (this._activeWorkspace != null) {
            if (!ModelUtil.areEqual((Object)this._activeWorkspace.getURL(), (Object)this._activeWorkspaceURL)) {
                this._activeWorkspaceURL = this._activeWorkspace.getURL();
                this.markDirty(true);
            }
        } else if (this._activeWorkspaceURL != null) {
            this._activeWorkspaceURL = null;
            this.markDirty(true);
        }
    }

    public Map getActiveProjectMap() {
        HashMap<URL, URL> map = new HashMap<URL, URL>();
        Iterator children = this.getChildren();
        while (children.hasNext()) {
            Workspace wsp;
            URL activeProjectURL;
            Element child = (Element)children.next();
            if (!(child instanceof Workspace) || (activeProjectURL = (wsp = (Workspace)child).getActiveProjectURL()) == null) continue;
            map.put(wsp.getURL(), activeProjectURL);
        }
        return map;
    }

    public void setActiveProjectMap(Map map) {
        this._activeProjectMap = map;
        if (this.size() > 0) {
            this.initActiveProjects();
        }
    }

    public static final Folder findOwner(Element element, Context context) {
        Workspace wsp;
        if (context != null && (wsp = context.getWorkspace()) != null && !(element instanceof Workspace) && wsp.containsChild(element)) {
            return wsp;
        }
        Workspaces wsps = Ide.getWorkspaces();
        if (wsps != null && wsps.containsChild(element)) {
            return wsps;
        }
        return null;
    }

    private void initActiveProjects() {
        if (this._activeProjectMap == null) {
            return;
        }
        Iterator children = this.getChildren();
        while (children.hasNext()) {
            Workspace wsp;
            URL activeProjectURL;
            Element child = (Element)children.next();
            if (!(child instanceof Workspace) || (activeProjectURL = (URL)this._activeProjectMap.get((wsp = (Workspace)child).getURL())) == null) continue;
            wsp.setActiveProjectURL(activeProjectURL);
        }
        this._activeProjectMap = null;
    }
}

