/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.awt.Window;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.history.HistoryManager;
import oracle.ide.model.Attributes;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.TextBufferStreamFactory;
import oracle.javatools.buffer.AbstractTextBuffer;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.ReadOnlyException;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.buffer.Utilities;
import oracle.javatools.buffer.WriteLockRequestListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.Log;
import oracle.javatools.util.NullArgumentException;

public class TextNode
extends Node {
    private static final Logger LOG = Logger.getLogger(TextBuffer.class.getName());
    private static final Log EXPIRATION_LOG = new Log("expiration", "expiration-detail");
    private static final Log EXPIRATION_DETAIL_LOG = new Log("expiration-detail");
    private AbstractTextBuffer realBuffer;
    private FacadeTextBuffer facadeBuffer;
    private FacadeBufferReference facadeBufferReference;
    private Object facadeBufferLock = new Object();
    private volatile boolean isDirty;
    private FacadeTextBufferListener realBufferListener = new FacadeTextBufferListener(this);
    private boolean isLoading = false;
    private boolean autoClosing = false;
    private AbstractTextBuffer.UndoState undoState;
    private AbstractTextBuffer.UndoState unmodifiedUndoState;
    private boolean lastReadOnly = false;
    private String _loadEncoding;
    private String _saveEncoding;

    public TextNode() {
        this(null);
    }

    public TextNode(URL url) {
        super(url);
        this.getAttributes().set(ElementAttributes.DELETEABLE | ElementAttributes.RENAMEABLE | ElementAttributes.SAVEABLE | ElementAttributes.EDITOR_SAVEABLE_AS | ElementAttributes.CLOSEABLE | ElementAttributes.PRINTABLE);
    }

    @Override
    protected void readUnlock() {
        if (!this.isDirty && this.lockCount() == 1) {
            this.clearFacadeBuffer();
        }
        super.readUnlock();
    }

    @Override
    protected void writeUnlock() {
        if (!this.isDirty && this.lockCount() == 1) {
            this.clearFacadeBuffer();
        }
        super.writeUnlock();
    }

    @Override
    protected void upgradeUnlock() {
        if (!this.isDirty && this.lockCount() == 1) {
            this.clearFacadeBuffer();
        }
        super.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FacadeTextBuffer facadeBuffer() {
        assert (this.isReadOrWriteLocked());
        if (this.realBuffer == null) {
            return null;
        }
        Object object = this.facadeBufferLock;
        synchronized (object) {
            if (this.facadeBuffer != null) {
                return this.facadeBuffer;
            }
            if (this.facadeBufferReference != null) {
                this.facadeBuffer = (FacadeTextBuffer)this.facadeBufferReference.get();
                if (this.facadeBuffer != null) {
                    return this.facadeBuffer;
                }
            }
            this.facadeBuffer = new FacadeTextBuffer((TextBuffer)this.realBuffer, this.realBufferListener, this.nodeLock());
            this.facadeBufferReference = new FacadeBufferReference(this, this.facadeBuffer);
            EXPIRATION_LOG.trace("created facade {0}", (Object)this.facadeBufferReference);
            return this.facadeBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFacadeBuffer() {
        Object object = this.facadeBufferLock;
        synchronized (object) {
            this.facadeBuffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTextBuffer() throws IOException {
        assert (this.isWriteLocked());
        FacadeTextBuffer buffer = this.facadeBuffer();
        if (buffer.isExpired()) {
            throw buffer.newExpiredTextBufferException();
        }
        this.isLoading = true;
        try {
            block21: {
                try {
                    URL url = this.getURL();
                    if (url == null) {
                        throw new NullPointerException("null URL, cannot load data");
                    }
                    Reader reader = this.createReader(url);
                    if (reader != null) {
                        try {
                            buffer.read(reader);
                            break block21;
                        }
                        finally {
                            try {
                                reader.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    if (!buffer.isReadOnly()) {
                        buffer.removeToEnd(0);
                    }
                }
                catch (FileNotFoundException e) {
                }
                catch (IOException e) {
                    if (!buffer.isReadOnly()) {
                        buffer.removeToEnd(0);
                    }
                    throw e;
                }
            }
            if (buffer.isReadOnly() != super.isReadOnly()) {
                buffer.setReadOnly(super.isReadOnly());
            }
        }
        finally {
            buffer.clearModified();
            this.isLoading = false;
        }
        if (!Utilities.attachUndoState((AbstractTextBuffer)this.realBuffer, (AbstractTextBuffer.UndoState)this.undoState)) {
            Utilities.attachUndoState((AbstractTextBuffer)this.realBuffer, (AbstractTextBuffer.UndoState)this.unmodifiedUndoState);
        }
        this.unmodifiedUndoState = Utilities.copyUndoState((AbstractTextBuffer)this.realBuffer);
        this.undoState = null;
    }

    @Override
    protected void urlReadOnlyChanged() {
        LOG_READONLY.trace("node {0} read-only changed", (Object)this.getURL());
        this.isReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadOnly() {
        boolean readOnly = super.isReadOnly();
        if (this.nodeLock().tryReadLock()) {
            try {
                if (this.realBuffer != null && this.realBuffer.isReadOnly() != readOnly) {
                    this.realBuffer.setReadOnly(readOnly);
                }
            }
            finally {
                this.readUnlock();
            }
        }
        Attributes attributes = null;
        if (readOnly != this.lastReadOnly) {
            this.lastReadOnly = readOnly;
            attributes = this.getAttributes();
            if (readOnly) {
                attributes.set(ElementAttributes.READ_ONLY);
            } else {
                attributes.unset(ElementAttributes.READ_ONLY);
            }
            attributes = this.getAttributes().duplicate();
        }
        if (attributes != null) {
            LOG_READONLY.trace("getting read-only, firing change to {0} for {1}", readOnly, (Object)this.getURL());
            UpdateMessage.fireAttributeChanged(this, attributes);
        }
        return readOnly;
    }

    @Override
    public boolean isDirty() {
        return super.isDirty();
    }

    @Override
    public void markDirty(boolean dirty) {
        super.markDirty(dirty);
    }

    @Override
    protected void markDirtyImpl(boolean dirty) {
        this.isDirty = dirty;
        if (!dirty && this.realBuffer != null) {
            this.realBuffer.clearModified();
        }
    }

    @Override
    protected void openImpl() throws IOException {
        assert (this.isWriteLocked());
        assert (this.realBuffer == null) : this.getClass().getName() + " " + this.getLongLabel() + ", facade " + this.facadeBuffer;
        this.realBuffer = (AbstractTextBuffer)TextBufferFactory.createTextBuffer((ReadWriteLock)this.nodeLock());
        this.setDefaultLineTerminator((TextBuffer)this.realBuffer);
        this.realBuffer.addTextBufferListener((TextBufferListener)this.realBufferListener);
        try {
            this.loadTextBuffer();
        }
        catch (IOException e) {
            this.realBuffer.removeTextBufferListener((TextBufferListener)this.realBufferListener);
            this.realBuffer = null;
            throw e;
        }
        catch (Throwable e) {
            this.realBuffer.removeTextBufferListener((TextBufferListener)this.realBufferListener);
            this.realBuffer = null;
            IOException ioe = new IOException("exception loading " + this.getLongLabel());
            ioe.initCause(e);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeImpl() throws IOException {
        assert (this.isWriteLocked());
        assert (this.realBuffer != null);
        this.realBufferListener.clear();
        this.realBuffer.removeTextBufferListener((TextBufferListener)this.realBufferListener);
        Object object = this.facadeBufferLock;
        synchronized (object) {
            FacadeTextBuffer facade = (FacadeTextBuffer)this.facadeBufferReference.get();
            if (facade != null) {
                facade.dispose(this.autoClosing);
            }
            this.facadeBufferReference.clear();
            this.facadeBufferReference = null;
            this.facadeBuffer = null;
        }
        this.undoState = Utilities.detachUndoState((AbstractTextBuffer)this.realBuffer);
        this.realBuffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveImpl() throws IOException {
        assert (this.isWriteLocked());
        boolean isNew = this.isNew();
        if (this.isDirty() || isNew) {
            FacadeTextBuffer buffer;
            HistoryManager history = null;
            URL[] urls = null;
            if (Ide.isRunning()) {
                history = HistoryManager.getHistoryManager();
                urls = new URL[]{this.getURL()};
                if (history != null && !isNew) {
                    try {
                        history.persistInitialState(urls);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if ((buffer = this.facadeBuffer()) == null) {
                throw new IllegalStateException("on save, no buffer available");
            }
            if (buffer.isExpired()) {
                throw buffer.newExpiredTextBufferException();
            }
            OutputStream outputStream = null;
            Writer writer = null;
            try {
                outputStream = URLFileSystem.openOutputStream((URL)this.getURL());
                writer = this.createOutputStreamWriter(outputStream);
                buffer.write(writer);
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    } else if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException e) {}
            }
            this.unmodifiedUndoState = Utilities.copyUndoState((AbstractTextBuffer)this.realBuffer);
            if (history != null) {
                try {
                    String historyText = isNew ? IdeArb.getString(23) : IdeArb.getString(58);
                    history.persist(urls, historyText);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    protected void revertImpl() throws IOException {
        assert (this.isWriteLocked());
        this.loadTextBuffer();
    }

    protected void setDefaultLineTerminator(TextBuffer textBuffer) {
        int terminator;
        try {
            EnvironOptions options = Ide.getEnvironOptions();
            terminator = options.getLineTerminator();
        }
        catch (NullPointerException e) {
            terminator = 0;
        }
        switch (terminator) {
            case 1: {
                textBuffer.setEOLType("\r\n");
                break;
            }
            case 2: {
                textBuffer.setEOLType("\n");
                break;
            }
            case 3: {
                textBuffer.setEOLType("\r");
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TextBuffer acquireTextBuffer() {
        this.readLock();
        try {
            this.ensureOpen();
            FacadeTextBuffer buffer = this.facadeBuffer();
            if (buffer != null && buffer.isExpired()) {
                throw buffer.newExpiredTextBufferException();
            }
            FacadeTextBuffer facadeTextBuffer = buffer;
            return facadeTextBuffer;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TextBuffer acquireTextBufferOrThrow() throws IOException {
        this.readLock();
        try {
            this.open();
            FacadeTextBuffer buffer = this.facadeBuffer();
            if (buffer.isExpired()) {
                throw buffer.newExpiredTextBufferException();
            }
            FacadeTextBuffer facadeTextBuffer = buffer;
            return facadeTextBuffer;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TextBuffer tryAcquireTextBuffer() {
        ReadWriteLock lock = this.nodeLock();
        if (lock.tryReadLock()) {
            try {
                if (this.isOpen()) {
                    FacadeTextBuffer buffer = this.facadeBuffer();
                    if (buffer.isExpired()) {
                        throw buffer.newExpiredTextBufferException();
                    }
                    FacadeTextBuffer facadeTextBuffer = buffer;
                    return facadeTextBuffer;
                }
                if (lock.isWriteLockHeld()) {
                    this.ensureOpen();
                    FacadeTextBuffer buffer = this.facadeBuffer();
                    if (buffer.isExpired()) {
                        throw buffer.newExpiredTextBufferException();
                    }
                    FacadeTextBuffer facadeTextBuffer = buffer;
                    return facadeTextBuffer;
                }
            }
            finally {
                this.readUnlock();
            }
            if (!lock.isReadLockHeld() && lock.tryWriteLock()) {
                try {
                    this.ensureOpen();
                    FacadeTextBuffer buffer = this.facadeBuffer();
                    if (buffer.isExpired()) {
                        throw buffer.newExpiredTextBufferException();
                    }
                    FacadeTextBuffer facadeTextBuffer = buffer;
                    return facadeTextBuffer;
                }
                finally {
                    lock.writeUnlock();
                }
            }
        }
        return null;
    }

    public final void releaseTextBuffer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TextBuffer getTextBufferDirectly() {
        this.readLock();
        try {
            FacadeTextBuffer buffer = this.facadeBuffer();
            if (buffer != null && buffer.isExpired()) {
                throw buffer.newExpiredTextBufferException();
            }
            FacadeTextBuffer facadeTextBuffer = buffer;
            return facadeTextBuffer;
        }
        finally {
            this.readUnlock();
        }
    }

    public boolean addTextBufferListener(TextBufferListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener null");
        }
        return this.realBufferListener.addIfAbsent(listener);
    }

    public void removeTextBufferListener(TextBufferListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener null");
        }
        this.realBufferListener.remove(listener);
    }

    public Reader getReader() throws IOException {
        TextBuffer textBuffer = this.acquireTextBuffer();
        if (textBuffer == null) {
            throw new IllegalStateException("getReader(): null text buffer");
        }
        return TextBufferFactory.createReader((ReadTextBuffer)textBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEmptyTextBuffer() {
        try {
            boolean bl = this.acquireTextBuffer().getLength() == 0;
            return bl;
        }
        finally {
            this.releaseTextBuffer();
        }
    }

    public String getLoadEncoding() {
        return this._loadEncoding != null ? this._loadEncoding : IdeUtil.getIdeEncoding();
    }

    public String getSaveEncoding() {
        return this._saveEncoding != null ? this._saveEncoding : IdeUtil.getIdeEncoding();
    }

    public void setLoadEncoding(String loadEncoding) {
        this._loadEncoding = loadEncoding;
    }

    public void setSaveEncoding(String saveEncoding) {
        this._saveEncoding = saveEncoding;
    }

    protected Reader createReader(URL url) throws IOException {
        return URLFileSystem.createReader((URL)url, (String)this.getLoadEncoding());
    }

    protected OutputStreamWriter createOutputStreamWriter(OutputStream outStream) throws UnsupportedEncodingException {
        return new OutputStreamWriter(outStream, this.getSaveEncoding());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getInputStream(true);
    }

    public InputStream getInputStream(boolean warn) throws IOException {
        TextBuffer textBuffer;
        if (warn) {
            // empty if block
        }
        if ((textBuffer = this.acquireTextBuffer()) != null) {
            return TextBufferStreamFactory.getInputStream(textBuffer, this.getSaveEncoding());
        }
        throw new IllegalStateException("getInputStream(): null text buffer");
    }

    @Override
    protected void reportOpenException(final Exception e) {
        super.reportOpenException(e);
        final String message = ModelArb.format(51, this.getURL());
        if (!Ide.getIdeArgs().getCreateUI()) {
            System.err.println(message);
            e.printStackTrace();
            return;
        }
        Runnable showErrorRunnable = new Runnable(){

            @Override
            public void run() {
                ExceptionDialog.showExceptionDialog((Window)IdeUtil.getMainWindow(), (Exception)e, (String)ModelArb.getString(50), (String)message);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            showErrorRunnable.run();
        } else {
            SwingUtilities.invokeLater(showErrorRunnable);
        }
    }

    private static class FacadeBufferReference
    extends WeakReference<FacadeTextBuffer>
    implements Runnable {
        private static ReferenceQueue<FacadeTextBuffer> queue;
        private TextNode node;

        public FacadeBufferReference(TextNode node, FacadeTextBuffer buffer) {
            super(buffer, FacadeBufferReference.getQueue());
            this.node = node;
        }

        @Override
        public synchronized void clear() {
            super.clear();
            this.node = null;
        }

        public String toString() {
            return (this.node != null ? this.node.getShortLabel() : "") + "(" + System.identityHashCode(this) + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TextNode node;
            FacadeBufferReference facadeBufferReference = this;
            synchronized (facadeBufferReference) {
                node = this.node;
                if (node == null) {
                    return;
                }
            }
            ReadWriteLock lock = node.nodeLock();
            if (!lock.isLockHeld() && lock.tryWriteLock()) {
                node.autoClosing = true;
                try {
                    if (this == node.facadeBufferReference && !node.isDirty()) {
                        EXPIRATION_LOG.trace("auto-closing node {0}", (Object)this);
                        node.close();
                        EXPIRATION_LOG.trace("auto-closed node {0}", (Object)this);
                    }
                    EXPIRATION_LOG.trace("skipped auto-closing dirty node {0}", (Object)this);
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "Unexpected exception auto-closing " + node, e);
                    EXPIRATION_LOG.trace("closing facade reference {0} failed: {1}", (Object)this, (Object)e);
                }
                finally {
                    node.autoClosing = false;
                    lock.writeUnlock();
                }
            } else if (EXPIRATION_DETAIL_LOG.isEnabled()) {
                StringBuilder buffer = new StringBuilder();
                lock.appendSnapshot(buffer);
                EXPIRATION_DETAIL_LOG.trace("auto-closing node {0} failed because lock was unavailable:\n{0}", (Object)buffer);
            } else {
                EXPIRATION_LOG.trace("auto-closing node {0} failed because lock was unavailable", (Object)this);
            }
        }

        private static final synchronized ReferenceQueue<FacadeTextBuffer> getQueue() {
            if (queue == null) {
                queue = new ReferenceQueue();
                new PollingThread().start();
            }
            return queue;
        }

        private static final class PollingThread
        extends Thread {
            public PollingThread() {
                super("TextBufferScavenger");
            }

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            FacadeBufferReference referer = (FacadeBufferReference)queue.remove();
                            EXPIRATION_LOG.trace("dequed facade reference {0}", (Object)referer);
                            SwingUtilities.invokeLater(referer);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private static class FacadeTextBufferListener
    extends CopyOnWriteArrayList<TextBufferListener>
    implements TextBufferListener {
        private TextNode node;

        public FacadeTextBufferListener(TextNode node) {
            this.node = node;
        }

        public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
            FacadeTextBuffer facadeBuffer;
            if (!this.node.isLoading) {
                this.node.setTimestampDirectly(System.currentTimeMillis());
            }
            if ((facadeBuffer = this.node.facadeBuffer()).isExpired()) {
                throw facadeBuffer.newExpiredTextBufferException();
            }
            for (TextBufferListener listener : this) {
                try {
                    listener.insertUpdate((TextBuffer)facadeBuffer, offset, count, insertedData);
                }
                catch (Throwable e) {
                    LOG.log(Level.SEVERE, "Exception thrown by TextBufferListener " + listener + " inserting " + insertedData.length + " at " + offset, e);
                }
            }
        }

        public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
            FacadeTextBuffer facadeBuffer;
            if (!this.node.isLoading) {
                this.node.setTimestampDirectly(System.currentTimeMillis());
            }
            if ((facadeBuffer = this.node.facadeBuffer()).isExpired()) {
                throw facadeBuffer.newExpiredTextBufferException();
            }
            for (TextBufferListener listener : this) {
                try {
                    listener.removeUpdate((TextBuffer)facadeBuffer, offset, count, removedData);
                }
                catch (Throwable e) {
                    LOG.log(Level.SEVERE, "Exception thrown by TextBufferListener " + listener + " removing " + removedData.length + " from " + offset, e);
                }
            }
        }

        public void attributeUpdate(TextBuffer buffer, int attribute) {
            FacadeTextBuffer facadeBuffer;
            if (!this.node.isLoading && attribute == 5) {
                this.node.markDirty(buffer.isModified());
            }
            if ((facadeBuffer = this.node.facadeBuffer()).isExpired()) {
                throw facadeBuffer.newExpiredTextBufferException();
            }
            for (TextBufferListener listener : this) {
                try {
                    listener.attributeUpdate((TextBuffer)facadeBuffer, attribute);
                }
                catch (Throwable e) {
                    LOG.log(Level.SEVERE, "Exception thrown by TextBufferListener " + listener + " updating attribute " + attribute, e);
                }
            }
        }
    }

    private static final class FacadeTextBuffer
    implements TextBuffer {
        private TextBuffer realBuffer;
        private FacadeTextBufferListener realBufferListener;
        private ReadWriteLock lock;
        private boolean autoClosed;
        private Throwable disposeTrace;
        private long disposeTime;
        private static final long ONE_MILLISECOND = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS);
        private static final long ONE_SECOND = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);

        public FacadeTextBuffer(TextBuffer realBuffer, FacadeTextBufferListener realBufferListener, ReadWriteLock lock) {
            this.realBuffer = realBuffer;
            this.realBufferListener = realBufferListener;
            this.lock = lock;
        }

        private void dispose(boolean autoClosed) {
            this.autoClosed = autoClosed;
            this.disposeTrace = new Throwable("expiration origin");
            this.disposeTime = System.nanoTime();
            this.realBuffer = null;
        }

        private ExpiredTextBufferException newExpiredTextBufferException() {
            long nanoInterval = System.nanoTime() - this.disposeTime;
            String interval = nanoInterval < ONE_MILLISECOND ? String.valueOf(nanoInterval) + "us" : (nanoInterval < ONE_SECOND ? String.valueOf(TimeUnit.MILLISECONDS.convert(nanoInterval, TimeUnit.NANOSECONDS)) + "ms" : String.valueOf(TimeUnit.SECONDS.convert(nanoInterval, TimeUnit.NANOSECONDS)) + "s");
            String message = this.lock.getName() + " expired " + interval + (this.autoClosed ? " ago (auto-closed)" : " ago");
            return new ExpiredTextBufferException(message, this.disposeTrace);
        }

        private boolean isExpired() {
            return this.realBuffer == null;
        }

        public void addTextBufferListener(TextBufferListener listener) {
            if (this.realBuffer == null) {
                throw this.newExpiredTextBufferException();
            }
            this.realBufferListener.addIfAbsent(listener);
        }

        public void removeTextBufferListener(TextBufferListener listener) {
            if (this.realBuffer != null) {
                this.realBufferListener.remove(listener);
            }
        }

        public OffsetMark addOffsetMark(int offset) {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.addOffsetMark(offset, true);
            }
            throw this.newExpiredTextBufferException();
        }

        public OffsetMark addOffsetMark(int offset, boolean bias) {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.addOffsetMark(offset, bias);
            }
            throw this.newExpiredTextBufferException();
        }

        public void removeOffsetMark(OffsetMark offsetMark) {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                buffer.removeOffsetMark(offsetMark);
            }
        }

        public UndoableEdit append(char[] data) throws IndexOutOfBoundsException, ReadOnlyException {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.append(data);
            }
            throw this.newExpiredTextBufferException();
        }

        public void beginEdit() throws ReadOnlyException {
            TextBuffer buffer = this.realBuffer;
            if (buffer == null) {
                throw this.newExpiredTextBufferException();
            }
            buffer.beginEdit();
        }

        public void clearModified() {
            TextBuffer buffer = this.realBuffer;
            if (buffer == null) {
                throw this.newExpiredTextBufferException();
            }
            buffer.clearModified();
        }

        public UndoableEdit endEdit() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.endEdit();
            }
            throw this.newExpiredTextBufferException();
        }

        public int getChangeId() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.getChangeId();
            }
            throw this.newExpiredTextBufferException();
        }

        public String getEOLType() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.getEOLType();
            }
            throw this.newExpiredTextBufferException();
        }

        public LineMap getLineMap() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.getLineMap();
            }
            throw this.newExpiredTextBufferException();
        }

        public String getPlatformEOLType() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.getPlatformEOLType();
            }
            throw this.newExpiredTextBufferException();
        }

        public UndoableEdit insert(int offset, char[] data) throws IndexOutOfBoundsException, ReadOnlyException {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.insert(offset, data);
            }
            throw this.newExpiredTextBufferException();
        }

        public UndoableEdit insert(int offset, Reader reader) throws IndexOutOfBoundsException, IOException, ReadOnlyException {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.insert(offset, reader);
            }
            throw this.newExpiredTextBufferException();
        }

        public boolean isModified() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.isModified();
            }
            throw this.newExpiredTextBufferException();
        }

        public boolean isReadOnly() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.isReadOnly();
            }
            throw this.newExpiredTextBufferException();
        }

        public void read(Reader reader) throws IOException {
            TextBuffer buffer = this.realBuffer;
            if (buffer == null) {
                throw this.newExpiredTextBufferException();
            }
            buffer.read(reader);
        }

        public UndoableEdit remove(int offset, int count) throws IndexOutOfBoundsException, ReadOnlyException {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.remove(offset, count);
            }
            throw this.newExpiredTextBufferException();
        }

        public UndoableEdit removeToEnd(int offset) throws IndexOutOfBoundsException, ReadOnlyException {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.removeToEnd(offset);
            }
            throw this.newExpiredTextBufferException();
        }

        public void setEOLType(String eolType) throws ReadOnlyException {
            TextBuffer buffer = this.realBuffer;
            if (buffer == null) {
                throw this.newExpiredTextBufferException();
            }
            buffer.setEOLType(eolType);
        }

        public void setReadOnly(boolean readOnly) {
            TextBuffer buffer = this.realBuffer;
            if (buffer == null) {
                throw this.newExpiredTextBufferException();
            }
            buffer.setReadOnly(readOnly);
        }

        public void write(Writer writer) throws IOException {
            TextBuffer buffer = this.realBuffer;
            if (buffer == null) {
                throw this.newExpiredTextBufferException();
            }
            buffer.write(writer);
        }

        public void write(Writer writer, boolean clearModified) throws IOException {
            TextBuffer buffer = this.realBuffer;
            if (buffer == null) {
                throw this.newExpiredTextBufferException();
            }
            buffer.write(writer, clearModified);
        }

        public int getLength() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.getLength();
            }
            throw this.newExpiredTextBufferException();
        }

        public char getChar(int offset) throws IndexOutOfBoundsException {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.getChar(offset);
            }
            throw this.newExpiredTextBufferException();
        }

        public char[] getChars(int offset, int length) throws IndexOutOfBoundsException {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.getChars(offset, length);
            }
            throw this.newExpiredTextBufferException();
        }

        public String getString(int offset, int length) throws IndexOutOfBoundsException {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.getString(offset, length);
            }
            throw this.newExpiredTextBufferException();
        }

        public void getText(int offset, int length, Segment segment) throws IndexOutOfBoundsException {
            TextBuffer buffer = this.realBuffer;
            if (buffer == null) {
                throw this.newExpiredTextBufferException();
            }
            buffer.getText(offset, length, segment);
        }

        public void writeLock() throws ReadOnlyException {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                buffer.writeLock();
            } else {
                this.lock.writeLock();
            }
        }

        public void writeLock(boolean checkIfReadOnly) throws ReadOnlyException {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                buffer.writeLock(checkIfReadOnly);
            } else {
                this.lock.writeLock();
            }
        }

        public boolean tryWriteLock() throws ReadOnlyException {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.tryWriteLock();
            }
            return this.lock.tryWriteLock();
        }

        public void writeUnlock() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                buffer.writeUnlock();
            } else {
                this.lock.writeUnlock();
            }
        }

        public void readLock() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                buffer.readLock();
            } else {
                this.lock.readLock();
            }
        }

        public int getLockStatus() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.getLockStatus();
            }
            if (this.lock.isWriteLockHeld()) {
                return 2;
            }
            if (this.lock.isReadLockHeld()) {
                return 1;
            }
            return 0;
        }

        public boolean tryReadLock() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.tryReadLock();
            }
            return this.lock.tryReadLock();
        }

        public void readUnlock() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                buffer.readUnlock();
            } else {
                this.lock.readUnlock();
            }
        }

        public boolean addWriteLockRequestListener(WriteLockRequestListener listener) {
            if (listener == null) {
                throw new NullArgumentException("null listener");
            }
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.addWriteLockRequestListener(listener);
            }
            return this.lock.addWriteLockRequestListener(listener);
        }

        public void removeWriteLockRequestListener(WriteLockRequestListener listener) {
            if (listener == null) {
                throw new NullArgumentException("null listener");
            }
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                buffer.removeWriteLockRequestListener(listener);
            } else {
                this.lock.removeWriteLockRequestListener(listener);
            }
        }
    }
}

