/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import oracle.ide.model.ContentType;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.Node;
import oracle.ide.model.RecognizerException;
import oracle.ide.model.UnrecognizedTextNode;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.xml.XMLRecognizer;

public abstract class Recognizer {
    private static final HashSet _extensionsForXML = new HashSet();
    private static final HashMap _customRecognizerMap = new HashMap();
    private static final ArrayList _lowPriorityRecognizers = new ArrayList();
    private static Recognizer _defaultRecognizer = new Recognizer(){

        public Class recognize(URL url) {
            return null;
        }
    };
    private static final HashMap _extensionToClassMap = new HashMap();
    private static final HashMap _extensionToContentTypeMap = new HashMap();
    private static final HashMap _documentInfoMap = new HashMap();
    private static final HashMap _validNodeClassConversionsMap = new HashMap();
    private static final ForURL _urlRecognizer = new ForURL();

    public abstract Class<? extends Node> recognize(URL var1);

    public Node create(URL url, Class nodeType) throws IllegalAccessException, InstantiationException {
        if (nodeType != null) {
            Node node = (Node)nodeType.newInstance();
            node.setURL(url);
            return node;
        }
        return null;
    }

    public URL validate(URL newURL, URL oldURL) throws RecognizerException {
        return newURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canConvert(URL oldURL, URL newURL) {
        if (oldURL != null && newURL != null) {
            Class<? extends Node> oldClass = Recognizer.recognizeURL(oldURL);
            Class<? extends Node> newClass = this.recognize(newURL);
            if (oldClass != null && newClass != null) {
                HashSet validConversions;
                if (oldClass == newClass) {
                    return true;
                }
                HashMap hashMap = _validNodeClassConversionsMap;
                synchronized (hashMap) {
                    validConversions = (HashSet)_validNodeClassConversionsMap.get(oldClass);
                }
                if (validConversions != null) {
                    return validConversions.contains(newClass);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mapExtensionToClass(String extension, Class cls) {
        if (extension == null || cls == null || extension.length() <= 0) {
            throw new IllegalArgumentException();
        }
        File fileExtension = Recognizer.sanitizeExtension(extension);
        HashMap hashMap = _extensionToClassMap;
        synchronized (hashMap) {
            _extensionToClassMap.put(fileExtension, cls);
        }
    }

    public static void mapExtensionToXML(String extension) {
        if (extension != null) {
            _extensionsForXML.add(Recognizer.sanitizeExtension(extension));
        }
    }

    public static void registerRecognizer(String fileExtension, Recognizer recognizer) {
        if (recognizer != null && fileExtension != null && fileExtension.length() > 0) {
            Recognizer[] newRecognizers;
            File ext = Recognizer.sanitizeExtension(fileExtension);
            Object recognizersObj = _customRecognizerMap.get(ext);
            if (recognizersObj != null) {
                Recognizer[] recognizers = (Recognizer[])recognizersObj;
                int n = recognizers.length;
                newRecognizers = new Recognizer[n + 1];
                System.arraycopy(recognizers, 0, newRecognizers, 0, n);
                newRecognizers[n] = recognizer;
            } else {
                newRecognizers = new Recognizer[]{recognizer};
            }
            _customRecognizerMap.put(ext, newRecognizers);
        }
    }

    public static void registerRecognizer(String[] fileExtensions, Recognizer recognizer) {
        if (fileExtensions != null && recognizer != null) {
            int n = fileExtensions.length;
            for (int i = 0; i < n; ++i) {
                Recognizer.registerRecognizer(fileExtensions[i], recognizer);
            }
        }
    }

    public static void registerLowPriorityRecognizer(Recognizer recognizer) {
        if (recognizer != null && !_lowPriorityRecognizers.contains(recognizer)) {
            _lowPriorityRecognizers.add(recognizer);
        }
    }

    public static Recognizer getDefaultRecognizer() {
        return _defaultRecognizer;
    }

    public static void setDefaultRecognizer(Recognizer recognizer) {
        if (recognizer != null) {
            _defaultRecognizer = recognizer;
        }
    }

    public static Class<? extends Node> getDefaultNodeType() {
        return UnrecognizedTextNode.class;
    }

    protected static boolean isXmlExtension(String extension) {
        if (extension != null) {
            return _extensionsForXML.contains(Recognizer.sanitizeExtension(extension));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void registerConversion(Class<? extends Node> oldNodeType, Class<? extends Node> newNodeType) {
        if (oldNodeType == null || newNodeType == null) {
            throw new IllegalArgumentException();
        }
        HashMap hashMap = _validNodeClassConversionsMap;
        synchronized (hashMap) {
            HashSet validConversions = (HashSet)_validNodeClassConversionsMap.get(oldNodeType);
            if (validConversions != null) {
                validConversions.add(newNodeType);
            } else {
                HashSet<Class<? extends Node>> newValidConversions = new HashSet<Class<? extends Node>>();
                newValidConversions.add(newNodeType);
                _validNodeClassConversionsMap.put(oldNodeType, newValidConversions);
            }
        }
    }

    public static Recognizer findRecognizer(URL url) {
        if (url != null) {
            Iterator iter = Recognizer.getRecognizerIterator(url);
            while (iter.hasNext()) {
                Recognizer recognizer = (Recognizer)iter.next();
                Class<? extends Node> nodeType = recognizer.recognize(url);
                if (nodeType == null) continue;
                return recognizer;
            }
        }
        return null;
    }

    public static Class<? extends Node> recognizeURL(URL url) {
        return Recognizer.recognizeURL(url, Recognizer.getDefaultNodeType());
    }

    public static Class<? extends Node> recognizeURL(URL url, Class<? extends Node> defaultNodeType) {
        if (url != null) {
            Iterator iter = Recognizer.getRecognizerIterator(url);
            while (iter.hasNext()) {
                Recognizer recognizer = (Recognizer)iter.next();
                Class<? extends Node> nodeType = recognizer.recognize(url);
                if (nodeType == null) continue;
                return nodeType;
            }
        }
        return defaultNodeType;
    }

    public static final Map getExtensionToClassMap() {
        return _extensionToClassMap;
    }

    public static final Map getExtensionToContentTypeMap() {
        return _extensionToContentTypeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DocumentInfo getDocumentInfo(Class nodeClass) {
        HashMap hashMap = _documentInfoMap;
        synchronized (hashMap) {
            return (DocumentInfo)_documentInfoMap.get(nodeClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Class getClassForExtension(String extension) {
        if (extension == null || extension.length() <= 0) {
            throw new IllegalArgumentException();
        }
        File fileExtension = Recognizer.sanitizeExtension(extension);
        HashMap hashMap = _extensionToClassMap;
        synchronized (hashMap) {
            return (Class)_extensionToClassMap.get(fileExtension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ContentType getContentTypeForExtension(String extension) {
        if (extension == null || extension.length() <= 0) {
            throw new IllegalArgumentException();
        }
        File fileExtension = Recognizer.sanitizeExtension(extension);
        HashMap hashMap = _extensionToContentTypeMap;
        synchronized (hashMap) {
            return (ContentType)_extensionToContentTypeMap.get(fileExtension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void mapExtensionToContentType(String extension, ContentType contentType) {
        if (extension == null || contentType == null || extension.length() <= 0) {
            throw new IllegalArgumentException();
        }
        File fileExtension = Recognizer.sanitizeExtension(extension);
        HashMap hashMap = _extensionToContentTypeMap;
        synchronized (hashMap) {
            _extensionToContentTypeMap.put(fileExtension, contentType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void registerDocumentInfo(Class nodeClass, DocumentInfo info) {
        HashMap hashMap = _documentInfoMap;
        synchronized (hashMap) {
            _documentInfoMap.put(nodeClass, info);
        }
    }

    public static final File sanitizeExtension(String extension) {
        if (extension.charAt(0) != '.') {
            extension = "." + extension;
        }
        return new File(extension);
    }

    static Iterator getRecognizerIterator(URL url) {
        String fileName = URLFileSystem.getFileName((URL)url);
        int firstDot = fileName != null ? fileName.indexOf(".") : -1;
        final String initialSuffix = firstDot >= 0 ? fileName.substring(firstDot) : "";
        return new Iterator(){
            private String _suffix;
            private LinkedList _cur;
            private boolean _triedLowPriorityRecognizers;
            {
                this._suffix = initialSuffix;
                this._cur = new LinkedList();
                this._triedLowPriorityRecognizers = false;
            }

            @Override
            public boolean hasNext() {
                this.maybePrepare();
                return this._cur != null;
            }

            public Object next() {
                this.maybePrepare();
                return this._cur.removeFirst();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void maybePrepare() {
                if (this._cur != null && this._cur.size() <= 0) {
                    while (this._suffix.length() > 0) {
                        File ext = Recognizer.sanitizeExtension(this._suffix);
                        int nextDot = this._suffix.indexOf(".", 1);
                        this._suffix = nextDot >= 1 ? this._suffix.substring(nextDot) : "";
                        Object customRecognizersObj = _customRecognizerMap.get(ext);
                        if (customRecognizersObj != null) {
                            Object[] array = (Object[])customRecognizersObj;
                            int n = array.length;
                            for (int i = 0; i < n; ++i) {
                                this._cur.add(array[i]);
                            }
                        }
                        if (_extensionsForXML.contains(ext)) {
                            this._cur.add(XMLRecognizer.getInstance());
                        }
                        if (_extensionToClassMap.containsKey(ext)) {
                            this._cur.add(_urlRecognizer);
                        }
                        if (this._cur.size() <= 0) continue;
                        return;
                    }
                    if (!this._triedLowPriorityRecognizers) {
                        this._triedLowPriorityRecognizers = true;
                        this._cur.addAll(_lowPriorityRecognizers);
                        this._cur.add(_defaultRecognizer);
                        return;
                    }
                    this._cur = null;
                }
            }
        };
    }

    private static final class ForURL
    extends Recognizer {
        private ForURL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Class recognize(URL url) {
            String extension = URLFileSystem.getSuffix((URL)url);
            File fileExtension = new File(extension);
            if (extension != null && extension.length() > 0) {
                Object classFromExtension;
                Map extensionToClassMap;
                Map map = extensionToClassMap = ForURL.getExtensionToClassMap();
                synchronized (map) {
                    classFromExtension = extensionToClassMap.get(fileExtension);
                }
                if (classFromExtension != null) {
                    return (Class)classFromExtension;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public URL validate(URL newURL, URL oldURL) throws RecognizerException {
            Map extensionToClassMap;
            String extension = URLFileSystem.getSuffix((URL)newURL);
            File fileExtension = new File(extension);
            Map map = extensionToClassMap = ForURL.getExtensionToClassMap();
            synchronized (map) {
                if (extensionToClassMap.containsKey(fileExtension)) {
                    return newURL;
                }
            }
            if (this.recognize(oldURL) != null) {
                String oldExtension = URLFileSystem.getSuffix((URL)oldURL);
                try {
                    String newPath = newURL.getPath() + oldExtension;
                    return URLFactory.replacePathPart((URL)newURL, (String)newPath);
                }
                catch (Exception e) {
                    throw new RecognizerException("Internal exception: Unable to build new URL: " + e.getLocalizedMessage());
                }
            }
            throw new RecognizerException("Internal exception: Old URL not recognized.");
        }
    }
}

