/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.exception.ChangeVetoException;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Folder;
import oracle.ide.model.HashStructureNode;
import oracle.ide.model.IdeVetoableSubject;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.OwnerMap;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Reference;
import oracle.ide.model.Subject;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.VetoableSubject;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.ModelArb;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.icons.OracleIcons;

public final class Project
extends HashStructureNode
implements VetoableSubject {
    public static final String EXT = ".jpr";
    public static final String DATA_KEY = "Project";
    public static final String NAMESPACE_URI = "http://xmlns.oracle.com/ide/project";
    public static final String ROOT_QNAME = "jpr:project";
    private final transient StorageListener _storageListener = new StorageListener();
    private static final IdentityHashMap _projectChangeListenersMap = new IdentityHashMap();
    private static final CopyOnWriteArrayList _projectChangeListenersOrder = new CopyOnWriteArrayList();
    private static HashStructure _customizedDefaults = null;

    public Project() {
        this.getAttributes().set(ElementAttributes.DELETEABLE | ElementAttributes.SAVEABLE | ElementAttributes.RENAMEABLE | ElementAttributes.CLOSEABLE | ElementAttributes.SAVEABLE_AS | ElementAttributes.NAVIGABLE | ElementAttributes.BUILDABLE | ElementAttributes.SELECTION_CONTAINER | ElementAttributes.NON_HISTORIED);
    }

    @Override
    public final Icon getIcon() {
        return OracleIcons.getIcon((String)"project.png");
    }

    @Override
    public final Iterator getChildren() {
        return ProjectContent.getInstance(this).getNodeIterator();
    }

    @Override
    @Deprecated
    public final boolean canRemove(Element element) {
        return true;
    }

    @Override
    public final boolean canAdd(Element element) {
        return !(element instanceof Project) && !(element instanceof Workspace);
    }

    @Override
    public final boolean containsChild(Element element) {
        if (element instanceof Locatable) {
            URL url = ((Locatable)((Object)element)).getURL();
            ContentSet allContents = ProjectContent.getInstance(this).getAllContents();
            if (allContents.canHaveMember(url)) {
                return URLFileSystem.exists((URL)url);
            }
        }
        return false;
    }

    @Override
    public final boolean remove(Element element, boolean notify) {
        return true;
    }

    @Override
    public final boolean add(Element element) {
        return true;
    }

    public final boolean add(Node node, String contentSetKey) {
        return ProjectContent.getInstance(this).add(node, contentSetKey);
    }

    public final boolean add(Node[] nodes, String contentSetKey) {
        return ProjectContent.getInstance(this).add(nodes, contentSetKey);
    }

    @Override
    @Deprecated
    public final boolean add(Element element, boolean notify) {
        return true;
    }

    @Override
    public final boolean isDefault() {
        return Ide.isRunning() && this == Ide.getDefaultProject();
    }

    @Deprecated
    public final boolean isDefaultProject() {
        return this.isDefault();
    }

    @Deprecated
    public final Iterator findChildren(Class childType) {
        return ProjectContent.getInstance(this).findChildren(childType);
    }

    @Deprecated
    public final Iterator findChildren(Class[] types) {
        return ProjectContent.getInstance(this).findChildren(types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addProjectChangeListener(String propertyName, ProjectChangeListener listener) {
        if (propertyName != null && listener != null) {
            propertyName = propertyName.intern();
            IdentityHashMap identityHashMap = _projectChangeListenersMap;
            synchronized (identityHashMap) {
                CopyOnWriteArrayList<String> propertyNames = (CopyOnWriteArrayList<String>)_projectChangeListenersMap.get(listener);
                if (propertyNames == null) {
                    propertyNames = new CopyOnWriteArrayList<String>();
                    propertyNames.addIfAbsent(propertyName);
                    _projectChangeListenersMap.put(listener, propertyNames);
                    _projectChangeListenersOrder.addIfAbsent(listener);
                } else {
                    propertyNames.addIfAbsent(propertyName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void removeProjectChangeListener(String propertyName, ProjectChangeListener listener) {
        if (propertyName != null && listener != null) {
            propertyName = propertyName.intern();
            IdentityHashMap identityHashMap = _projectChangeListenersMap;
            synchronized (identityHashMap) {
                CopyOnWriteArrayList propertyNames = (CopyOnWriteArrayList)_projectChangeListenersMap.get(listener);
                if (propertyNames != null) {
                    propertyNames.remove(propertyName);
                    if (propertyNames.size() == 0) {
                        Project.removeProjectChangeListener(listener);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void removeProjectChangeListener(ProjectChangeListener listener) {
        if (listener != null) {
            IdentityHashMap identityHashMap = _projectChangeListenersMap;
            synchronized (identityHashMap) {
                _projectChangeListenersMap.remove(listener);
                _projectChangeListenersOrder.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCustomizedDefaults(HashStructure hash) {
        Class<Project> clazz = Project.class;
        synchronized (Project.class) {
            if (_customizedDefaults != null) {
                throw new IllegalStateException("Project customized defaults are already initialized.");
            }
            _customizedDefaults = hash;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Deprecated
    public final boolean containsOwnedChild(Element child) {
        return false;
    }

    @Deprecated
    public final Folder findOwner(Element element) {
        return null;
    }

    @Deprecated
    public final void add(Node node, Node ownerNode) {
    }

    @Deprecated
    public final Iterator findMyChildren(Class childType) {
        return new ProjectContent.ChildTypeIterator(this.getMyChildren(), childType);
    }

    @Deprecated
    public final Iterator findMyChildren(Class[] types) {
        switch (types.length) {
            case 0: {
                return Collections.EMPTY_LIST.iterator();
            }
            case 1: {
                return this.findMyChildren(types[0]);
            }
        }
        return new ProjectContent.MultiChildTypeIterator(this.getMyChildren(), types);
    }

    @Override
    public final void notifyVetoObservers(Object subject, UpdateMessage change) throws ChangeVetoException {
        ((VetoableSubject)this.getSubject()).notifyVetoObservers(subject, change);
    }

    public static final String getDefaultName() {
        return ModelArb.getString(3);
    }

    @Override
    final void loadImpl() throws IOException {
        if (_customizedDefaults != null) {
            _customizedDefaults.copyTo(this._hash);
        }
        super.loadImpl();
        ProjectContent.initializeContentSets(this, false);
        boolean isDirtyPriorToRemovingOwnerMap = super.isDirty();
        this._hash.remove("ownerMap");
        super.markDirty(isDirtyPriorToRemovingOwnerMap);
    }

    @Override
    final void initListOfChildren() {
    }

    @Override
    protected final HashStructureIO newHashStructureIO() {
        HashStructureIO io = super.newHashStructureIO();
        io.addXpathToFlatten("/*[local-name()='project']/list[@n='ownerMap']/hash");
        return io;
    }

    @Override
    protected final String getNamespaceURI() {
        return NAMESPACE_URI;
    }

    @Override
    protected final String getRootQName() {
        return ROOT_QNAME;
    }

    @Override
    protected final Subject createSubject() {
        return new IdeVetoableSubject();
    }

    @Override
    public final boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((Project)o);
    }

    @Override
    public final Object copyTo(Object object) {
        Project copy = object != null ? (Project)object : new Project();
        this.copyToImpl(copy);
        return copy;
    }

    @Override
    void handleCustomPropsClosed() {
        this._storageListener.handleCustomPropsClosed();
    }

    @Override
    void handleCustomPropsOpened(HashStructure customProperties) {
        this._storageListener.handleCustomPropsOpened(customProperties);
    }

    @Override
    void handleAttachStructureChangeListener(HashStructure hash) {
        this._storageListener.attachStructureChangeListener(this._hash);
    }

    @Override
    void handleDetachStructureChangeListener() {
        this._storageListener.detachStructureChangeListener();
    }

    @Override
    void handlePropertiesCopied(HashStructureNode copy) {
        this._storageListener.fireNodeCopied(copy);
    }

    private Iterator getMyChildren() {
        final Iterator nodeIter = this.getChildren();
        Map ownerMap = OwnerMap.getInstance(this).getMap();
        if (ownerMap != null) {
            final ArrayList<Node> ownedNodes = new ArrayList<Node>();
            for (Reference ref : ownerMap.keySet()) {
                ownedNodes.add(ref.getData());
            }
            final int numOwnedNodes = ownedNodes.size();
            if (numOwnedNodes > 0) {
                return new Iterator(){
                    private Object _next;

                    @Override
                    public boolean hasNext() {
                        this.ensurePrepared();
                        return this._next != null;
                    }

                    public Object next() {
                        this.ensurePrepared();
                        if (this._next == null) {
                            throw new NoSuchElementException();
                        }
                        Object next = this._next;
                        this._next = null;
                        return next;
                    }

                    @Override
                    public void remove() {
                        new UnsupportedOperationException().printStackTrace();
                    }

                    private void ensurePrepared() {
                        if (this._next == null) {
                            while (nodeIter.hasNext()) {
                                Object nodeObj = nodeIter.next();
                                if (this.isOwnedNode(nodeObj)) continue;
                                this._next = nodeObj;
                                return;
                            }
                        }
                    }

                    private boolean isOwnedNode(Object nodeObj) {
                        for (int i = 0; i < numOwnedNodes; ++i) {
                            if (nodeObj != ownedNodes.get(i)) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
        }
        return nodeIter;
    }

    private static boolean namesMatch(String listenerKey, String propertyName) {
        if (propertyName.startsWith(listenerKey)) {
            int listenerKeyLen;
            int propertyNameLen = propertyName.length();
            return propertyNameLen == (listenerKeyLen = listenerKey.length()) || propertyName.charAt(listenerKeyLen) == '/' || listenerKeyLen == 0;
        }
        return false;
    }

    static {
        Node.addNodeListenerForType(Project.class, new NL());
        TechnologyScopeConfiguration.init();
        WorkingSets.init();
        try {
            final int debugLevel = Integer.getInteger("ProjectChangeListener.debug.level", 0);
            if (debugLevel > 0) {
                ProjectChangeListener pcl = new ProjectChangeListener(){
                    private int _eventCounter = 0;

                    @Override
                    void projectLoaded(Project project) {
                        System.out.println("[Project loaded] " + URLFileSystem.getPlatformPathName((URL)project.getURL()));
                    }

                    @Override
                    public void projectOpened(Project project) {
                        System.out.println("[Project opened] " + URLFileSystem.getPlatformPathName((URL)project.getURL()));
                    }

                    @Override
                    public void projectClosed(Project project) {
                        System.out.println("[Project closed] " + URLFileSystem.getPlatformPathName((URL)project.getURL()));
                    }

                    @Override
                    void projectUnloaded(Project project) {
                        System.out.println("[Project unloaded] " + URLFileSystem.getPlatformPathName((URL)project.getURL()));
                    }

                    @Override
                    public void projectPropertiesChanged(ProjectChangeEvent e) {
                        ChangeInfo detail;
                        int i;
                        ChangeInfo[] details = e.getChangeDetails();
                        int n = details.length;
                        boolean hasNonPlaceholderEvent = false;
                        if (debugLevel == 2) {
                            for (i = 0; i < n; ++i) {
                                detail = details[i];
                                if (detail.getChangeType() == 2) {
                                    details[i] = null;
                                    continue;
                                }
                                hasNonPlaceholderEvent = true;
                            }
                        }
                        if (debugLevel > 2 || hasNonPlaceholderEvent) {
                            ++this._eventCounter;
                            for (i = 0; i < details.length; ++i) {
                                detail = details[i];
                                if (detail == null) continue;
                                Project p = e.getProject();
                                if (e.getSource() == p._hash) {
                                    System.out.print("[" + this._eventCounter + "] shared ");
                                } else {
                                    System.out.print("[" + this._eventCounter + "] user   ");
                                }
                                System.out.println(details[i].toString());
                            }
                        }
                    }
                };
                Project.addProjectChangeListener("", pcl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final class StorageListener
    extends StructureChangeListener {
        private HashStructure _projectProps;
        private HashStructure _customProps;

        private StorageListener() {
        }

        private void attachStructureChangeListener(HashStructure projectProps) {
            this._projectProps = projectProps;
            projectProps.addStructureChangeListener((StructureChangeListener)this);
        }

        private void fireNodeCopied(HashStructureNode copy) {
            Project projectCopy = (Project)copy;
            for (ProjectChangeListener listener : _projectChangeListenersOrder) {
                try {
                    long startTime = System.nanoTime();
                    listener.projectCopied(Project.this, projectCopy);
                    long endTime = System.nanoTime();
                    PerformanceLogger.get().log("ProjectChangeListener.projectCopied", listener.getClass().getName(), endTime - startTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void fireProjectLoaded() {
            for (ProjectChangeListener listener : _projectChangeListenersOrder) {
                try {
                    long startTime = System.nanoTime();
                    listener.projectLoaded(Project.this);
                    long endTime = System.nanoTime();
                    PerformanceLogger.get().log("ProjectChangeListener.projectLoaded()", listener.getClass().getName(), endTime - startTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void fireProjectUnloaded() {
            for (ProjectChangeListener listener : _projectChangeListenersOrder) {
                try {
                    long startTime = System.nanoTime();
                    listener.projectUnloaded(Project.this);
                    long endTime = System.nanoTime();
                    PerformanceLogger.get().log("ProjectChangeListener.projectUnloaded", listener.getClass().getName(), endTime - startTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void fireProjectOpened() {
            for (ProjectChangeListener listener : _projectChangeListenersOrder) {
                try {
                    long startTime = System.nanoTime();
                    listener.projectOpened(Project.this);
                    long endTime = System.nanoTime();
                    PerformanceLogger.get().log("ProjectChangeListener.projectOpened", listener.getClass().getName(), endTime - startTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void detachStructureChangeListener() {
            if (this._projectProps != null) {
                this._projectProps.removeStructureChangeListener((StructureChangeListener)this);
            }
        }

        private void fireProjectClosed() {
            for (ProjectChangeListener listener : _projectChangeListenersOrder) {
                try {
                    long startTime = System.nanoTime();
                    listener.projectClosed(Project.this);
                    long endTime = System.nanoTime();
                    PerformanceLogger.get().log("ProjectChangeListener.projectClosed", listener.getClass().getName(), endTime - startTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void handleCustomPropsOpened(HashStructure customProps) {
            this._customProps = customProps;
            customProps.addStructureChangeListener((StructureChangeListener)this);
        }

        private void handleCustomPropsClosed() {
            if (this._customProps != null) {
                this._customProps.removeStructureChangeListener((StructureChangeListener)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void structureValuesChanged(StructureChangeEvent e) {
            ChangeInfo[] details = e.getChangeDetails();
            int n = details.length;
            ArrayList<ChangeInfo> chunkedDetails = new ArrayList<ChangeInfo>();
            for (Object listenerObj : _projectChangeListenersOrder) {
                CopyOnWriteArrayList listenerKeys;
                IdentityHashMap identityHashMap = _projectChangeListenersMap;
                synchronized (identityHashMap) {
                    listenerKeys = (CopyOnWriteArrayList)_projectChangeListenersMap.get(listenerObj);
                }
                if (listenerKeys == null) continue;
                Iterator keyIter = listenerKeys.iterator();
                chunkedDetails.clear();
                while (keyIter.hasNext()) {
                    String listenerKey = keyIter.next().toString();
                    for (int j = 0; j < n; ++j) {
                        ChangeInfo detail = details[j];
                        String propertyName = detail.getPropertyName();
                        if (!Project.namesMatch(listenerKey, propertyName)) continue;
                        chunkedDetails.add(detail);
                    }
                }
                if (chunkedDetails.size() <= 0) continue;
                ChangeInfo[] chunkedDetailsArray = chunkedDetails.toArray(new ChangeInfo[chunkedDetails.size()]);
                ProjectChangeEvent event = new ProjectChangeEvent(e.getSource(), Project.this, chunkedDetailsArray);
                ProjectChangeListener listener = (ProjectChangeListener)listenerObj;
                try {
                    long startTime = System.nanoTime();
                    listener.projectPropertiesChanged(event);
                    long endTime = System.nanoTime();
                    PerformanceLogger.get().log("ProjectChangeListener.projectPropertiesChanged", listener.getClass().getName(), endTime - startTime);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private static final class NL
    extends NodeListener {
        private NL() {
        }

        @Override
        void nodeLoaded(NodeEvent e) {
            ((Project)e.getNode())._storageListener.fireProjectLoaded();
        }

        @Override
        void nodeUnloaded(NodeEvent e) {
            ((Project)e.getNode())._storageListener.fireProjectUnloaded();
        }

        @Override
        public void nodeOpened(NodeEvent e) {
            ((Project)e.getNode())._storageListener.fireProjectOpened();
        }

        @Override
        public void nodeClosed(NodeEvent e) {
            ((Project)e.getNode())._storageListener.fireProjectClosed();
        }
    }
}

