/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import oracle.ide.model.Attributes;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.LazyLoadable;
import oracle.ide.model.Locatable;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Recognizer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemHelperDecorator;
import oracle.ide.performance.PerformanceLogger;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Log;
import oracle.javatools.util.UnexpectedExceptionError;

public class Node
implements Locatable,
Element,
Subject,
Dirtyable,
LazyLoadable {
    private static final boolean STRICT = Boolean.getBoolean("ide.node.state.strict");
    private final Attributes _attributes = new ElementAttributes(ElementAttributes.DELETEABLE);
    private transient long _unmodifiedTimestamp;
    private transient long _timestamp;
    private URL _url;
    private transient String _shortLabel;
    private transient String _longLabel;
    private volatile transient boolean _dirty;
    private transient boolean _migrating;
    private Subject _subjectDelegate;
    private CopyOnWriteArrayList<NodeListener> _listeners = new CopyOnWriteArrayList();
    private static final HashMap<Class, CopyOnWriteArrayList<NodeListener>> _listenersForType = new HashMap();
    private static final HashMap<Class, CopyOnWriteArrayList<NodeListener>> _listenersForTypeHierarchy = new HashMap();
    private volatile transient NodeState state = NodeState.CLOSED;
    private volatile transient boolean isLoaded = false;
    private volatile transient boolean isOpen = false;
    private transient ReadWriteLock _nodeLock;
    private final transient Object unsafeLock = new Object();
    private transient boolean _isFiring;
    private transient boolean _isFiringNodeOpened;
    private transient boolean _markedDirtyFromNodeOpened;
    private transient boolean _openingFromMarkDirty;
    private volatile transient Map _transientProperties;
    protected static final Log LOG_READONLY = new Log("readonly");
    private static final ThreadLocal<ThreadUsageTracker> threadUsageTrackers = new ThreadLocal<ThreadUsageTracker>(){

        @Override
        protected ThreadUsageTracker initialValue() {
            return new ThreadUsageTracker();
        }
    };

    protected ReadWriteLock nodeLock() {
        return this._nodeLock;
    }

    protected void readLock() {
        this._nodeLock.readLock();
    }

    protected void readUnlock() {
        this._nodeLock.readUnlock();
    }

    protected void writeLock() {
        this._nodeLock.writeLock();
    }

    protected void writeUnlock() {
        this._nodeLock.writeUnlock();
    }

    protected void upgradeLock() {
        this._nodeLock.writeLockFromReadLock();
    }

    protected void upgradeUnlock() {
        this.writeUnlock();
    }

    protected final boolean isReadOrWriteLocked() {
        return this._nodeLock.isLockHeld();
    }

    protected final boolean isReadLocked() {
        return this._nodeLock.isReadLockHeld();
    }

    protected final boolean isWriteLocked() {
        return this._nodeLock.isWriteLockHeld();
    }

    protected final int lockCount() {
        return this.readLockCount() + this.writeLockCount();
    }

    protected final int readLockCount() {
        return this._nodeLock.getReadHoldCount();
    }

    protected final int writeLockCount() {
        return this._nodeLock.getWriteHoldCount();
    }

    public Node() {
        this._nodeLock = new ReadWriteLock(this.getClass().getSimpleName() + "#" + this.hashCode());
    }

    public Node(URL url) {
        this._nodeLock = new ReadWriteLock(url != null ? URLFileSystem.getFileName((URL)url) : this.getClass().getSimpleName() + "#" + this.hashCode());
        this.setURL(url);
    }

    public static void addNodeListenerForType(Class type, NodeListener listener) {
        Node.mapTypeToListener(_listenersForType, listener, type);
    }

    public static void removeNodeListenerForType(Class type, NodeListener listener) {
        Node.unmapListenerFromType(_listenersForType, listener, type);
    }

    public static void addNodeListenerForTypeHierarchy(Class type, NodeListener listener) {
        Node.mapTypeToListener(_listenersForTypeHierarchy, listener, type);
    }

    public static void removeNodeListenerForTypeHierarchy(Class type, NodeListener listener) {
        Node.unmapListenerFromType(_listenersForTypeHierarchy, listener, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mapTypeToListener(HashMap<Class, CopyOnWriteArrayList<NodeListener>> listeners, NodeListener listener, Class type) {
        if (listener != null && type != null && Node.class.isAssignableFrom(type)) {
            HashMap<Class, CopyOnWriteArrayList<NodeListener>> hashMap = listeners;
            synchronized (hashMap) {
                CopyOnWriteArrayList<NodeListener> listenerList = listeners.get(type);
                if (listenerList == null) {
                    listenerList = new CopyOnWriteArrayList();
                    listeners.put(type, listenerList);
                }
                listenerList.addIfAbsent(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unmapListenerFromType(HashMap<Class, CopyOnWriteArrayList<NodeListener>> listeners, NodeListener listener, Class type) {
        if (listener != null && type != null) {
            HashMap<Class, CopyOnWriteArrayList<NodeListener>> hashMap = listeners;
            synchronized (hashMap) {
                CopyOnWriteArrayList<NodeListener> listenerList = listeners.get(type);
                if (listenerList != null && listenerList.remove(listener) && listenerList.isEmpty()) {
                    listeners.remove(type);
                }
            }
        }
    }

    public final void addNodeListener(NodeListener listener) {
        this._listeners.addIfAbsent(listener);
    }

    public final void removeNodeListener(NodeListener listener) {
        this._listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL() {
        Object object = this.unsafeLock;
        synchronized (object) {
            return this._url;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setURL(URL newURL) {
        Object object = this.unsafeLock;
        synchronized (object) {
            if (this.isTrackedInNodeCache()) {
                URL oldURL = this._url;
                this._url = newURL;
                NodeFactory.recache(oldURL, newURL, this);
            } else {
                this._url = newURL;
            }
            this._shortLabel = null;
            this._longLabel = null;
            this._nodeLock.setName(newURL != null ? URLFileSystem.getFileName((URL)newURL) : this.getClass().getSimpleName() + "#" + this.hashCode());
        }
    }

    protected boolean isTrackedInNodeCache() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        Object object = this.unsafeLock;
        synchronized (object) {
            return this._dirty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDirty(boolean dirty) {
        block18: {
            this.readLock();
            try {
                if (dirty == this.getAttributes().isSet(ElementAttributes.DIRTY)) {
                    return;
                }
            }
            finally {
                this.readUnlock();
            }
            this.writeLock();
            try {
                if (this._isFiringNodeOpened && dirty) {
                    this._markedDirtyFromNodeOpened = true;
                    return;
                }
                if (this._openingFromMarkDirty && !dirty) {
                    throw new IllegalStateException("markDirty(true) is forcing " + this.getShortLabel() + " open, but a node opened listener called markDirty(false)");
                }
                Attributes attributes = this.getAttributes();
                if (dirty == this.getAttributes().isSet(ElementAttributes.DIRTY)) break block18;
                if (dirty && this.isLoaded() && !Boolean.TRUE.equals(this.getTransientProperties().get("blockOpenOnDirty"))) {
                    this._openingFromMarkDirty = true;
                    try {
                        this.ensureOpen();
                    }
                    finally {
                        this._openingFromMarkDirty = false;
                    }
                }
                this._dirty = dirty;
                Attributes oldAttributes = attributes.duplicate();
                if (dirty) {
                    attributes.set(ElementAttributes.DIRTY);
                } else {
                    attributes.unset(ElementAttributes.DIRTY);
                }
                this.markDirtyImpl(dirty);
                if (!this._openingFromMarkDirty) {
                    this.fireNodeDirtyStateChanged(dirty, oldAttributes);
                }
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getShortLabel() {
        Object object = this.unsafeLock;
        synchronized (object) {
            if (this._shortLabel == null) {
                URL url = this.getURL();
                this._shortLabel = url == null ? "<null>" : URLFileSystem.getFileName((URL)url);
            }
            return this._shortLabel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLongLabel() {
        Object object = this.unsafeLock;
        synchronized (object) {
            if (this._longLabel == null) {
                URL url = this.getURL();
                this._longLabel = url == null ? "<null>" : URLFileSystem.getPlatformPathName((URL)url);
            }
            return this._longLabel;
        }
    }

    @Override
    public Icon getIcon() {
        return OracleIcons.getIcon((String)"file.png");
    }

    @Override
    public String getToolTipText() {
        return URLFileSystem.toDisplayString((URL)this.getURL());
    }

    @Override
    public final void attach(Observer observer) {
        this.getSubject().attach(observer);
    }

    @Override
    public final void detach(Observer observer) {
        this.getSubject().detach(observer);
    }

    @Override
    public void notifyObservers(Object observed, UpdateMessage change) {
        this.getSubject().notifyObservers(observed, change);
    }

    protected final Subject getSubject() {
        if (this._subjectDelegate == null) {
            this._subjectDelegate = this.createSubject();
        }
        return this._subjectDelegate;
    }

    protected Subject createSubject() {
        return new IdeSubject();
    }

    @Override
    public Object getData() {
        return this;
    }

    @Override
    public boolean mayHaveChildren() {
        return false;
    }

    public Iterator getChildren() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Attributes getAttributes() {
        Object object = this.unsafeLock;
        synchronized (object) {
            return this._attributes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map getTransientProperties() {
        Node.threadUsageTrackers.get().loadInvoked(this);
        Map properties = this._transientProperties;
        if (properties != null) {
            return properties;
        }
        this.upgradeLock();
        try {
            if (this._transientProperties == null) {
                switch (this.state) {
                    case UNLOADING: {
                        break;
                    }
                    default: {
                        this.ensureLoad();
                    }
                }
                this._transientProperties = new ConcurrentHashMap();
            }
            Map map = this._transientProperties;
            return map;
        }
        finally {
            this.upgradeUnlock();
        }
    }

    public final void open() throws IOException {
        this.open(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void open(boolean invokeOpenImpl) throws IOException {
        Node.threadUsageTrackers.get().openInvoked(this);
        if (this.isOpen()) {
            return;
        }
        this.upgradeLock();
        try {
            switch (this.state) {
                case LOADING: {
                    if (!STRICT) return;
                    throw new IllegalStateException(this.getClass().getName() + ".loadImpl() recursively invokes open for " + this.getLongLabel());
                }
                case UNLOADING: {
                    throw new IllegalStateException(this.getClass().getName() + ".unloadImpl() recursively invokes open for " + this.getLongLabel());
                }
                case OPENING: {
                    if (this._isFiring) {
                        throw new IllegalStateException("nodeWillOpen listener for " + this.getClass().getName() + " invokes open for " + this.getLongLabel());
                    }
                    if (!STRICT) return;
                    throw new IllegalStateException(this.getClass().getName() + ".openImpl() recursively invokes open for " + this.getLongLabel());
                }
                case CLOSING: {
                    throw new IllegalStateException(this.getClass().getName() + ".closeImpl() recursively invokes open for " + this.getLongLabel());
                }
                case CLOSED: {
                    this.load(invokeOpenImpl);
                    if (this.state != NodeState.LOADED) {
                        throw new IllegalStateException("unexpected state after load");
                    }
                }
                case LOADED: {
                    this.state = NodeState.OPENING;
                    try {
                        this.fireNodeWillOpen();
                        if (invokeOpenImpl) {
                            this.openImpl();
                        }
                        this.refreshTimestamp();
                    }
                    finally {
                        this.state = NodeState.LOADED;
                    }
                    this.state = NodeState.OPEN;
                    this.isOpen = true;
                    this.fireNodeOpened();
                    return;
                }
            }
            return;
        }
        finally {
            this.upgradeUnlock();
        }
    }

    public final void close() throws IOException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void close(boolean invokeCloseImpl) throws IOException {
        if (!this.isLoaded()) {
            return;
        }
        boolean invokeUnloadImpl = invokeCloseImpl;
        this.writeLock();
        try {
            switch (this.state) {
                case LOADING: {
                    throw new IllegalStateException(this.getClass().getName() + ".loadImpl() invokes close for " + this.getLongLabel());
                }
                case UNLOADING: {
                    throw new IllegalStateException(this.getClass().getName() + ".unloadImpl() invokes close for " + this.getLongLabel());
                }
                case OPENING: {
                    if (!this._isFiring) throw new IllegalStateException(this.getClass().getName() + ".openImpl() invokes close for " + this.getLongLabel());
                    throw new IllegalStateException("nodeWillOpen listener for " + this.getClass().getName() + " invokes close for " + this.getLongLabel());
                }
                case CLOSING: {
                    if (this._isFiring) {
                        throw new IllegalStateException("nodeWillClose listener for " + this.getClass().getName() + " invokes close for " + this.getLongLabel());
                    }
                    if (!STRICT) return;
                    throw new IllegalStateException(this.getClass().getName() + ".closeImpl() invokes close for " + this.getLongLabel());
                }
                case LOADED: {
                    if (invokeCloseImpl) {
                        invokeCloseImpl = false;
                    }
                }
                case OPEN: {
                    this.state = NodeState.CLOSING;
                    try {
                        this.fireNodeWillClose();
                        this.isOpen = false;
                        if (invokeCloseImpl) {
                            this.closeImpl();
                        }
                        this.markDirty(false);
                    }
                    finally {
                        this.state = NodeState.OPEN;
                    }
                    this.state = NodeState.LOADED;
                    this.fireNodeClosed();
                    this.unload(invokeUnloadImpl);
                    return;
                }
            }
            return;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save() throws IOException {
        this.writeLock();
        try {
            if (this.isLoaded() && (this.isDirty() || this.isNew())) {
                this.fireNodeWillBeSaved();
                this.saveImpl();
                this.markDirty(false);
                this.refreshTimestamp();
                this.fireNodeSaved();
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void revert() throws IOException {
        this.writeLock();
        try {
            if (this.isOpen()) {
                this.revertImpl();
                this.refreshTimestamp();
                this.markDirty(false);
                this.fireNodeReverted();
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public final void delete() {
        URLFileSystem.delete((URL)this.getURL());
    }

    public final Node rename(URL newURL) throws IOException {
        URLFileSystem.renameEx((URL)this.getURL(), (URL)newURL);
        return NodeFactory.find(newURL);
    }

    @Override
    public final boolean isOpen() {
        return this.isOpen;
    }

    public boolean isReadOnly() {
        if (this.supportsLoaded() && this.isLoaded && !this.isOpen) {
            return true;
        }
        if (this.getAttributes().isSet(ElementAttributes.NON_EDITABLE)) {
            return true;
        }
        return URLFileSystem.isReadOnly((URL)this.getURL());
    }

    public boolean setReadOnly(boolean readOnly) {
        LOG_READONLY.trace("setting node {1} read-only {0}", readOnly, (Object)this.getURL());
        if (this.getAttributes().isSet(ElementAttributes.NON_EDITABLE)) {
            return false;
        }
        URL url = this.getURL();
        if (url == null) {
            return false;
        }
        return URLFileSystem.setReadOnly((URL)url, (boolean)readOnly);
    }

    protected void urlReadOnlyChanged() {
        LOG_READONLY.trace("node {0} read-only changed", (Object)this.getURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isMigrating() {
        this.readLock();
        try {
            boolean bl = this._migrating;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setMigrating() {
        this.readLock();
        try {
            if (this._migrating) {
                return;
            }
        }
        finally {
            this.readUnlock();
        }
        this.writeLock();
        try {
            this._migrating = true;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void unsetMigrating(boolean fireEvents) {
        this.readLock();
        try {
            if (!this._migrating) {
                return;
            }
        }
        finally {
            this.readUnlock();
        }
        this.writeLock();
        try {
            this._migrating = false;
        }
        finally {
            this.writeUnlock();
        }
        if (fireEvents && this.isLoaded()) {
            this.fireNodeLoaded();
            if (this.isOpen()) {
                this.fireNodeWillOpen();
                this.fireNodeOpened();
            }
        }
    }

    boolean supportsLoaded() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getTimestamp() {
        this.readLock();
        try {
            Object object = this.unsafeLock;
            synchronized (object) {
                if (this._timestamp <= 0L) {
                    this._timestamp = URLFileSystem.lastModified((URL)this.getURL());
                }
                long l = this._timestamp;
                return l;
            }
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getUnmodifiedTimestamp() {
        Object object = this.unsafeLock;
        synchronized (object) {
            if (this._unmodifiedTimestamp <= 0L) {
                this._unmodifiedTimestamp = URLFileSystem.lastModified((URL)this.getURL());
            }
            return this._unmodifiedTimestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long refreshTimestamp() {
        URL url = this.getURL();
        Object object = this.unsafeLock;
        synchronized (object) {
            this._timestamp = this._unmodifiedTimestamp = URLFileSystem.lastModified((URL)url);
            return this._timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setTimestampDirectly(long timestamp) {
        this.readLock();
        try {
            Object object = this.unsafeLock;
            synchronized (object) {
                this._timestamp = timestamp;
            }
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getTimestampLoadedUnsafe() {
        Object object = this.unsafeLock;
        synchronized (object) {
            if (this.isLoaded) {
                if (this._timestamp <= 0L) {
                    this._timestamp = URLFileSystem.lastModified((URL)this.getURL());
                }
                return this._timestamp;
            }
            return -1L;
        }
    }

    public InputStream getInputStream() throws IOException {
        try {
            URL url = this.getURL();
            return URLFileSystem.openInputStream((URL)url);
        }
        catch (FileNotFoundException e) {
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    public final boolean isNew() {
        return !URLFileSystem.exists((URL)this.getURL());
    }

    @Override
    public String toString() {
        return this.getShortLabel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runUnderReadLock(Runnable runnable) {
        this.readLock();
        try {
            runnable.run();
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runUnderWriteLock(Runnable runnable) {
        this.writeLock();
        try {
            runnable.run();
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <V> V callUnderReadLock(Callable<V> callable) throws Exception {
        this.readLock();
        try {
            V v = callable.call();
            return v;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <V> V callUnderWriteLock(Callable<V> callable) throws Exception {
        this.writeLock();
        try {
            V v = callable.call();
            return v;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean tryRunUnderReadLock(Runnable runnable) {
        boolean result = this._nodeLock.tryReadLock();
        if (result) {
            try {
                runnable.run();
            }
            finally {
                this._nodeLock.readUnlock();
            }
        }
        return result;
    }

    public static void beginThreadNodeUsageCycle() {
        Node.threadUsageTrackers.get().begin();
    }

    public static void endThreadNodeUsageCycle() {
        Node.threadUsageTrackers.get().end();
    }

    public static void endThreadNodeUsage(Node node) {
        Node.threadUsageTrackers.get().end(node);
    }

    protected void openImpl() throws IOException {
    }

    protected void closeImpl() throws IOException {
    }

    protected void markDirtyImpl(boolean dirty) {
    }

    protected void saveImpl() throws IOException {
    }

    protected void revertImpl() throws IOException {
        this.closeImpl();
        this.openImpl();
    }

    protected void deleteImpl() throws IOException {
    }

    protected void renameImpl(URL oldURL, URL newURL) throws IOException {
    }

    protected final boolean equalsImpl(Node node) {
        URL thisUrl = this.getURL();
        URL thatUrl = node.getURL();
        return thisUrl == null ? thatUrl == null : thisUrl.equals(thatUrl);
    }

    protected final void setOpen(boolean open) {
        try {
            if (open) {
                this.open(false);
            } else {
                this.close(false);
            }
        }
        catch (IOException e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
    }

    public final boolean ensureOpen() {
        try {
            this.open();
            return true;
        }
        catch (Exception e) {
            this.reportOpenException(e);
            return false;
        }
    }

    protected void reportOpenException(Exception e) {
        e.printStackTrace();
    }

    final void load() throws IOException {
        this.load(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void load(boolean invokeLoadImpl) throws IOException {
        Node.threadUsageTrackers.get().loadInvoked(this);
        if (this.isLoaded()) {
            return;
        }
        this.upgradeLock();
        try {
            switch (this.state) {
                case LOADING: {
                    if (!STRICT) return;
                    throw new IllegalStateException(this.getClass().getName() + ".loadImpl() invokes load for " + this.getLongLabel());
                }
                case UNLOADING: {
                    throw new IllegalStateException(this.getClass().getName() + ".unloadImpl() invokes load for " + this.getLongLabel());
                }
                case CLOSED: {
                    this.state = NodeState.LOADING;
                    try {
                        if (invokeLoadImpl) {
                            this.loadImpl();
                        }
                        this.refreshTimestamp();
                    }
                    finally {
                        this.state = NodeState.CLOSED;
                    }
                    this.state = NodeState.LOADED;
                    this.isLoaded = true;
                    this.fireNodeLoaded();
                    return;
                }
            }
            return;
        }
        finally {
            this.upgradeUnlock();
        }
    }

    void loadImpl() throws IOException {
    }

    public final boolean isLoaded() {
        return this.isLoaded;
    }

    final boolean ensureLoad() {
        try {
            this.load();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    final void unload() {
        this.unload(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void unload(boolean invokeUnloadImpl) {
        this.writeLock();
        try {
            switch (this.state) {
                case LOADING: {
                    throw new IllegalStateException(this.getClass().getName() + ".loadImpl() invokes unload for " + this.getLongLabel());
                }
                case UNLOADING: {
                    if (!STRICT) return;
                    throw new IllegalStateException(this.getClass().getName() + ".unloadImpl() invokes unload for " + this.getLongLabel());
                }
                case OPENING: {
                    if (!this._isFiring) throw new IllegalStateException(this.getClass().getName() + ".openImpl() invokes unload for " + this.getLongLabel());
                    throw new IllegalStateException("nodeWillOpen listener for " + this.getClass().getName() + " invokes unload for " + this.getLongLabel());
                }
                case OPEN: {
                    throw new IllegalStateException("open invoked " + this.getClass().getName() + " invokes unload for " + this.getLongLabel());
                }
                case CLOSING: {
                    throw new IllegalStateException(this.getClass().getName() + ".closeImpl() invokes unload for " + this.getLongLabel());
                }
                case LOADED: {
                    this.isLoaded = false;
                    this._transientProperties = null;
                    this.state = NodeState.UNLOADING;
                    if (invokeUnloadImpl) {
                        try {
                            this.unloadImpl();
                        }
                        finally {
                            this.state = NodeState.LOADED;
                        }
                    }
                    this.state = NodeState.CLOSED;
                    this.fireNodeUnloaded();
                    return;
                }
            }
            return;
        }
        finally {
            this.writeUnlock();
        }
    }

    void unloadImpl() {
    }

    final void copyToImpl(Node copy) {
        copy._url = this._url;
        copy.isOpen = this.isOpen;
        copy.isLoaded = this.isLoaded;
        copy.state = this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteInternal(URLFileSystemHelper helper) throws IOException {
        this.writeLock();
        try {
            this.close();
            this.deleteImpl();
            URL url = this.getURL();
            helper.delete(url);
            this.fireNodeDeleted();
            NodeFactory.uncache(url);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameInternal(URL newURL, URLFileSystemHelper helper) throws IOException {
        this.writeLock();
        try {
            Class<? extends Node> newNodeType;
            Class<?> oldNodeType;
            URL oldURL = this.getURL();
            this.renameImpl(oldURL, newURL);
            helper.rename(oldURL, newURL);
            Node replacedNode = NodeFactory.find(newURL);
            if (replacedNode != null) {
                NodeFactory.uncache(newURL);
            }
            if ((oldNodeType = this.getClass()) == (newNodeType = Recognizer.recognizeURL(newURL))) {
                this.setURL(newURL);
            } else {
                try {
                    NodeFactory.findOrCreate(newURL);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.fireNodeRenamed(oldURL, newURL);
            if (oldNodeType != newNodeType) {
                NodeFactory.uncache(oldURL);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private boolean checkEventFiringConditions() {
        if (this.isMigrating()) {
            return false;
        }
        if (this._isFiring) {
            throw new IllegalStateException("reentrant node change");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeEvent(String description, NodeEventClosure closure) {
        this._isFiring = true;
        try {
            NodeEvent event = null;
            NodeListenerIterator i = new NodeListenerIterator();
            while (i.hasNext()) {
                if (event == null) {
                    event = new NodeEvent(this);
                }
                NodeListener listener = (NodeListener)i.next();
                try {
                    long startTime = System.nanoTime();
                    closure.run(listener, event);
                    long endTime = System.nanoTime();
                    PerformanceLogger.get().log("NodeListener." + description, listener.getClass().getName(), endTime - startTime);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        finally {
            this._isFiring = false;
        }
    }

    private void fireNodeLoaded() {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this.fireNodeEvent("nodeLoaded()", new NodeEventClosure(){

            @Override
            public void run(NodeListener listener, NodeEvent e) {
                listener.nodeLoaded(e);
            }
        });
    }

    private void fireNodeUnloaded() {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this.fireNodeEvent("nodeUnloaded()", new NodeEventClosure(){

            @Override
            public void run(NodeListener listener, NodeEvent e) {
                listener.nodeUnloaded(e);
            }
        });
    }

    private void fireNodeWillOpen() {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this.fireNodeEvent("nodeWillOpen()", new NodeEventClosure(){

            @Override
            public void run(NodeListener listener, NodeEvent e) {
                listener.nodeWillOpen(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeOpened() {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this._markedDirtyFromNodeOpened = false;
        this._isFiringNodeOpened = true;
        try {
            this.fireNodeEvent("nodeOpened()", new NodeEventClosure(){

                @Override
                public void run(NodeListener listener, NodeEvent e) {
                    listener.nodeOpened(e);
                }
            });
        }
        finally {
            this._isFiringNodeOpened = false;
        }
        if (this._markedDirtyFromNodeOpened) {
            this.markDirty(true);
        }
    }

    private void fireNodeDirtyStateChanged(final boolean isNowDirty, Attributes oldAttributes) {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this.fireNodeEvent("nodeDirtyStateChanged()", new NodeEventClosure(){

            @Override
            public void run(NodeListener listener, NodeEvent e) {
                listener.nodeDirtyStateChanged(e, isNowDirty);
            }
        });
        UpdateMessage.fireAttributeChanged(this, oldAttributes);
    }

    private void fireNodeWillBeSaved() {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this.fireNodeEvent("nodeWillBeSaved()", new NodeEventClosure(){

            @Override
            public void run(NodeListener listener, NodeEvent e) {
                listener.nodeWillBeSaved(e);
            }
        });
    }

    private void fireNodeWillClose() {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this.fireNodeEvent("nodeWillClose()", new NodeEventClosure(){

            @Override
            public void run(NodeListener listener, NodeEvent e) {
                listener.nodeWillClose(e);
            }
        });
    }

    private void fireNodeClosed() {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this.fireNodeEvent("nodeClosed()", new NodeEventClosure(){

            @Override
            public void run(NodeListener listener, NodeEvent e) {
                listener.nodeClosed(e);
            }
        });
    }

    private void fireNodeSaved() {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this.fireNodeEvent("nodeSaved()", new NodeEventClosure(){

            @Override
            public void run(NodeListener listener, NodeEvent e) {
                listener.nodeSaved(e);
            }
        });
    }

    private void fireNodeReverted() {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this.fireNodeEvent("nodeReverted()", new NodeEventClosure(){

            @Override
            public void run(NodeListener listener, NodeEvent e) {
                listener.nodeReverted(e);
            }
        });
    }

    private void fireNodeDeleted() {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this.fireNodeEvent("nodeDeleted()", new NodeEventClosure(){

            @Override
            public void run(NodeListener listener, NodeEvent e) {
                listener.nodeDeleted(e);
            }
        });
    }

    private void fireNodeRenamed(final URL oldURL, final URL newURL) {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this.fireNodeEvent("nodeRenamed()", new NodeEventClosure(){

            @Override
            public void run(NodeListener listener, NodeEvent e) {
                listener.nodeRenamed(e, oldURL, newURL);
            }
        });
    }

    private static void addDeleteRenameInterceptor(String protocol) {
        URLFileSystemHelper helper = URLFileSystem.findHelper((String)protocol);
        DeleteRenameInterceptor interceptor = new DeleteRenameInterceptor(helper);
        URLFileSystem.registerHelper((String)protocol, (URLFileSystemHelper)interceptor);
    }

    public void setEventLog(Log log) {
        this._nodeLock.setEventLog(log);
    }

    static {
        Node.addDeleteRenameInterceptor("file");
        Node.addDeleteRenameInterceptor("http");
        Node.addDeleteRenameInterceptor("https");
        Node.addNodeListenerForTypeHierarchy(Node.class, new NodeListener(){

            @Override
            public void nodeOpened(final NodeEvent e) {
                14.invokeLaterIfNeeded(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Node node = e.getNode();
                        String key = node.getClass().getName() + ".fireObjectOpened";
                        PerformanceLogger.get().startTiming(key);
                        try {
                            UpdateMessage.fireObjectOpened(node);
                        }
                        finally {
                            PerformanceLogger.get().stopTiming(key, "Opened " + node.getLongLabel(), 10);
                        }
                    }
                });
            }

            @Override
            public void nodeWillClose(final NodeEvent e) {
                14.invokeLaterIfNeeded(new Runnable(){

                    @Override
                    public void run() {
                        UpdateMessage mesg = new UpdateMessage(UpdateMessage.OBJECT_CLOSING, null);
                        Node node = e.getNode();
                        node.notifyObservers(node, mesg);
                    }
                });
            }

            @Override
            public void nodeClosed(final NodeEvent e) {
                14.invokeLaterIfNeeded(new Runnable(){

                    @Override
                    public void run() {
                        UpdateMessage.fireObjectClosed(e.getNode());
                    }
                });
            }

            @Override
            public void nodeReverted(final NodeEvent e) {
                14.invokeLaterIfNeeded(new Runnable(){

                    @Override
                    public void run() {
                        UpdateMessage.fireObjectReloaded(e.getNode());
                    }
                });
            }
        });
    }

    private static final class DeleteRenameInterceptor
    extends URLFileSystemHelperDecorator {
        private DeleteRenameInterceptor(URLFileSystemHelper helper) {
            super(helper);
        }

        public void delete(URL url) throws IOException {
            Node node = this.tryGetNode(url);
            if (node != null) {
                node.deleteInternal(this._helper);
            } else {
                super.delete(url);
            }
        }

        public void rename(URL oldURL, URL newURL) throws IOException {
            Node node = this.tryGetNode(oldURL);
            if (node != null) {
                node.renameInternal(newURL, this._helper);
            } else {
                super.rename(oldURL, newURL);
            }
        }

        private Node tryGetNode(URL url) {
            try {
                return NodeFactory.find(url);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private class NodeListenerIterator
    implements Iterator<NodeListener> {
        private NodeListener _curListener;
        private Object[] _curListeners;
        private int _i;
        private int _n;
        private boolean _instanceListRead;
        private boolean _typeListRead;
        private boolean _typeHierarchyListRead;
        private Class _curType;

        private NodeListenerIterator() {
        }

        @Override
        public boolean hasNext() {
            this.tryNext();
            return this._curListener != null;
        }

        @Override
        public NodeListener next() {
            this.tryNext();
            NodeListener listener = this._curListener;
            this._curListener = null;
            return listener;
        }

        private void tryNext() {
            if (this._curListener == null) {
                this._curListener = this.nextImpl();
            }
        }

        private void resetCurListeners(CopyOnWriteArrayList listenerList) {
            if (listenerList != null) {
                this._curListeners = listenerList.toArray();
            }
            this._i = 0;
            this._n = this._curListeners != null ? this._curListeners.length : 0;
        }

        private NodeListener nextListenerImpl() {
            if (this._curListeners != null) {
                if (this._i < this._n) {
                    this._curListener = (NodeListener)this._curListeners[this._i++];
                    return this._curListener;
                }
                this._curListeners = null;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private NodeListener nextImpl() {
            Object next;
            if (!this._instanceListRead) {
                this._instanceListRead = true;
                if (this._curListeners == null) {
                    this.resetCurListeners(Node.this._listeners);
                }
            }
            if ((next = this.nextListenerImpl()) != null) {
                return next;
            }
            if (!this._typeListRead) {
                this._typeListRead = true;
                if (this._curListeners == null) {
                    Class<?> nodeType = Node.this.getClass();
                    HashMap hashMap = _listenersForType;
                    synchronized (hashMap) {
                        Object listenerListObj = _listenersForType.get(nodeType);
                        if (listenerListObj != null) {
                            CopyOnWriteArrayList listenerList = (CopyOnWriteArrayList)listenerListObj;
                            this.resetCurListeners(listenerList);
                        }
                    }
                }
            }
            if ((next = this.nextListenerImpl()) != null) {
                return next;
            }
            if (!this._typeHierarchyListRead) {
                this._typeHierarchyListRead = true;
                this._curType = Node.this.getClass();
            }
            while (this._curType != null) {
                if (this._curListeners == null) {
                    next = _listenersForTypeHierarchy;
                    synchronized (next) {
                        Object listenerListObj = _listenersForTypeHierarchy.get(this._curType);
                        if (listenerListObj != null) {
                            CopyOnWriteArrayList listenerList = (CopyOnWriteArrayList)listenerListObj;
                            this.resetCurListeners(listenerList);
                        }
                    }
                    Class clazz = this._curType = this._curType == Node.class ? null : this._curType.getSuperclass();
                }
                if ((next = this.nextListenerImpl()) == null) continue;
                return next;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static interface NodeEventClosure {
        public void run(NodeListener var1, NodeEvent var2);
    }

    private static final class ThreadUsageTracker
    extends NodeListener {
        private final Thread thread = Thread.currentThread();
        private volatile boolean tracking;
        private Set<Node> loaded;
        private Set<Node> tainted;
        private static final Log LOG = new Log("node-thread-usage");

        private ThreadUsageTracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void begin() {
            ThreadUsageTracker threadUsageTracker = this;
            synchronized (threadUsageTracker) {
                LOG.trace("begin processing cycle");
                if (this.tracking) {
                    throw new IllegalStateException();
                }
                this.loaded = new HashSet<Node>();
                this.tainted = new HashSet<Node>();
                this.tracking = true;
                Node.addNodeListenerForTypeHierarchy(Node.class, this);
            }
        }

        private synchronized void loadInvoked(Node node) {
            boolean added;
            if (this.tracking && this.thread != Thread.currentThread() && (added = this.tainted.add(node))) {
                LOG.trace("node load invoked, tainted: {0}", (Object)node);
            }
        }

        private synchronized void openInvoked(Node node) {
            boolean added;
            if (this.tracking && this.thread != Thread.currentThread() && (added = this.tainted.add(node))) {
                LOG.trace("node open invoked, tainted: {0}", (Object)node);
            }
        }

        @Override
        synchronized void nodeLoaded(NodeEvent e) {
            if (this.tracking) {
                Node node = e.getNode();
                if (this.thread == Thread.currentThread()) {
                    boolean added = this.loaded.add(node);
                    if (added) {
                        LOG.trace("node loaded: {0}", (Object)node);
                    }
                } else {
                    boolean added = this.tainted.add(node);
                    if (added) {
                        LOG.trace("node loaded, tainted: {0}", (Object)node);
                    }
                }
            }
        }

        @Override
        public synchronized void nodeOpened(NodeEvent e) {
            Node node;
            boolean added;
            if (this.tracking && this.thread != Thread.currentThread() && (added = this.tainted.add(node = e.getNode()))) {
                LOG.trace("node opened, tainted: {0}", (Object)node);
            }
        }

        @Override
        final synchronized void nodeUnloaded(NodeEvent e) {
            Node node;
            boolean removed;
            if (this.tracking && (removed = this.loaded.remove(node = e.getNode()) | this.tainted.remove(node))) {
                LOG.trace("node unloaded: {0}", (Object)node);
            }
        }

        private synchronized void nodeChanged(NodeEvent event) {
            Node node;
            boolean added;
            if (this.tracking && this.thread != Thread.currentThread() && (added = this.tainted.add(node = event.getNode()))) {
                LOG.trace("node tainted: {0}", (Object)node);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void end() {
            ArrayList<Node> untainted;
            ThreadUsageTracker threadUsageTracker = this;
            synchronized (threadUsageTracker) {
                if (!this.tracking) {
                    throw new IllegalStateException();
                }
                untainted = new ArrayList<Node>(this.loaded.size());
                for (Node node : this.loaded) {
                    if (this.tainted.contains(node)) continue;
                    untainted.add(node);
                }
                LOG.trace("end processing cycle: {0} untainted of {1} loaded, {2} tainted", untainted.size(), this.loaded.size(), this.tainted.size());
                this.loaded.clear();
                this.tainted.clear();
            }
            for (Node node : untainted) {
                try {
                    this.close(node);
                }
                catch (IOException e) {}
            }
            threadUsageTracker = this;
            synchronized (threadUsageTracker) {
                this.tracking = false;
                Node.removeNodeListenerForTypeHierarchy(Node.class, this);
                this.loaded = null;
                this.tainted = null;
                LOG.trace("end processing cycle completed");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void end(Node node) {
            ThreadUsageTracker threadUsageTracker = this;
            synchronized (threadUsageTracker) {
                LOG.trace("end node usage: {0}", (Object)node);
                if (!this.tracking) {
                    throw new IllegalStateException();
                }
                if (!this.loaded.contains(node) || this.tainted.contains(node)) {
                    return;
                }
            }
            try {
                this.close(node);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void close(Node node) throws IOException {
            ReadWriteLock lock = node.nodeLock();
            if (!lock.tryWriteLock()) {
                return;
            }
            try {
                ThreadUsageTracker threadUsageTracker = this;
                synchronized (threadUsageTracker) {
                    if (this.tainted.contains(node)) {
                        return;
                    }
                }
                node.close();
                return;
            }
            finally {
                node.writeUnlock();
            }
        }

        @Override
        public void nodeDirtyStateChanged(NodeEvent e, boolean isNowDirty) {
            this.nodeChanged(e);
        }

        @Override
        public void nodeWillOpen(NodeEvent e) {
            this.nodeChanged(e);
        }

        @Override
        public void nodeWillClose(NodeEvent e) {
            this.nodeChanged(e);
        }

        @Override
        public void nodeClosed(NodeEvent e) {
            this.nodeChanged(e);
        }

        @Override
        public void nodeWillBeSaved(NodeEvent e) {
            this.nodeChanged(e);
        }

        @Override
        public void nodeSaved(NodeEvent e) {
            this.nodeChanged(e);
        }

        @Override
        public void nodeReverted(NodeEvent e) {
            this.nodeChanged(e);
        }

        @Override
        public void nodeDeleted(NodeEvent e) {
            this.nodeChanged(e);
        }

        @Override
        public void nodeRenamed(NodeEvent e, URL oldURL, URL newURL) {
            this.nodeChanged(e);
        }
    }

    private static enum NodeState {
        CLOSED,
        LOADING,
        UNLOADING,
        LOADED,
        OPENING,
        CLOSING,
        OPEN;

    }
}

