/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.HashMap;
import java.util.Map;
import oracle.ide.model.Element;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

final class FactoryMonitor {
    private static Map _subjectMap = new HashMap();

    FactoryMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void attach(Observer observer, Class clazz) {
        if (clazz == null) {
            return;
        }
        Map map = _subjectMap;
        synchronized (map) {
            Subject subject = (Subject)_subjectMap.get(clazz);
            if (subject == null) {
                subject = new IdeSubject();
                _subjectMap.put(clazz, subject);
            }
            subject.attach(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void detach(Observer observer, Class clazz) {
        Map map = _subjectMap;
        synchronized (map) {
            if (clazz == null) {
                for (Subject subject : _subjectMap.values()) {
                    subject.detach(observer);
                }
            } else {
                Subject subject = (Subject)_subjectMap.get(clazz);
                if (subject != null) {
                    subject.detach(observer);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notify(Element element, int msgID) {
        if (element instanceof Subject) {
            Subject subject = null;
            Map map = _subjectMap;
            synchronized (map) {
                subject = (Subject)_subjectMap.get(element.getClass());
            }
            if (subject != null) {
                boolean quietStart = !(element instanceof Project);
                subject.notifyObservers(element, new UpdateMessage(msgID, null));
            }
        }
    }
}

