/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.migration;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.migration.MigrationPanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.MigratorArb;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.FSMWizardListener;
import oracle.ide.wizard.FinishPanel;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WelcomePanel;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public class MigrationWizard {
    private static final int WIZARD_WELCOME_PAGE = 0;
    private static final int WIZARD_INTRO_PAGE = 1;
    private static final int WIZARD_PAD_PAGE_NO = 2;
    private static final int WIZARD_PAGE_COUNT = 3;
    private static final String HELP_TOPIC_MIGRATE = "f1_migopenwarning_html";
    private static final String HELP_TOPIC_WELCOME = "f1_migwelcome_html";
    private static final String HELP_TOPIC_INTRO = "f1_migconfirmation_html";
    private static final String HELP_TOPIC_SUMMARY = "f1_migfinish_html";
    public static final String USER_CANCELED_MIGRATION = "user-canceled-migration";

    public static boolean runWizard(String title, String welcome, String summary, TraversableContext context, List<Step> pages) {
        if (pages.size() == 0) {
            return MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)welcome, (String)title, (String)HELP_TOPIC_MIGRATE);
        }
        return MigrationWizard.runWizardImpl(title, welcome, summary, context, pages);
    }

    private static boolean runWizardImpl(String title, String welcome, String summary, TraversableContext context, List<Step> steps) {
        int numSteps = steps.size();
        int numPages = numSteps + 3;
        Step[] wizardSteps = new Step[numPages];
        wizardSteps[0] = MigrationWizard.createWelcomePage();
        wizardSteps[1] = MigrationWizard.createIntroPage(welcome);
        for (int i = 0; i < numSteps; ++i) {
            wizardSteps[i + 2] = steps.get(i);
        }
        wizardSteps[numPages - 1] = MigrationWizard.createFinishPage(summary, wizardSteps);
        FSMWizard wiz = new FSMWizard(wizardSteps, (Namespace)context);
        PanelMonitor wizListener = new PanelMonitor();
        wiz.addFSMWizardListener((FSMWizardListener)wizListener);
        context.put("panel-tracker", (Object)wizListener);
        String wzdTitle = MigratorArb.getString(0);
        wiz.setWizardTitle(wzdTitle);
        wiz.setWelcomePageAdded(true);
        wiz.setFinishPageAdded(true);
        wiz.setShowStepNumber(true);
        WizardDialog dialog = wiz.getDialog((Frame)((Object)Ide.getMainWindow()));
        boolean ok = WizardLauncher.runDialog((JDialog)dialog);
        dialog.dispose();
        return ok;
    }

    private static Step createWelcomePage() {
        String wizardTitle = MigratorArb.getString(3);
        String welcomeTitle = MigratorArb.getString(1);
        String welcomeText = MigratorArb.getString(2);
        return WelcomePanel.newStep(wizardTitle, welcomeTitle, welcomeText, MigrationWizard.class.getName(), HELP_TOPIC_WELCOME);
    }

    private static Step createIntroPage(String welcome) {
        return new Step(IntroPanel.class, new Class[]{String.class}, new Object[]{welcome});
    }

    private static Step createFinishPage(String summary, Step[] steps) {
        return new Step(SummaryPanel.class, new Class[]{String.class}, new Object[]{summary});
    }

    private static class ResultCellRenderer
    extends DefaultTreeCellRenderer {
        private JLabel label;

        private ResultCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            this.label = new JLabel(((DefaultMutableTreeNode)value).toString());
            this.label.setOpaque(true);
            if (selected) {
                this.label.setForeground(super.getTextSelectionColor());
                this.label.setBackground(super.getBackgroundSelectionColor());
            } else {
                this.label.setForeground(super.getTextNonSelectionColor());
                this.label.setBackground(super.getBackgroundNonSelectionColor());
            }
            this.label.setIcon(null);
            if (((TreeNode)value).getChildCount() > 0) {
                Font font = c.getFont();
                this.label.setFont(font.deriveFont(1));
            }
            return this.label;
        }
    }

    private static final class SummaryPanel
    extends FinishPanel {
        private final JTree summaryTree = new JTree(new DefaultMutableTreeNode());
        private final JPanel summaryPanel;
        private final JScrollPane treeScroller;

        SummaryPanel(String summaryText) {
            super(MigratorArb.getString(6), MigratorArb.getString(7));
            this.summaryTree.setCellRenderer(new ResultCellRenderer());
            this.treeScroller = new JScrollPane(this.summaryTree);
            this.summaryPanel = new JPanel(new BorderLayout(0, 2));
            if (ModelUtil.hasLength((String)summaryText)) {
                MultiLineLabel label = new MultiLineLabel();
                label.setTextWrapper(WordWrapper.getTextWrapper());
                label.setText(summaryText);
                this.summaryPanel.add((Component)label, "North");
            }
            this.setFinishComponent(this.summaryPanel);
        }

        @Override
        public void onEntry(TraversableContext dataContext) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            PanelMonitor panelMonitor = (PanelMonitor)((Object)dataContext.get("panel-tracker"));
            if (panelMonitor != null) {
                for (Traversable panel : panelMonitor.traversables) {
                    MigrationPanel.ResultData result;
                    if (!(panel instanceof MigrationPanel) || (result = ((MigrationPanel)panel).getResults(dataContext)) == null) continue;
                    String heading = result.getHeading();
                    String text = result.getText();
                    if (!ModelUtil.hasLength((String)heading) || !ModelUtil.hasLength((String)text)) continue;
                    DefaultMutableTreeNode headingNode = new DefaultMutableTreeNode(heading);
                    root.add(headingNode);
                    headingNode.add(new DefaultMutableTreeNode(text));
                }
            }
            ((DefaultTreeModel)this.summaryTree.getModel()).setRoot(root);
            for (int i = 0; i < this.summaryTree.getRowCount(); ++i) {
                this.summaryTree.expandRow(i);
            }
            this.summaryTree.setSelectionRow(0);
            this.summaryTree.setRootVisible(false);
            this.summaryTree.setShowsRootHandles(true);
            if (this.summaryTree.getRowCount() > 1) {
                this.summaryPanel.add((Component)this.treeScroller, "Center");
            } else {
                Component[] components = this.summaryPanel.getComponents();
                for (int i = 0; i < components.length; ++i) {
                    if (components[i] != this.treeScroller) continue;
                    this.summaryPanel.remove(i);
                    break;
                }
            }
            this.setHelpID(MigrationWizard.HELP_TOPIC_SUMMARY);
        }
    }

    private static final class IntroPanel
    extends DefaultTraversablePanel
    implements ItemListener {
        private WizardCallbacks callbacks;
        private final JRadioButton yesOption;
        private final JRadioButton noOption;

        IntroPanel(String introText) {
            this.setDefaultTitle(MigratorArb.getString(4));
            this.setHelpID(MigrationWizard.HELP_TOPIC_INTRO);
            this.setLayout(new GridBagLayout());
            this.yesOption = new JRadioButton();
            this.noOption = new JRadioButton();
            this.yesOption.addItemListener(this);
            this.noOption.addItemListener(this);
            ButtonGroup buttons = new ButtonGroup();
            buttons.add(this.yesOption);
            buttons.add(this.noOption);
            this.yesOption.setSelected(true);
            ResourceUtils.resButton((AbstractButton)this.yesOption, (String)MigratorArb.getString(8));
            ResourceUtils.resButton((AbstractButton)this.noOption, (String)MigratorArb.getString(9));
            GridBagConstraints g = this.gbc(0, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0));
            if (ModelUtil.hasLength((String)introText)) {
                MultiLineLabel label = new MultiLineLabel();
                label.setTextWrapper(WordWrapper.getTextWrapper());
                label.setText(introText);
                this.add((Component)label, g);
            }
            this.add(this.yesOption, g);
            g.weighty += 1.0;
            g.weightx += 1.0;
            this.add(this.noOption, g);
        }

        public void onEntry(TraversableContext dataContext) {
            this.callbacks = dataContext.getWizardCallbacks();
            Boolean bool = (Boolean)dataContext.get(MigrationWizard.USER_CANCELED_MIGRATION);
            boolean userCanceled = bool != null ? bool : false;
            this.noOption.setSelected(userCanceled);
            this.updateButtons();
        }

        public void onExit(TraversableContext dataContext) throws TraversalException {
            this.updateButtons();
            dataContext.put(MigrationWizard.USER_CANCELED_MIGRATION, (Object)this.noOption.isSelected());
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.updateButtons();
        }

        private void updateButtons() {
            if (this.callbacks != null) {
                boolean noSelected = this.noOption.isSelected();
                this.callbacks.wizardEnableButtons(null, noSelected ? Boolean.FALSE : null, noSelected ? Boolean.TRUE : null);
            }
        }
    }

    private static class PanelMonitor
    extends FSMWizardListener {
        private final ArrayList<Traversable> traversables = new ArrayList();

        private PanelMonitor() {
        }

        public void wizardPanelEntered(Traversable traversable, TraversableContext tc) {
            if (!this.traversables.contains(traversable)) {
                this.traversables.add(traversable);
            }
        }
    }
}

