/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.log;

import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.log.BasicLogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogRecognizer;
import oracle.ide.log.LogWindow;
import oracle.javatools.jndi.Names;
import oracle.javatools.util.Pair;

public abstract class LogManager
implements Controller {
    private static final String LOG_MANAGER_NAME = "ide/log-manager";

    public static LogManager getLogManager() {
        LogManager logManager = (LogManager)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)LOG_MANAGER_NAME);
        if (logManager == null) {
            logManager = new BasicLogManager();
            Names.bind((javax.naming.Context)Names.newInitialContext(), (String)LOG_MANAGER_NAME, (Object)logManager);
        }
        return logManager;
    }

    public static void setLogManager(LogManager logManager) {
        LogManager currentLogManager = LogManager.getLogManager();
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)LOG_MANAGER_NAME, (Object)logManager);
        if (currentLogManager != null && logManager != null && currentLogManager != logManager) {
            LogManager.copyContextMenuListeners(currentLogManager, logManager);
        }
    }

    public static LogWindow getIdeLogWindow() {
        LogManager logManager = LogManager.getLogManager();
        return logManager != null ? logManager.getLogWindow() : null;
    }

    public void shutdown() {
    }

    public abstract ContextMenu getContextMenu();

    public abstract void addPage(LogPage var1);

    public abstract void removePage(LogPage var1);

    public abstract int getPageCount();

    public abstract LogPage[] getPages();

    public abstract boolean isLogVisible();

    public abstract void showLog();

    public abstract void hideLog();

    public abstract void toggleLog(Context var1);

    public abstract LogWindow getLogWindow();

    public abstract LogPage getMsgPage();

    public abstract LogPage getSelectedPage();

    public abstract void registerLogRecognizer(LogRecognizer var1);

    public abstract void unregisterLogRecognizer(LogRecognizer var1);

    private static void copyContextMenuListeners(LogManager source, LogManager target) {
        ContextMenu targetCM = target.getContextMenu();
        ContextMenu srcCM = source.getContextMenu();
        for (Pair<Class, ContextMenuListener> pair : srcCM.getContextMenuListeners()) {
            targetCM.addContextMenuListener((ContextMenuListener)pair.getSecond(), (Class)pair.getFirst());
        }
    }
}

