/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.io.IOException;
import java.io.InputStream;
import javax.swing.KeyStroke;
import javax.xml.parsers.SAXParser;
import oracle.ide.keyboard.KeyStroke2String;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.ResKeystrokeContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ResKeystrokeReader
extends DefaultHandler {
    private SAXParser _saxParser;
    private ResKeystrokeContext _currentKeystrokeContext;
    private String _currentPresetName;
    private String _currentActionName;
    private KeyStrokes _currentKeyStrokes;
    private static final int NODE_CONTEXT = 0;
    private static final int NODE_PRESET = 1;
    private static final int NODE_MAP = 2;
    private static final int NODE_ACCEL = 3;

    public ResKeystrokeReader(SAXParser saxParser) {
        this._saxParser = saxParser;
    }

    void read(ResKeystrokeContext context) throws IOException, SAXException {
        this._currentKeystrokeContext = context;
        InputStream inputStream = this._currentKeystrokeContext.getInputStream();
        this._saxParser.parse(inputStream, (DefaultHandler)this);
        inputStream.close();
    }

    private static int getNodeType(String nodeName) {
        if ("accel".equalsIgnoreCase(nodeName)) {
            return 3;
        }
        if ("map".equalsIgnoreCase(nodeName)) {
            return 2;
        }
        if ("preset".equalsIgnoreCase(nodeName)) {
            return 1;
        }
        if ("context".equalsIgnoreCase(nodeName)) {
            return 0;
        }
        return -1;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        int nodeType = ResKeystrokeReader.getNodeType(qName);
        switch (nodeType) {
            case 3: {
                break;
            }
            case 2: {
                this._currentActionName = attributes.getValue("action");
                this._currentKeystrokeContext.addActionName(this._currentActionName);
                this._currentKeyStrokes = new KeyStrokes();
                break;
            }
            case 1: {
                this._currentPresetName = attributes.getValue("name");
                this._currentKeystrokeContext.addPresetName(this._currentPresetName);
                break;
            }
            case 0: {
                String scope = attributes.getValue("scope");
                boolean isGlobal = !"local".equalsIgnoreCase(scope);
                this._currentKeystrokeContext.setGlobal(isGlobal);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        int nodeType = ResKeystrokeReader.getNodeType(qName);
        switch (nodeType) {
            case 3: {
                if (this._currentKeyStrokes.getLength() <= 0) break;
                this._currentKeystrokeContext.addMapping(this._currentPresetName, this._currentActionName, this._currentKeyStrokes);
                break;
            }
            case 2: {
                this._currentActionName = null;
                this._currentKeyStrokes = null;
                break;
            }
            case 1: {
                this._currentPresetName = null;
                break;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this._currentKeyStrokes != null) {
            String accelerator = new String(ch, start, length);
            KeyStroke keyStroke = KeyStroke2String.fromString(accelerator);
            this._currentKeyStrokes.add(keyStroke);
        }
    }
}

