/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.KeyStroke;
import oracle.ide.keyboard.KeyUtil;

public final class KeyStrokes
implements Serializable {
    private ArrayList _ks;

    public KeyStrokes() {
        this(null, null);
    }

    public KeyStrokes(KeyStroke ks1) {
        this(ks1, null);
    }

    public KeyStrokes(KeyStroke ks1, KeyStroke ks2) {
        this._ks = new ArrayList(2);
        if (ks1 != null) {
            this.add(ks1);
            if (ks2 != null) {
                this.add(ks2);
            }
        }
    }

    public KeyStrokes(int modifiers, int keyCode) {
        this(KeyStroke.getKeyStroke(keyCode, modifiers));
    }

    public KeyStrokes(int modifiers, int keyCode1, int keyCode2) {
        this(KeyStroke.getKeyStroke(keyCode1, modifiers), KeyStroke.getKeyStroke(keyCode2, 0));
    }

    public KeyStrokes(KeyStrokes kss) {
        this._ks = (ArrayList)kss._ks.clone();
    }

    public KeyStrokes(KeyStrokes kss, int modifiers, int keyCode) {
        this(kss);
        this.add(KeyStroke.getKeyStroke(keyCode, modifiers));
    }

    public void add(KeyStroke ks) {
        if (ks != null) {
            this._ks.add(ks);
        }
    }

    public void removeLast() {
        int n = this.getLength();
        if (n > 0) {
            this._ks.remove(n - 1);
        }
    }

    public void clear() {
        this._ks.clear();
    }

    public KeyStroke getLast() {
        KeyStroke ks = null;
        int n = this.getLength();
        if (n > 0) {
            ks = this.getKeyStroke(n - 1);
        }
        return ks;
    }

    public int getLength() {
        return this._ks.size();
    }

    public KeyStroke getKeyStroke(int nIndex) {
        return (KeyStroke)this._ks.get(nIndex);
    }

    public boolean isEmpty() {
        return this._ks.isEmpty();
    }

    public boolean startWith(KeyStrokes kss) {
        int n = Math.min(this.getLength(), kss.getLength());
        for (int i = 0; i < n; ++i) {
            if (this._ks.get(i).equals(kss._ks.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        String sSep = null;
        for (int i = 0; i < this.getLength(); ++i) {
            KeyStroke ks = this.getKeyStroke(i);
            if (sSep != null) {
                ret.append(sSep);
            }
            ret.append(KeyUtil.toString(ks));
            sSep = ", ";
        }
        return ret.toString();
    }

    public int hashCode() {
        int nCode = 0;
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            nCode ^= this.getKeyStroke(i).hashCode();
        }
        return nCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof KeyStrokes) {
            KeyStrokes kss = (KeyStrokes)obj;
            int n = this.getLength();
            if (n == kss.getLength()) {
                for (int i = 0; i < n; ++i) {
                    if (this._ks.get(i).equals(kss.getKeyStroke(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public ArrayList getData() {
        return this._ks;
    }

    public void setData(ArrayList ks) {
        this._ks.addAll(ks);
    }

    public boolean isValid() {
        return !this.hasNullElements();
    }

    private boolean hasNullElements() {
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            if (this.getKeyStroke(i) != null) continue;
            return true;
        }
        return false;
    }
}

