/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.ResKeystrokeContext;
import oracle.ide.keyboard.ResKeystrokeReader;
import oracle.ide.keyboard.XMLKeyStrokeContext;
import oracle.ide.keyboard.XMLKeystrokeContextDefs;
import oracle.ide.util.CollectionEvent;
import oracle.ide.util.CollectionListener;
import oracle.javatools.util.ModelUtil;
import org.xml.sax.SAXException;

public final class KeyStrokeContextRegistry {
    private final ArrayList _allContexts = new ArrayList();
    private ArrayList _listeners;
    private ArrayList _resContexts = new ArrayList(50);
    private boolean _acceleratorDefinitionFilesLoaded = false;

    public void addListener(CollectionListener l) {
        if (this._listeners == null) {
            this._listeners = new ArrayList(1);
        }
        this._listeners.add(l);
    }

    public void removeListener(CollectionListener l) {
        this._listeners.remove(l);
    }

    private void fireEvent(int nID, KeyStrokeContext ksc) {
        if (this._listeners != null) {
            CollectionEvent e = null;
            int n = this._listeners.size();
            block4: for (int i = 0; i < n; ++i) {
                CollectionListener l = (CollectionListener)this._listeners.get(i);
                if (e == null) {
                    e = new CollectionEvent(nID, this, ksc);
                }
                switch (nID) {
                    case 1: {
                        l.elementAdded(e);
                        continue block4;
                    }
                    case 2: {
                        l.elementRemoved(e);
                    }
                }
            }
        }
    }

    public void addContext(KeyStrokeContext ksc) {
        if (!this.isContextInAllContextList(ksc)) {
            XMLKeyStrokeContext xmlKeyStrokeContext;
            String filename;
            this._allContexts.add(ksc);
            if (ksc instanceof XMLKeyStrokeContext && (filename = (xmlKeyStrokeContext = (XMLKeyStrokeContext)ksc).getAcceleratorFile()) != null) {
                XMLKeystrokeContextDefs instance = XMLKeystrokeContextDefs.getInstance();
                Class<?> cls = xmlKeyStrokeContext.getClass();
                ClassLoader classLoader = cls.getClassLoader();
                instance.addAcceleratorFile(classLoader, filename);
            }
            this.fireEvent(1, ksc);
        }
    }

    public void removeContext(KeyStrokeContext ksc) {
        if (this._allContexts.contains(ksc)) {
            this._allContexts.remove(ksc);
            this.fireEvent(2, ksc);
        }
    }

    public void addAcceleratorDefinitionFile(ClassLoader classLoader, String fileName) {
        ResKeystrokeContext resKeystrokeContext = new ResKeystrokeContext(classLoader, fileName);
        this._resContexts.add(resKeystrokeContext);
        this.addContext(resKeystrokeContext);
        this._acceleratorDefinitionFilesLoaded = false;
    }

    public void removeAcceleratorDefinitionFile(ClassLoader classLoader, String fileName) {
        for (int i = this._resContexts.size() - 1; i >= 0; --i) {
            ResKeystrokeContext resKeystrokeContext = (ResKeystrokeContext)this._resContexts.get(i);
            if (resKeystrokeContext.getClassLoader() != classLoader || !ModelUtil.areEqual((Object)resKeystrokeContext.getName(), (Object)fileName)) continue;
            ResKeystrokeContext foundContext = (ResKeystrokeContext)this._resContexts.remove(i);
            this.removeContext(foundContext);
            return;
        }
    }

    void loadAcceleratorDefinitionFiles() {
        if (!this._acceleratorDefinitionFilesLoaded) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            try {
                SAXParser saxParser = factory.newSAXParser();
                ResKeystrokeReader resKeystrokeReader = new ResKeystrokeReader(saxParser);
                for (int i = 0; i < this._resContexts.size(); ++i) {
                    ResKeystrokeContext resKeystrokeContext = (ResKeystrokeContext)this._resContexts.get(i);
                    resKeystrokeContext.load(resKeystrokeReader);
                }
                this._acceleratorDefinitionFilesLoaded = true;
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
    }

    public KeyStrokeContext getContext(String sName) {
        int n = this._allContexts.size();
        for (int i = 0; i < n; ++i) {
            KeyStrokeContext ksc = (KeyStrokeContext)this._allContexts.get(i);
            if (!sName.equalsIgnoreCase(ksc.getName())) continue;
            return ksc;
        }
        return null;
    }

    public Iterator getAllContexts() {
        return this._allContexts.iterator();
    }

    public Set getAllPresets() {
        HashSet<String> set = new HashSet<String>();
        int n = this._allContexts.size();
        for (int i = 0; i < n; ++i) {
            KeyStrokeContext ksc = (KeyStrokeContext)this._allContexts.get(i);
            List lKscPresets = ksc.getAllPresets();
            if (lKscPresets == null) continue;
            Iterator j = lKscPresets.iterator();
            while (j.hasNext()) {
                String sPreset = j.next().toString();
                set.add(sPreset);
            }
        }
        return set;
    }

    static Object searchPreset(KeyStrokeContext ksc, String sName) {
        Object ret = null;
        List list = ksc.getAllPresets();
        if (list != null) {
            int n = list.size();
            for (int i = 0; ret == null && i < n; ++i) {
                Object o = list.get(i);
                if (!o.equals(sName)) continue;
                ret = o;
            }
        }
        return ret;
    }

    private boolean isContextInAllContextList(KeyStrokeContext ksc) {
        if (this._allContexts != null) {
            String sKscName = ksc.getName();
            int n = this._allContexts.size();
            for (int i = 0; i < n; ++i) {
                KeyStrokeContext kscList = (KeyStrokeContext)this._allContexts.get(i);
                String sKscListName = kscList.getName();
                if (!sKscName.equals(sKscListName)) continue;
                return true;
            }
        }
        return false;
    }
}

