/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.event.KeyEvent;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;

public final class KeyStroke2String {
    public static Class supportedClass() {
        return KeyStroke.class;
    }

    private static boolean mustCheckSwingParser(int keyCode) {
        if (65 <= keyCode && keyCode <= 90) {
            return false;
        }
        if (48 <= keyCode && keyCode <= 57) {
            return false;
        }
        return 112 > keyCode || keyCode > 123;
    }

    public static String toString(KeyStroke ks) {
        String sKey;
        int keyMod = ks.getModifiers();
        StringBuffer sbModifier = new StringBuffer();
        if (0 != (keyMod & 1)) {
            sbModifier.append("shift ");
        }
        if (0 != (keyMod & 2)) {
            sbModifier.append("control ");
        }
        if (0 != (keyMod & 4)) {
            sbModifier.append("meta ");
        }
        if (0 != (keyMod & 8)) {
            sbModifier.append("alt ");
        }
        boolean bSaveAsInt = false;
        char keyChar = ks.getKeyChar();
        if (keyChar == '\u0000' || keyChar == '\uffff') {
            int keyCode = ks.getKeyCode();
            sKey = KeyEvent.getKeyText(keyCode).toUpperCase();
            if (KeyStroke2String.mustCheckSwingParser(keyCode) && null == KeyStroke.getKeyStroke(sKey)) {
                sKey = Integer.toString(keyCode);
                bSaveAsInt = true;
            }
        } else {
            sKey = Integer.toString(keyChar);
        }
        String s = bSaveAsInt ? sbModifier + "[" + sKey + "]" : sbModifier + sKey;
        return s;
    }

    public static KeyStroke fromString(String s) {
        KeyStroke ks;
        if (s.endsWith("]")) {
            StringTokenizer st = new StringTokenizer(s, " []");
            int mod = 0;
            int key = 0;
            while (st.hasMoreTokens()) {
                String sToken = st.nextToken();
                if (Character.isDigit(sToken.charAt(0))) {
                    key = Integer.parseInt(sToken);
                    continue;
                }
                if (sToken.equals("control")) {
                    mod |= 2;
                    continue;
                }
                if (sToken.equals("alt")) {
                    mod |= 8;
                    continue;
                }
                if (sToken.equals("shift")) {
                    mod |= 1;
                    continue;
                }
                if (!sToken.equals("meta")) continue;
                mod |= 4;
            }
            ks = KeyStroke.getKeyStroke(key, mod);
        } else {
            ks = KeyStroke.getKeyStroke(s);
        }
        return ks;
    }
}

