/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.explorer;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.IconOverlayConsumer;
import oracle.ide.model.Element;

public class IconOverlayTreeCellRenderer
implements TreeCellRenderer {
    private final IconOverlayConsumer _overlayConsumer;
    private final DefaultTreeCellRenderer _renderer;

    public IconOverlayTreeCellRenderer(IconOverlayConsumer consumer, DefaultTreeCellRenderer renderer) {
        this._overlayConsumer = consumer;
        this._renderer = renderer;
    }

    public IconOverlayConsumer getOverlayConsumer() {
        return this._overlayConsumer;
    }

    public DefaultTreeCellRenderer getCellRenderer() {
        return this._renderer;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Element element;
        this._renderer.setText("");
        this._renderer.setToolTipText("");
        this._renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        IconOverlayCache cache = this._overlayConsumer.getOverlayCache();
        if (cache != null && (element = this._overlayConsumer.getElement(value)) != null) {
            Icon icon = this._renderer.getIcon();
            if (icon == null) {
                icon = leaf ? this._renderer.getLeafIcon() : (expanded ? this._renderer.getOpenIcon() : this._renderer.getClosedIcon());
            }
            this._renderer.setIcon(cache.getRendererIcon(element, icon));
            String label = this._renderer.getText();
            this._renderer.setText(cache.getRendererShortLabel(element, label));
            String tooltip = this._renderer.getToolTipText();
            if (tooltip == null || tooltip.equals("")) {
                tooltip = label;
            }
            this._renderer.setToolTipText(cache.getRendererToolTipText(element, tooltip));
        }
        return this._renderer;
    }
}

