/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.explorer;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.IconOverlayConsumer;
import oracle.ide.model.Element;
import oracle.ide.util.Assert;
import oracle.javatools.util.NamedTimer;

public abstract class IconOverlayTracker {
    private static final long THREAD_DELAY_TIME = 500L;
    private final int _overlayBatchSize;
    private final Map<IconOverlayConsumer, NodeWatcher> _nodeWatchers = new HashMap<IconOverlayConsumer, NodeWatcher>();
    private final Map<IconOverlayConsumer, LinkedList> _pendingNodes = new HashMap<IconOverlayConsumer, LinkedList>();
    private final Map<Element, Object> _validOverlayElements = new WeakHashMap<Element, Object>();
    private final Object _timerLock = new Object();
    private Timer _timer;
    private TimerTask _updateTask;
    private IconOverlayCache _overlayCache;
    private ChangeListener _consumerChangeListener;
    private boolean _started;
    private boolean _exited;
    private IdeAdapter _ideListener;
    private final String _infoTypeId;
    private static final ExecutorService _executor = new ThreadPoolExecutor(0, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
        private final ThreadFactory _delegate = Executors.defaultThreadFactory();

        @Override
        public final Thread newThread(Runnable r) {
            Thread t = this._delegate.newThread(r);
            t.setName("IconOverlayTracker Daemon");
            return t;
        }
    });
    private final ChangeListener _viewChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            IconOverlayTracker.this.repaintConsumerOverlays((IconOverlayConsumer)e.getSource(), 500L);
        }
    };

    public IconOverlayTracker(String infoTypeId, IconOverlayCache cache) {
        this(infoTypeId, cache, 10);
    }

    public IconOverlayTracker(String infoTypeId, IconOverlayCache cache, int batchSize) {
        this._infoTypeId = infoTypeId;
        this._overlayCache = cache;
        this._overlayBatchSize = batchSize;
        this._consumerChangeListener = new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void stateChanged(ChangeEvent e) {
                HashSet registrations = new HashSet(IconOverlayTracker.this._overlayCache.getOverlayConsumers());
                HashSet deregistrations = new HashSet();
                Map map = IconOverlayTracker.this._nodeWatchers;
                synchronized (map) {
                    registrations.removeAll(IconOverlayTracker.this._nodeWatchers.keySet());
                    deregistrations.addAll(IconOverlayTracker.this._nodeWatchers.keySet());
                }
                deregistrations.removeAll(IconOverlayTracker.this._overlayCache.getOverlayConsumers());
                Iterator itr = registrations.iterator();
                while (itr.hasNext()) {
                    IconOverlayTracker.this.registerOverlayConsumer((IconOverlayConsumer)itr.next());
                }
                itr = deregistrations.iterator();
                while (itr.hasNext()) {
                    IconOverlayTracker.this.deregisterOverlayConsumer((IconOverlayConsumer)itr.next());
                }
            }
        };
        this._overlayCache.addConsumerChangeListener(this._consumerChangeListener);
        Iterator itr = this._overlayCache.getOverlayConsumers().iterator();
        while (itr.hasNext()) {
            this.registerOverlayConsumer((IconOverlayConsumer)itr.next());
        }
    }

    public IconOverlayCache getOverlayCache() {
        return this._overlayCache;
    }

    protected abstract boolean isControlled(Element var1);

    protected abstract IconOverlay[] getOverlays(Element[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Element[] getValidElements() {
        LinkedHashSet<Element> validElements = new LinkedHashSet<Element>();
        validElements.addAll(Arrays.asList(this._overlayCache.getElementKeys(this._infoTypeId)));
        Map<Element, Object> map = this._validOverlayElements;
        synchronized (map) {
            validElements.addAll(this._validOverlayElements.keySet());
        }
        return validElements.toArray(new Element[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerOverlayConsumer(IconOverlayConsumer consumer) {
        this.startTracking();
        Map<IconOverlayConsumer, Object> map = this._nodeWatchers;
        synchronized (map) {
            if (this._nodeWatchers.containsKey(consumer)) {
                return;
            }
            NodeWatcher watcher = new NodeWatcher(consumer);
            watcher.addVisibleNodeListener(this._viewChangeListener);
            this._nodeWatchers.put(consumer, watcher);
        }
        map = this._pendingNodes;
        synchronized (map) {
            this._pendingNodes.put(consumer, null);
        }
        this.repaintConsumerOverlays(consumer, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterOverlayConsumer(IconOverlayConsumer consumer) {
        this.startTracking();
        Map<IconOverlayConsumer, Object> map = this._nodeWatchers;
        synchronized (map) {
            if (!this._nodeWatchers.containsKey(consumer)) {
                return;
            }
            NodeWatcher watcher = this._nodeWatchers.get(consumer);
            watcher.removeVisibleNodeListener(this._viewChangeListener);
            this._nodeWatchers.remove(consumer);
            watcher.performCleanup();
        }
        map = this._pendingNodes;
        synchronized (map) {
            this._pendingNodes.remove(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateOverlay(Element e) {
        this.startTracking();
        Map<Element, Object> map = this._validOverlayElements;
        synchronized (map) {
            this._validOverlayElements.remove(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateOverlays() {
        this.startTracking();
        Map<Element, Object> map = this._validOverlayElements;
        synchronized (map) {
            for (Element e : this.getValidElements()) {
                this._validOverlayElements.remove(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaintOverlays() {
        HashSet<IconOverlayConsumer> c;
        this.startTracking();
        Map<IconOverlayConsumer, NodeWatcher> map = this._nodeWatchers;
        synchronized (map) {
            c = new HashSet<IconOverlayConsumer>(this._nodeWatchers.keySet());
        }
        this.repaintConsumerOverlays(c, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTracking() {
        if (!this._started) {
            return;
        }
        Ide.removeIdeListener(this._ideListener);
        this._overlayCache.removeConsumerChangeListener(this._consumerChangeListener);
        this._ideListener = null;
        Object object = this._timerLock;
        synchronized (object) {
            if (this._exited) {
                return;
            }
            this._exited = true;
        }
        TimerTask task = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IconOverlayTracker.this.cleanUpNodeWatchers();
                Object object = IconOverlayTracker.this._timerLock;
                synchronized (object) {
                    IconOverlayTracker.this.getTimer().cancel();
                }
                this.timerStopped();
            }

            private void timerStopped() {
                IconOverlayTracker.this.validateOverlays();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        IconOverlayCache cache = IconOverlayTracker.this.getOverlayCache();
                        if (cache == null) {
                            return;
                        }
                        cache.clearOverlays(IconOverlayTracker.this._infoTypeId);
                        cache.fireOverlaysChanged();
                    }
                });
            }
        };
        Object object2 = this._timerLock;
        synchronized (object2) {
            if (this._timer == null) {
                this.cleanUpNodeWatchers();
                return;
            }
            this.getTimer().schedule(task, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanUpNodeWatchers() {
        Map<IconOverlayConsumer, NodeWatcher> map = this._nodeWatchers;
        synchronized (map) {
            for (NodeWatcher watcher : this._nodeWatchers.values()) {
                watcher.removeVisibleNodeListener(this._viewChangeListener);
                watcher.performCleanup();
            }
        }
    }

    protected void startTracking() {
        if (this._started) {
            return;
        }
        this._started = true;
        this._ideListener = new IdeAdapter(){

            @Override
            public void mainWindowClosing(IdeEvent e) {
                IconOverlayTracker.this.stopTracking();
                Ide.removeIdeListener(this);
            }
        };
        Ide.addIdeListener(this._ideListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repaintConsumerOverlays(Collection<IconOverlayConsumer> consumers, long delay) {
        Map<IconOverlayConsumer, LinkedList> map = this._pendingNodes;
        synchronized (map) {
            Iterator<IconOverlayConsumer> itr = consumers.iterator();
            while (itr.hasNext()) {
                this.repaintConsumerOverlaysImpl(itr.next());
            }
        }
        this.scheduleUpdateTask(delay, consumers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repaintConsumerOverlays(IconOverlayConsumer consumer, long delay) {
        Map<IconOverlayConsumer, LinkedList> map = this._pendingNodes;
        synchronized (map) {
            this.repaintConsumerOverlaysImpl(consumer);
        }
        this.scheduleUpdateTask(delay, Collections.singleton(consumer));
    }

    private void repaintConsumerOverlaysImpl(IconOverlayConsumer consumer) {
        if (!this._pendingNodes.containsKey(consumer)) {
            return;
        }
        this._pendingNodes.put(consumer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUpdateTask(final long delay, final Collection<IconOverlayConsumer> consumers) {
        Object object = this._timerLock;
        synchronized (object) {
            if (this._timer != null) {
                this._scheduleUpdateTask(delay, consumers);
                return;
            }
        }
        object = _executor;
        synchronized (object) {
            _executor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public final void run() {
                    Object object = IconOverlayTracker.this._timerLock;
                    synchronized (object) {
                        IconOverlayTracker.this._scheduleUpdateTask(delay, consumers);
                    }
                }
            });
        }
    }

    private final void _scheduleUpdateTask(long delay, Collection<IconOverlayConsumer> consumers) {
        if (this._exited) {
            return;
        }
        if (this._timer == null && !this.isVisibleNodeControlled(consumers)) {
            return;
        }
        if (this._updateTask != null) {
            this._updateTask.cancel();
        }
        this._updateTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    IconOverlayTracker.this.processPendingNodes();
                }
                catch (RuntimeException re) {
                    re.printStackTrace();
                }
            }
        };
        try {
            this.getTimer().schedule(this._updateTask, delay);
        }
        catch (IllegalStateException ise) {
            Assert.printStackTrace((Throwable)ise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isVisibleNodeControlled(Collection<IconOverlayConsumer> consumers) {
        for (IconOverlayConsumer consumer : consumers) {
            Collection visible;
            Map<IconOverlayConsumer, NodeWatcher> map = this._nodeWatchers;
            synchronized (map) {
                NodeWatcher watcher = this._nodeWatchers.get(consumer);
                if (watcher == null) {
                    continue;
                }
                visible = watcher.getVisibleNodes();
            }
            Iterator itr = visible.iterator();
            while (itr.hasNext()) {
                Element e = consumer.getElement(itr.next());
                if (e == null || !this.isControlled(e)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timer getTimer() {
        Object object = this._timerLock;
        synchronized (object) {
            if (this._timer == null) {
                this._timer = new NamedTimer("IconOverlayTracker Timer");
            }
        }
        return this._timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingNodes() {
        Collection pendingNodeBatch;
        while ((pendingNodeBatch = this.getPendingNodeBatch()) != null) {
            final ArrayList nodes = new ArrayList(pendingNodeBatch);
            Map<Element, Object> map = this._validOverlayElements;
            synchronized (map) {
                for (Element e : nodes) {
                    this._validOverlayElements.put(e, null);
                }
            }
            BitSet controlled = new BitSet(nodes.size());
            ArrayList<Element> controlledNodes = new ArrayList<Element>();
            for (int i = 0; i < nodes.size(); ++i) {
                Element e = (Element)nodes.get(i);
                if (!this.isControlled(e)) continue;
                controlled.set(i);
                controlledNodes.add(e);
            }
            final ArrayList overlays = new ArrayList(nodes.size());
            List<IconOverlay> controlledOverlays = Arrays.asList(this.getOverlays(controlledNodes.toArray(new Element[0])));
            Iterator itr = controlledOverlays.iterator();
            for (int i = 0; i < nodes.size(); ++i) {
                if (controlled.get(i)) {
                    overlays.add(itr.next());
                    continue;
                }
                overlays.add(null);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public final void run() {
                    IconOverlayCache cache = IconOverlayTracker.this.getOverlayCache();
                    if (cache == null) {
                        return;
                    }
                    Iterator itr = nodes.iterator();
                    Iterator itr2 = overlays.iterator();
                    while (itr.hasNext()) {
                        Element e = (Element)itr.next();
                        IconOverlay overlay = (IconOverlay)itr2.next();
                        if (e == null) continue;
                        if (overlay == null) {
                            cache.removeOverlay(IconOverlayTracker.this._infoTypeId, e);
                            continue;
                        }
                        cache.putOverlay(IconOverlayTracker.this._infoTypeId, e, overlay);
                    }
                    cache.fireOverlaysChanged();
                }
            });
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getPendingNodeBatch() {
        IconOverlayConsumer _consumer;
        while ((_consumer = this.findPendingConsumer()) != null) {
            Map<IconOverlayConsumer, LinkedList> map = this._pendingNodes;
            synchronized (map) {
                List queue = this._pendingNodes.get(_consumer);
                if (queue != null) {
                    int n = Math.min(queue.size(), this._overlayBatchSize);
                    ArrayList nodes = new ArrayList(n);
                    for (int i = 0; i < n; ++i) {
                        nodes.add(queue.remove(0));
                    }
                    return nodes;
                }
            }
            this.updateQueue(_consumer);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IconOverlayConsumer findPendingConsumer() {
        Map<IconOverlayConsumer, LinkedList> map = this._pendingNodes;
        synchronized (map) {
            for (IconOverlayConsumer o : this._pendingNodes.keySet()) {
                List queue = this._pendingNodes.get(o);
                if (queue != null && queue.size() <= 0) continue;
                return o;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateQueue(IconOverlayConsumer consumer) {
        Collection visible;
        Map<IconOverlayConsumer, Object> map = this._nodeWatchers;
        synchronized (map) {
            if (!this._nodeWatchers.containsKey(consumer)) {
                return;
            }
            NodeWatcher watcher = this._nodeWatchers.get(consumer);
            visible = watcher.getVisibleNodes();
        }
        LinkedList<Element> queue = new LinkedList<Element>();
        Iterator itr = visible.iterator();
        while (itr.hasNext()) {
            Element e = consumer.getElement(itr.next());
            if (e == null) continue;
            Map<Element, Object> map2 = this._validOverlayElements;
            synchronized (map2) {
                if (this._validOverlayElements.containsKey(e)) {
                    continue;
                }
            }
            queue.add(e);
        }
        map = this._pendingNodes;
        synchronized (map) {
            if (!this._pendingNodes.containsKey(consumer)) {
                return;
            }
            this._pendingNodes.put(consumer, queue);
        }
    }

    private final class NodeWatcher {
        private final JTree _tree;
        private final Object _source;
        private final ChangeListener _scrollListener = new ScrollPaneListener();
        private final TreeModelListener _modelListener = new NodeModelListener();
        private final TreeExpansionListener _nodeListener = new NodeUserListener();
        private final ParentListener _parentListener = new ParentListener();
        private Collection _nodes = new ArrayList();
        private Collection _listeners = new ArrayList();
        private boolean _cleanup;

        private NodeWatcher(IconOverlayConsumer consumer) {
            this._tree = consumer.getJTree();
            this._source = consumer;
            this._tree.addAncestorListener(this._parentListener);
            if (this.isComponentVisible(this._tree)) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        NodeWatcher.this.addInternalListeners();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addVisibleNodeListener(ChangeListener l) {
            Collection collection = this._listeners;
            synchronized (collection) {
                this._listeners.remove(l);
                this._listeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeVisibleNodeListener(ChangeListener l) {
            Collection collection = this._listeners;
            synchronized (collection) {
                this._listeners.remove(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection getVisibleNodes() {
            Collection collection = this._nodes;
            synchronized (collection) {
                return new ArrayList(this._nodes);
            }
        }

        private void performCleanup() {
            this._cleanup = true;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public final void run() {
                    NodeWatcher.this._tree.removeAncestorListener(NodeWatcher.this._parentListener);
                    NodeWatcher.this.removeInternalListeners();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void updateVisibleNodes() {
            if (!IconOverlayTracker.this._started) {
                return;
            }
            Object object = IconOverlayTracker.this._timerLock;
            synchronized (object) {
                if (IconOverlayTracker.this._exited) {
                    return;
                }
                this._updateVisibleNodes();
                if (IconOverlayTracker.this._timer != null) {
                    IconOverlayTracker.this.getTimer().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            NodeWatcher.this._updateVisibleNodes();
                        }
                    }, 500L);
                }
            }
        }

        private final void _updateVisibleNodes() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public final void run() {
                    NodeWatcher.this.setVisibleNodes(IconOverlayCache.getVisibleNodes(NodeWatcher.this._tree));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void setVisibleNodes(Collection c) {
            Collection collection = this._nodes;
            synchronized (collection) {
                boolean changed = !Arrays.equals(this._nodes.toArray(), c.toArray());
                this._nodes = c;
                if (!changed) {
                    return;
                }
            }
            ChangeEvent e = new ChangeEvent(this._source);
            ChangeListener[] l = null;
            Collection collection2 = this._listeners;
            synchronized (collection2) {
                l = this._listeners.toArray(new ChangeListener[0]);
            }
            for (int i = l.length - 1; i >= 0; --i) {
                l[i].stateChanged(e);
            }
        }

        private final void addInternalListeners() {
            if (this._cleanup) {
                return;
            }
            this.removeInternalListenersImpl();
            this.addInternalListenersImpl();
            this.updateVisibleNodes();
        }

        private final void removeInternalListeners() {
            this.removeInternalListenersImpl();
            this.setVisibleNodes(new ArrayList());
        }

        private final void addInternalListenersImpl() {
            this._tree.getModel().addTreeModelListener(this._modelListener);
            this._tree.addTreeExpansionListener(this._nodeListener);
            if (!(this._tree.getParent() instanceof JViewport)) {
                return;
            }
            JViewport viewport = (JViewport)this._tree.getParent();
            viewport.addChangeListener(this._scrollListener);
        }

        private final void removeInternalListenersImpl() {
            if (this._tree.getModel() != null) {
                this._tree.getModel().removeTreeModelListener(this._modelListener);
            }
            this._tree.removeTreeExpansionListener(this._nodeListener);
            if (!(this._tree.getParent() instanceof JViewport)) {
                return;
            }
            JViewport viewport = (JViewport)this._tree.getParent();
            viewport.removeChangeListener(this._scrollListener);
        }

        private final JTree getTree() {
            return this._tree;
        }

        private final boolean isComponentVisible(Component c) {
            while (c != null) {
                if (!c.isVisible()) {
                    return false;
                }
                if (c instanceof Window) {
                    return true;
                }
                c = c.getParent();
            }
            return false;
        }

        private final class NodeUserListener
        implements TreeExpansionListener {
            private NodeUserListener() {
            }

            @Override
            public final void treeCollapsed(TreeExpansionEvent event) {
                NodeWatcher.this.updateVisibleNodes();
            }

            @Override
            public final void treeExpanded(TreeExpansionEvent event) {
                NodeWatcher.this.updateVisibleNodes();
            }
        }

        private final class NodeModelListener
        implements TreeModelListener {
            private NodeModelListener() {
            }

            @Override
            public final void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public final void treeNodesInserted(TreeModelEvent e) {
                NodeWatcher.this.updateVisibleNodes();
            }

            @Override
            public final void treeNodesRemoved(TreeModelEvent e) {
                NodeWatcher.this.updateVisibleNodes();
            }

            @Override
            public final void treeStructureChanged(TreeModelEvent e) {
                NodeWatcher.this.updateVisibleNodes();
            }
        }

        private final class ScrollPaneListener
        implements ChangeListener {
            private Rectangle _r = null;

            private ScrollPaneListener() {
            }

            @Override
            public final void stateChanged(ChangeEvent e) {
                Rectangle r = NodeWatcher.this.getTree().getVisibleRect();
                if (this._r != null && r.equals(this._r)) {
                    return;
                }
                this._r = r;
                NodeWatcher.this.updateVisibleNodes();
            }
        }

        private final class ParentListener
        implements AncestorListener {
            private ParentListener() {
            }

            @Override
            public final void ancestorAdded(AncestorEvent e) {
                NodeWatcher.this.removeInternalListeners();
                NodeWatcher.this.addInternalListeners();
            }

            @Override
            public final void ancestorMoved(AncestorEvent e) {
            }

            @Override
            public final void ancestorRemoved(AncestorEvent e) {
                NodeWatcher.this.removeInternalListeners();
            }
        }
    }
}

