/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;

public class ToolButtonUI
extends BasicButtonUI {
    private static final ToolButtonUI toolButtonUI = new ToolButtonUI();
    static final Icon popupIndicator = MenuToolButton.POPUP_ICON;
    static final int POPUP_WIDTH = 14;
    static final String propertyPrefix = "ToolButton.";
    private boolean inPaintIcon;

    public static ComponentUI createUI(JComponent c) {
        return toolButtonUI;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        ToolButton b = (ToolButton)c;
        Dimension size = ToolButtonUI.getToolbarButtonPreferredSize(b, this.defaultTextIconGap);
        if (b.hasPopup()) {
            size.width = b.isMenuStyle() ? (size.width += popupIndicator.getIconWidth() + 1) : (size.width += 14);
        }
        return size;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        ToolButton b = (ToolButton)c;
        super.paint(g, c);
        if (b.hasPopup()) {
            int x;
            int off;
            if (b.isMenuStyle()) {
                off = this.getTextShiftOffset();
                x = b.getWidth() - popupIndicator.getIconWidth() - 3 + off;
            } else {
                off = b.isPopupVisible() ? this.defaultTextShiftOffset : this.getTextShiftOffset();
                x = b.getWidth() - (14 + popupIndicator.getIconWidth() + 2) / 2 + off;
            }
            int y = (b.getHeight() - popupIndicator.getIconHeight()) / 2 + off;
            popupIndicator.paintIcon(b, g, x, y);
        }
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new ToolButtonListener(b);
    }

    @Override
    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        this.setTextShiftOffset();
    }

    @Override
    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        ToolButton b = (ToolButton)c;
        iconRect.x += ToolButtonUI.getPopupXShift(b);
        this.inPaintIcon = true;
        super.paintIcon(g, c, iconRect);
        this.inPaintIcon = false;
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        ToolButton b = (ToolButton)c;
        textRect.x += ToolButtonUI.getPopupXShift(b);
        super.paintText(g, c, textRect, text);
    }

    @Override
    protected void clearTextShiftOffset() {
        if (!this.inPaintIcon) {
            super.clearTextShiftOffset();
        }
    }

    protected static Dimension getToolbarButtonPreferredSize(AbstractButton b, int textIconGap) {
        Dimension size = BasicGraphicsUtils.getPreferredButtonSize(b, textIconGap);
        Container parent = b.getParent();
        if (parent != null) {
            Insets ins = parent.getInsets();
            int height = parent.getHeight() - (ins.top + ins.bottom);
            if (size.height < height) {
                size.height = height;
            }
        }
        if (size.width != size.height) {
            size.width = size.height = Math.max(size.width, size.height);
        }
        return size;
    }

    private static int getPopupXShift(ToolButton b) {
        if (b.hasPopup()) {
            if (b.isMenuStyle()) {
                return -popupIndicator.getIconWidth() / 2 - 1;
            }
            return -7;
        }
        return 0;
    }

    private final class ToolButtonListener
    extends BasicButtonListener {
        private ToolButtonListener(AbstractButton b) {
            super(b);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ToolButton b = (ToolButton)e.getComponent();
            Toolbar t = b.getToolbar();
            if (t != null) {
                ToolButton over = t.getOver();
                if (over != null && over.isPopupVisible()) {
                    over.togglePopup();
                    if (b != over) {
                        over.getModel().setRollover(false);
                        t.setOver(null);
                        this.mouseEntered(e);
                    }
                    return;
                }
                t.setTrack(b);
            }
            ButtonModel bm = b.getModel();
            if (SwingUtilities.isLeftMouseButton(e) && b.hasPopup() && bm.isEnabled() && (b.isMenuStyle() || e.getX() > b.getWidth() - 14)) {
                b.togglePopup();
            } else {
                super.mousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ToolButton b = (ToolButton)e.getComponent();
            Toolbar t = b.getToolbar();
            if (t != null) {
                t.setTrack(null);
            }
            if (!b.isMenuStyle()) {
                super.mouseReleased(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ToolButton b = (ToolButton)e.getComponent();
            Toolbar t = b.getToolbar();
            if (t != null && t.getOver() == null) {
                t.setOver(b);
                ToolButton track = t.getTrack();
                if (track == null || b == track) {
                    super.mouseEntered(e);
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ToolButton over;
            ToolButton b = (ToolButton)e.getComponent();
            Toolbar t = b.getToolbar();
            if (t != null && (over = t.getOver()) != null && !over.isPopupVisible()) {
                t.setOver(null);
                ToolButton track = t.getTrack();
                if (track == null || b == track) {
                    super.mouseExited(e);
                }
            }
        }
    }
}

