/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import oracle.ide.controls.ToggleAction;
import oracle.ide.nulls.NullIcon;
import oracle.javatools.controls.PropertyChangeAdapter;
import oracle.javatools.util.PlatformUtils;

public class MenuItem
extends JMenuItem {
    private boolean checkedForIcon;
    private boolean checkedForDisabledIcon;
    public static final MenuElement[] EMPTY_MENU_ELEMENTS = new MenuElement[0];

    public MenuItem(ToggleAction action) {
        super(action);
    }

    @Override
    protected void configurePropertiesFromAction(Action a) {
        Integer i;
        this.checkedForIcon = false;
        this.checkedForDisabledIcon = false;
        this.setText(a != null ? (String)a.getValue("Name") : null);
        this.setEnabled(a != null ? a.isEnabled() : true);
        Integer n = i = a != null ? (Integer)a.getValue("MnemonicKey") : null;
        if (i != null) {
            int vk = i;
            if (vk >= 97 && vk <= 122) {
                vk -= 32;
            }
            this.setMnemonic(vk);
        }
    }

    @Override
    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return new PropertyChangeAdapter((AbstractButton)this, a);
    }

    @Override
    public Icon getIcon() {
        if (!this.checkedForIcon) {
            Action a = this.getAction();
            Icon icon = null;
            if (a != null) {
                this.checkedForIcon = true;
                icon = (Icon)a.getValue("SmallIcon");
                if (icon == null && PlatformUtils.isMac() && this.getParent() instanceof JPopupMenu && ((JPopupMenu)this.getParent()).getInvoker() instanceof JMenu) {
                    icon = new NullIcon();
                }
                this.setIcon(icon);
            }
        }
        return super.getIcon();
    }

    @Override
    public void setIcon(Icon icon) {
        this.checkedForIcon = true;
        super.setIcon(icon);
    }

    @Override
    public void setPressedIcon(Icon icon) {
        if (!this.checkedForIcon) {
            this.getIcon();
        }
        super.setPressedIcon(icon);
    }

    @Override
    public Icon getDisabledIcon() {
        Action a;
        if (!this.checkedForIcon) {
            this.getIcon();
        }
        if (!this.checkedForDisabledIcon && (a = this.getAction()) != null) {
            this.checkedForDisabledIcon = true;
            this.setDisabledIcon((Icon)a.getValue("DisabledIcon"));
        }
        return super.getDisabledIcon();
    }

    @Override
    public void setDisabledIcon(Icon icon) {
        this.checkedForDisabledIcon = true;
        super.setDisabledIcon(icon);
    }

    @Override
    public MenuElement[] getSubElements() {
        return EMPTY_MENU_ELEMENTS;
    }
}

