/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class JAutoScrollPane
extends JScrollPane {
    private boolean disableAutoScroll;

    public JAutoScrollPane() {
        this(null);
    }

    public JAutoScrollPane(Component c) {
        this(c, 20, 30);
    }

    public JAutoScrollPane(int vsbPolicy, int hsbPolicy) {
        this(null, vsbPolicy, hsbPolicy);
    }

    public JAutoScrollPane(Component c, int vsbPolicy, int hsbPolicy) {
        super(c, vsbPolicy, hsbPolicy);
        this.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent event) {
                JScrollBar vbar = (JScrollBar)event.getSource();
                if (!event.getValueIsAdjusting()) {
                    return;
                }
                if (vbar.getValue() + vbar.getVisibleAmount() == vbar.getMaximum()) {
                    JAutoScrollPane.this.disableAutoScroll = false;
                } else if (!JAutoScrollPane.this.disableAutoScroll) {
                    JAutoScrollPane.this.disableAutoScroll = true;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAutoScrollDisabled() {
        JAutoScrollPane jAutoScrollPane = this;
        synchronized (jAutoScrollPane) {
            return this.disableAutoScroll;
        }
    }
}

