/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.image.LookupTable;
import java.util.ArrayList;

class InterceptLookupTable
extends LookupTable {
    private ArrayList _intercept = new ArrayList(3);

    public InterceptLookupTable() {
        super(0, 4);
    }

    public void add(int[] src, int[] dest) {
        int[][] pair = new int[][]{src, dest};
        this._intercept.add(pair);
    }

    @Override
    public int[] lookupPixel(int[] src, int[] dest) {
        if (dest == null) {
            dest = new int[src.length];
        }
        for (int i = 0; i < this._intercept.size(); ++i) {
            int[][] pair = (int[][])this._intercept.get(i);
            int[] interceptSrc = pair[0];
            boolean allMatch = true;
            for (int j = 0; allMatch && j < src.length; ++j) {
                if (src[j] == interceptSrc[j]) continue;
                allMatch = false;
            }
            if (!allMatch) continue;
            int[] newColor = pair[1];
            int newColorLength = newColor.length;
            System.arraycopy(newColor, 0, dest, 0, newColorLength);
            return dest;
        }
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }
}

