/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import javax.accessibility.AccessibleContext;
import javax.swing.JLabel;
import javax.swing.JTable;
import oracle.javatools.clipboard.ClipboardStack;

public class CopyableJTableAdapter {
    private final JTable _table;
    private String _nullValue = "(null)";

    public CopyableJTableAdapter(JTable table) {
        this._table = table;
    }

    public void setNullString(String s) {
        this._nullValue = s;
    }

    public String getNullString() {
        return this._nullValue;
    }

    public boolean canCopy() {
        return CopyableJTableAdapter.isSelectionSizeOk(this._table.getSelectedRowCount(), this._table.getSelectedRows()) && (this._table.getRowSelectionAllowed() || CopyableJTableAdapter.isSelectionSizeOk(this._table.getSelectedColumnCount(), this._table.getSelectedColumns()));
    }

    public boolean copyToClipboard() {
        int numRows = this._table.getSelectedRowCount();
        int[] rows = this._table.getSelectedRows();
        int numCols = 0;
        int[] cols = null;
        if (this._table.getRowSelectionAllowed()) {
            numCols = this._table.getColumnCount();
            cols = CopyableJTableAdapter._getColumnList(this._table);
        } else {
            numCols = this._table.getSelectedColumnCount();
            cols = this._table.getSelectedColumns();
        }
        StringBuffer sbf = new StringBuffer(numRows * numCols * 10);
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                String s;
                Object o = this._table.getValueAt(rows[i], cols[j]);
                if (o instanceof JLabel) {
                    AccessibleContext actx;
                    JLabel lbl = (JLabel)o;
                    s = lbl.getText();
                    if (!(s != null && s.length() != 0 || (s = (actx = lbl.getAccessibleContext()).getAccessibleName()) != null && s.length() != 0)) {
                        s = actx.getAccessibleDescription();
                    }
                } else {
                    s = o != null ? o.toString() : this._nullValue;
                }
                sbf.append(s);
                if (j >= numCols - 1) continue;
                sbf.append("\t");
            }
            sbf.append("\n");
        }
        StringSelection stsel = new StringSelection(sbf.toString());
        Clipboard system = Toolkit.getDefaultToolkit().getSystemClipboard();
        ClipboardStack.pushCurrentClipboard();
        system.setContents(stsel, stsel);
        return true;
    }

    public static boolean isSelectionSizeOk(int num, int[] rows) {
        if (rows == null || rows.length == 0) {
            return false;
        }
        int rowSize = rows[rows.length - 1] - rows[0];
        return num - 1 == rowSize && num == rows.length;
    }

    private static int[] _getColumnList(JTable tbl) {
        if (tbl == null) {
            return new int[0];
        }
        int size = tbl.getColumnCount();
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = i;
        }
        return result;
    }
}

