/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ide.menu.ActionRegistry;
import javax.ide.menu.ItemFactory;
import javax.ide.menu.spi.Item;
import javax.ide.menu.spi.MenuHook;
import javax.ide.menu.spi.Section;
import javax.ide.view.GUIPanel;
import javax.naming.Context;
import javax.swing.ButtonGroup;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.ActionFilter;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;
import oracle.ideimpl.extension.MenuCustomizationHook;
import oracle.javatools.jndi.Names;

public abstract class ToolbarManager
implements Addin {
    private static final String TOOLBAR_MGR_NAME = "ide/toolbar-manager";
    private ActionFilter _actionFilter;

    public static ToolbarManager getToolbarManager() {
        return (ToolbarManager)Names.lookup((Context)Names.newInitialContext(), (String)TOOLBAR_MGR_NAME);
    }

    public static void setToolbarManager(ToolbarManager manager) {
        Names.bind((Context)Names.newInitialContext(), (String)TOOLBAR_MGR_NAME, (Object)manager);
    }

    public void installToolbar(String toolbarId, Toolbar toolbar, View view) {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        MenuHook mh = (MenuHook)er.getHook(MenuHook.ELEMENT);
        toolbar.addToolbarFilter(this.getActionFilter());
        Collection itemFactories = mh.getModel().getItemFactories();
        javax.ide.menu.spi.Toolbar modelToolbar = (javax.ide.menu.spi.Toolbar)mh.getModel().getToolbars().get(toolbarId);
        if (modelToolbar == null) {
            return;
        }
        List sections = modelToolbar.getSections();
        boolean needSeparator = false;
        HashMap buttonGroupMap = new HashMap();
        Iterator i = sections.iterator();
        while (i.hasNext()) {
            if (needSeparator) {
                toolbar.addSeparator();
            }
            Section section = (Section)i.next();
            List items = section.getContent();
            for (Item item : items) {
                String cmdID = item.getActionID();
                this.addToolbarItem(itemFactories, toolbarId, section.getID(), view, toolbar, cmdID, buttonGroupMap);
            }
            needSeparator = true;
        }
    }

    protected abstract IdeAction getAction(String var1);

    private Component getCustomComponent(Collection itemFactories, String path) {
        for (ItemFactory factory : itemFactories) {
            GUIPanel component = factory.createItem(path);
            if (component == null) continue;
            return (Component)component.getRootComponent();
        }
        return null;
    }

    private void addToolbarItem(Collection itemFactories, String toolbarId, String sectionId, View view, Toolbar toolbar, String cmdId, Map buttonGroupMap) {
        Component c;
        if (!this.getActionFilter().accept(cmdId)) {
            return;
        }
        String cmd = AddinManager.getAddinManager().getCommand(cmdId, "");
        IdeAction action = null;
        ToggleAction[] actionGroup = null;
        Integer cmdIntegerID = Ide.findCmdID(cmdId);
        if (cmdIntegerID != null) {
            action = this.getAction(cmdId);
        }
        if ((c = this.getCustomComponent(itemFactories, toolbarId + '/' + sectionId + '/' + cmdId)) != null) {
            toolbar.add(c);
            return;
        }
        if (action == null) {
            actionGroup = IdeAction.findGroup(cmdId);
            if (actionGroup == null) {
                ExtensionRegistry.getExtensionRegistry().getLogger().warning("action-ref '" + cmdId + "' not found in section '" + sectionId + "' on toolbar '" + toolbarId + "'.");
            }
        } else if (cmd.length() != 0) {
            action.setCommand(cmd);
        }
        if (actionGroup != null) {
            if (view != null) {
                for (int j = 0; j < actionGroup.length; ++j) {
                    ToggleAction oldAction = actionGroup[j];
                    IdeAction newAction = ((IdeAction)oldAction).newLocalAction(view);
                    actionGroup[j] = newAction;
                }
            }
            toolbar.addMenuButton(actionGroup);
        } else if (action != null) {
            if (view != null) {
                action = action.newLocalAction(view);
            }
            if (action.isToggle()) {
                toolbar.addToggleButton(action);
            } else if (action.isRadio()) {
                ButtonGroup buttonGroup;
                String btnGroupName = (String)action.getValue("RadioGroupName");
                if (btnGroupName == null) {
                    btnGroupName = "UnknownButtonGroup";
                }
                if ((buttonGroup = (ButtonGroup)buttonGroupMap.get(btnGroupName)) == null) {
                    buttonGroup = new ButtonGroup();
                    buttonGroupMap.put(btnGroupName, buttonGroup);
                }
                toolbar.addRadioButton(action, buttonGroup);
            } else if (action.isActionMenu()) {
                toolbar.addActionMenuButton(action);
            } else {
                toolbar.add(action);
            }
        }
    }

    @Override
    public void initialize() {
        ActionRegistry.getActionRegistry();
    }

    private ActionFilter getActionFilter() {
        if (this._actionFilter == null) {
            MenuCustomizationHook customizationHook = (MenuCustomizationHook)ExtensionRegistry.getExtensionRegistry().getHook(MenuCustomizationHook.NAME);
            final List<String> hiddenItems = customizationHook.getHiddenMenuComponents();
            this._actionFilter = new ActionFilter(){

                @Override
                public boolean accept(String cmdID) {
                    boolean hidden = hiddenItems.contains(cmdID);
                    return !hidden;
                }
            };
        }
        return this._actionFilter;
    }
}

