/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.awt.Component;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;

public final class MenuWeightComparator
implements Comparator {
    private List alphaSortSectionIDs;

    public MenuWeightComparator() {
    }

    public MenuWeightComparator(List sectionToSortAlphabetically) {
        this.alphaSortSectionIDs = sectionToSortAlphabetically;
    }

    public int compare(Object o1, Object o2) {
        float two;
        JComponent comp1 = (JComponent)o1;
        JComponent comp2 = (JComponent)o2;
        Float float1 = (Float)comp1.getClientProperty("menu-weight");
        Float float2 = (Float)comp2.getClientProperty("menu-weight");
        if (this.alphaSortSectionIDs != null && this.shouldCompareByName(comp1, comp2)) {
            Comparable c1 = this.getComparable(comp1);
            Comparable c2 = this.getComparable(comp2);
            return c1.compareTo(c2);
        }
        if (float1 == null && float2 != null) {
            return 1;
        }
        if (float1 == null && float2 == null) {
            return 0;
        }
        if (float1 != null && float2 == null) {
            return -1;
        }
        float one = float1.floatValue();
        if (one < (two = float2.floatValue())) {
            return -1;
        }
        if (one == two) {
            return 0;
        }
        if (one > two) {
            return 1;
        }
        return 0;
    }

    private Comparable getComparable(Component c) {
        if (c instanceof AbstractButton) {
            return ((AbstractButton)c).getText();
        }
        return "";
    }

    private boolean shouldCompareByName(JComponent comp1, JComponent comp2) {
        Float alpha1 = (Float)comp1.getClientProperty("menu-section-id");
        Float alpha2 = (Float)comp2.getClientProperty("menu-section-id");
        if (this.isAlphaSortSection(alpha1) && this.isAlphaSortSection(alpha2) && alpha1.floatValue() == alpha2.floatValue()) {
            Iterator iter = this.alphaSortSectionIDs.iterator();
            while (iter.hasNext()) {
                if (!((Float)iter.next()).equals(alpha1)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAlphaSortSection(Float sectionID) {
        Iterator iter = this.alphaSortSectionIDs.iterator();
        while (iter.hasNext()) {
            if (!((Float)iter.next()).equals(sectionID)) continue;
            return true;
        }
        return false;
    }
}

