/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.awt.Component;
import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.ide.util.MetaClass;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.jcip.annotations.GuardedBy;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.cmd.HistoryGeneratingCommand;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Command;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.history.HistoryManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.resource.IdeArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ArrayPairList;
import oracle.javatools.util.ClosureException;
import oracle.javatools.util.Pair;
import oracle.javatools.util.PairList;
import oracle.javatools.util.SwingClosure;

public final class CommandProcessor
implements Observer {
    private static final boolean DIAGNOSTICS_TO_CONSOLE = false;
    private Map _undoStacks = new HashMap();
    private MasterStack _masterStack = new MasterStack();
    private int _batchLevel;
    private Thread _batchThread = null;
    private boolean _aborted;
    private BatchCommand _batchCommand;
    private static final CommandProcessor _INSTANCE = new CommandProcessor();
    private static final int _COMPOUND_COMMAND_ID = Ide.findOrCreateCmdID(CompoundCommand.class.getName());
    private static final int _COMMAND_PART_ID = Ide.findOrCreateCmdID(CommandPart.class.getName());

    public static CommandProcessor getInstance() {
        return _INSTANCE;
    }

    private CommandProcessor() {
        EnvironOptions environOptions = EnvironOptions.getInstance(Preferences.getPreferences());
        environOptions.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(final ChangeEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CommandProcessor.this.whenUndoStackChanges((EnvironOptions)((Object)e.getSource()));
                    }
                });
            }
        });
        this.whenUndoStackChanges(environOptions);
    }

    private void diagnostic(String message) {
        if (FeedbackManager.isOn()) {
            FeedbackManager.addFeedback(message);
        }
    }

    public final int invoke(Command cmd) throws Exception {
        Context context = cmd.getContext();
        boolean alreadyInProgress = IdeAction.handlerStarting();
        if (FeedbackManager.isOn()) {
            String commandName = cmd.getName();
            if (commandName == null) {
                commandName = cmd.getClass().getName();
            }
            FeedbackManager.addFeedback("Invoking command: " + commandName, context);
        }
        try {
            int status;
            switch (cmd.getType()) {
                case 0: {
                    UndoStack stack = this.getUndoStack(context);
                    if (stack != null) {
                        boolean affectedNodes;
                        if (cmd instanceof HistoryGeneratingCommand) {
                            this.preprocessHistoricalEvent((HistoryGeneratingCommand)((Object)cmd));
                        }
                        if (this._batchLevel == 0) {
                            status = this._masterStack.doit(cmd, stack);
                            break;
                        }
                        Object[] nodes = cmd.getAffectedNodes();
                        boolean matchingThread = Thread.currentThread() == this._batchThread;
                        boolean bl = affectedNodes = nodes != null && nodes.length > 0;
                        if (matchingThread && !affectedNodes) {
                            status = this._batchCommand.add(cmd);
                            break;
                        }
                        String batchCommandName = this._batchCommand.getName();
                        if (affectedNodes) {
                            this._masterStack.disable("Command " + cmd + " has affected nodes: " + Arrays.toString(nodes) + ". Current batch command: " + batchCommandName);
                        } else {
                            this._masterStack.disable("Command " + cmd + " invoked on thread " + Thread.currentThread() + ". Does not match batch thread " + this._batchThread + ". Current batch command: " + batchCommandName);
                        }
                        status = cmd.doit();
                        break;
                    }
                }
                case 2: {
                    UndoStack stack = this.findUndoStack(context);
                    if (cmd instanceof HistoryGeneratingCommand) {
                        this.preprocessHistoricalEvent((HistoryGeneratingCommand)((Object)cmd));
                    }
                    if (this._batchLevel > 0) {
                        this._masterStack.disable();
                    }
                    if ((status = cmd.doit()) != 0) break;
                    if (stack != null) {
                        stack.flush();
                    }
                    this.flush(cmd.getAffectedNodes());
                    break;
                }
                case 3: {
                    if (this._batchLevel == 0) {
                        cmd = new CompoundCommand(cmd);
                        this.preprocessHistoricalEvent((HistoryGeneratingCommand)((Object)cmd));
                        status = this._masterStack.doit(cmd, null);
                        break;
                    }
                    if (cmd instanceof HistoryGeneratingCommand) {
                        this.preprocessHistoricalEvent((HistoryGeneratingCommand)((Object)cmd));
                    }
                    if (Thread.currentThread() == this._batchThread) {
                        status = this._batchCommand.add(cmd);
                        break;
                    }
                    this._masterStack.disable();
                    status = cmd.doit();
                    break;
                }
                case 1: {
                    if (cmd instanceof HistoryGeneratingCommand) {
                        this.preprocessHistoricalEvent((HistoryGeneratingCommand)((Object)cmd));
                    }
                    status = cmd.doit();
                    break;
                }
                default: {
                    throw new Exception("Unrecognized Command type");
                }
            }
            if (status == 0) {
                if (cmd instanceof HistoryGeneratingCommand) {
                    this.persistHistoricalEvent((HistoryGeneratingCommand)((Object)cmd));
                }
                final NavigationManager mgr = NavigationManager.getNavigationManager();
                final Context ctx = cmd.getContext();
                if (mgr != null) {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                mgr.setLastEdit(ctx);
                            }
                        });
                    } else {
                        mgr.setLastEdit(ctx);
                    }
                }
            }
            int n = status;
            return n;
        }
        catch (Exception e) {
            FeedbackManager.reportException("Exception while processing command " + cmd.getName(), e);
            throw e;
        }
        catch (Error e) {
            FeedbackManager.reportException("Error while processing command " + cmd.getName(), e);
            throw e;
        }
        finally {
            IdeAction.handlerFinished(alreadyInProgress, Controller.UPDATE_FROM_ACTION_PERFORMED);
        }
    }

    public final int undo(Context context) throws Exception {
        if (this._batchLevel != 0) {
            FeedbackManager.reportException(new IllegalStateException("Attempting to undo while still in batch mode!"));
            return 1;
        }
        if (context == null) {
            return this._masterStack.undo();
        }
        UndoStack stack = this.findUndoStack(context);
        return stack != null && this._batchLevel == 0 ? stack.undo() : 1;
    }

    public final int redo(Context context) throws Exception {
        if (this._batchLevel != 0) {
            IllegalStateException e = new IllegalStateException("Attempting to redo while still in batch mode!");
            e.printStackTrace();
            return 1;
        }
        if (context == null) {
            return this._masterStack.redo();
        }
        UndoStack stack = this.findUndoStack(context);
        return stack != null && this._batchLevel == 0 ? stack.redo() : 1;
    }

    public boolean canUndo(Context context) {
        if (this._batchLevel > 0) {
            return false;
        }
        if (context == null) {
            return this._masterStack.canUndo();
        }
        UndoStack stack = this.findUndoStack(context);
        return stack != null ? stack.canUndo(null) : false;
    }

    public String getUndoLabel(Context context) {
        if (context == null) {
            return this._masterStack.getUndoLabel();
        }
        UndoStack stack = this.findUndoStack(context);
        return stack != null ? stack.getUndoLabel() : "";
    }

    public Command getCommand(Context context) {
        try {
            UndoStack stack = this.findUndoStack(context);
            return stack != null ? stack.peek(0) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean canRedo(Context context) {
        if (this._batchLevel > 0) {
            return false;
        }
        if (context == null) {
            return this._masterStack.canRedo();
        }
        UndoStack stack = this.findUndoStack(context);
        return stack != null ? stack.canRedo(null) : false;
    }

    public String getRedoLabel(Context context) {
        if (context == null) {
            return this._masterStack.getRedoLabel();
        }
        UndoStack stack = this.findUndoStack(context);
        return stack != null ? stack.getRedoLabel() : "";
    }

    public void flush(Object object) {
        UndoStack undoStack = (UndoStack)this._undoStacks.get(object);
        if (undoStack != null) {
            undoStack.flush();
        }
        this._undoStacks.remove(object);
    }

    public void flush(Object[] objects) {
        if (objects == null || objects.length == 0) {
            return;
        }
        for (int i = 0; i < objects.length; ++i) {
            this.flush(objects[i]);
        }
    }

    public void beginTrans(String label) {
        ++this._batchLevel;
        this.diagnostic("Started CommandProcessor transaction: " + label + " on thread " + Thread.currentThread().getName() + " at batch level " + this._batchLevel);
        if (this._batchLevel == 1) {
            this._batchCommand = new BatchCommand(label);
            this._batchThread = Thread.currentThread();
        }
    }

    public void endTrans() {
        --this._batchLevel;
        this.diagnostic("Finished CommandProcessor transaction on thread " + Thread.currentThread().getName() + " at batch level " + this._batchLevel);
        if (this._batchLevel == 0) {
            this._batchThread = null;
            if (this._masterStack.isEnabled()) {
                try {
                    this._masterStack.doit(this._batchCommand, null);
                    this._batchCommand = null;
                }
                catch (Exception e) {
                    FeedbackManager.reportException(e);
                }
            } else {
                this._masterStack.enable();
            }
        }
    }

    public void abortTrans() {
        --this._batchLevel;
        this.diagnostic("Aborted CommandProcessor transaction on thread " + Thread.currentThread().getName() + " at batch level " + this._batchLevel);
        if (this._batchLevel == 0) {
            this._batchCommand.abort();
            this._batchCommand = null;
            this._batchThread = null;
            this._aborted = false;
        } else {
            this._aborted = true;
        }
    }

    public boolean isTransactionActive() {
        return this._batchLevel > 0;
    }

    @Override
    public void update(Object observed, UpdateMessage change) {
        UndoStack stack;
        if (change != null && change.getMessageID() == NodeFactory.NODE_UNCACHED && (stack = (UndoStack)this._undoStacks.get(observed)) != null) {
            stack.release();
            this._undoStacks.remove(observed);
        }
    }

    private UndoStack findUndoStack(Context context) {
        if (context != null) {
            Node node = CommandProcessor.getSingleNodeOrNull(context);
            return (UndoStack)this._undoStacks.get(node);
        }
        return null;
    }

    private UndoStack getUndoStack(Context context) {
        if (context != null) {
            Node node = CommandProcessor.getSingleNodeOrNull(context);
            return this.getUndoStack(node);
        }
        return null;
    }

    private UndoStack getUndoStack(Node key) {
        if (key == null) {
            return null;
        }
        UndoStack undoStack = (UndoStack)this._undoStacks.get(key);
        if (undoStack == null) {
            undoStack = new UndoStack(key);
            undoStack.addUndoStackListener(this._masterStack);
            this._undoStacks.put(key, undoStack);
            NodeFactory.attach(this, key.getClass());
        }
        return undoStack;
    }

    private void preprocessHistoricalEvent(HistoryGeneratingCommand cmd) {
        Node[] nodes = cmd.getHistoriedNodes();
        HistoryManager mgr = HistoryManager.getHistoryManager();
        if (mgr != null) {
            URL[] urls = new URL[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                urls[i] = nodes[i].getURL();
            }
            try {
                mgr.persistInitialState(urls);
                if (cmd.isGeneratePrecedingState()) {
                    ArrayList<URL> list = new ArrayList<URL>();
                    for (int i = 0; i < nodes.length; ++i) {
                        if (!nodes[i].isDirty()) continue;
                        list.add(nodes[i].getURL());
                    }
                    int size = list.size();
                    if (size > 0) {
                        urls = new URL[size];
                        list.toArray(urls);
                        mgr.persist(urls, null);
                    }
                }
            }
            catch (Exception e) {
                FeedbackManager.reportException(e);
            }
        }
    }

    private void persistHistoricalEvent(HistoryGeneratingCommand cmd) {
        Node[] nodes = cmd.getHistoriedNodes();
        HistoryManager mgr = HistoryManager.getHistoryManager();
        if (mgr != null) {
            URL[] urls = new URL[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                urls[i] = nodes[i].getURL();
            }
            try {
                mgr.persist(urls, cmd.getName());
            }
            catch (Exception e) {
                FeedbackManager.reportException(e);
            }
        }
    }

    private void whenUndoStackChanges(EnvironOptions environOptions) {
        this._masterStack.setStackSize(environOptions.getUndoLevel());
    }

    public static Command createCommand(String cmd, Context context) {
        if (cmd == null) {
            return null;
        }
        return CommandProcessor.createCommandFromMeta(new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader("ide-global"), cmd), context);
    }

    public static Command createCommandFromMeta(MetaClass commandMeta, Context context) {
        Command newCmd = null;
        if (commandMeta != null) {
            try {
                Class<?> cls = Class.forName(commandMeta.getClassName(), true, commandMeta.getClassLoader());
                newCmd = (Command)cls.newInstance();
                newCmd.setContext(context);
            }
            catch (ClassNotFoundException cnfe) {
                FeedbackManager.reportException("String '" + commandMeta.getClassName() + "' is not a valid classname or the class was not found on the classpath", cnfe);
            }
            catch (ClassCastException cce) {
                FeedbackManager.reportException("Class '" + commandMeta.getClassName() + "' is not a subclass of " + Command.class, cce);
            }
            catch (Exception e) {
                FeedbackManager.reportException(e);
            }
        }
        return newCmd;
    }

    private static Node getSingleNodeOrNull(Context context) {
        if (!CommandProcessor.areMultipleNodesSelected(context)) {
            return context.getNode();
        }
        return null;
    }

    private static boolean areMultipleNodesSelected(Context context) {
        int n;
        Element[] selection = context.getSelection();
        if (selection != null && selection.length > 1 && (n = selection.length) > 1) {
            int cnt = 0;
            for (int i = 0; i < n; ++i) {
                if (!(selection[i] instanceof Node) || ++cnt <= 1) continue;
                return true;
            }
        }
        return false;
    }

    private static final class ExternalModificationException
    extends RuntimeException {
    }

    private static final class CommandPart
    extends Command {
        private CompoundCommand _owner;
        private boolean _isAddition;
        private boolean _isDeletion;
        private URL _url;

        CommandPart(CompoundCommand owner) {
            super(_COMMAND_PART_ID, 0, owner.getName());
            this._owner = owner;
        }

        @Override
        public int doit() throws Exception {
            return this._owner.isWorking() ? 0 : this._owner.doit(this);
        }

        @Override
        public int undo() throws Exception {
            return this._owner.isWorking() ? 0 : this._owner.undo(this);
        }

        @Override
        public Context getContext() {
            if (this._url != null) {
                Context ctx = new Context(this.context);
                try {
                    ctx.setNode(NodeFactory.findOrCreate(this._url));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return ctx;
            }
            return super.getContext();
        }

        void setAddition(boolean isAddition) {
            this._isAddition = isAddition;
            this._url = this.context.getNode().getURL();
            this.context.setNode(null);
        }

        boolean isAddition() {
            return this._isAddition;
        }

        void setDeletion(boolean isDeletion) {
            this._isDeletion = isDeletion;
            this._url = this.context.getNode().getURL();
            this.context.setNode(null);
        }

        boolean isDeletion() {
            return this._isDeletion;
        }
    }

    private static final class BatchCommand
    extends CompoundCommand {
        BatchCommand(String name) {
            super(name);
            Context ctx = Context.newIdeContext();
            ctx.setView(null);
            ctx.setNode(null);
            ctx.setSelection(null);
            this.setContext(ctx);
            this._parts = new LinkedHashMap();
        }

        @Override
        protected boolean canDo() {
            return this._firstTime ? true : super.canDo();
        }

        @Override
        protected int doCommands() throws Exception {
            if (this._firstTime) {
                this._firstTime = false;
                this._done = true;
                return 0;
            }
            return super.doCommands();
        }

        int add(Command cmd) throws Exception {
            int result;
            Context ctx = new Context(cmd.getContext());
            Node[] nodes = cmd.getAffectedNodes();
            this.addPart(ctx);
            if (nodes != null) {
                for (int j = 0; j < nodes.length; ++j) {
                    ctx = new Context(ctx);
                    ctx.setNode(nodes[j]);
                    this.addPart(ctx);
                }
            }
            if ((result = cmd.doit()) == 0) {
                Command[] temp = new Command[this._commands.length + 1];
                System.arraycopy(this._commands, 0, temp, 0, this._commands.length);
                temp[temp.length - 1] = cmd;
                this._commands = temp;
            }
            return result;
        }

        void abort() {
            if (this._commands != null) {
                for (int i = this._commands.length - 1; i >= 0; --i) {
                    try {
                        this._commands[i].undo();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this._commands = null;
            }
        }
    }

    private static class CompoundCommand
    extends Command
    implements HistoryGeneratingCommand,
    UndoStackListener {
        private List _historied;
        private boolean _working;
        private boolean _adjusted;
        protected boolean _firstTime = true;
        protected boolean _done;
        protected Map<Node, CommandPart> _parts;
        protected Command[] _commands;

        CompoundCommand(Command cmd) {
            super(_COMPOUND_COMMAND_ID, 1, cmd.getName());
            this.setContext(cmd.getContext());
            this._commands = new Command[]{cmd};
        }

        protected CompoundCommand(String name) {
            super(_COMPOUND_COMMAND_ID, 1, name);
            this._commands = new Command[0];
        }

        boolean isWorking() {
            return this._working;
        }

        boolean isDone() {
            return this._done;
        }

        @Override
        public boolean isGlobal() {
            return this.getParts().size() > 1;
        }

        @Override
        public int doit() throws Exception {
            return this.doit(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int doit(CommandPart srcPart) throws Exception {
            boolean isRedo;
            if (!this.canDo()) {
                CompoundCommand.showErrorMessage(false);
                return 1;
            }
            boolean bl = isRedo = !this._firstTime;
            if (isRedo && Ide.getIdeArgs().getCreateUI() && this.isGlobal() && !MessageDialog.optionalConfirm((String)"oracle.ide.controller.CommandProcessor.redoConfirmation", (Component)((Object)Ide.getMainWindow()), (String)IdeArb.format(458, new String[]{this.getName()}), (String)IdeArb.format(83, new String[]{""}), (String)"f1_javaappdevgeneric_redo_html")) {
                return 1;
            }
            int status = this.doCommands();
            if (status == 0) {
                try {
                    this._working = true;
                    this.adjustParts();
                    CommandProcessor cp = CommandProcessor.getInstance();
                    ArrayList<CommandPart> list = new ArrayList<CommandPart>(this.getParts());
                    for (CommandPart part : list) {
                        if (part == srcPart || part.isDeletion()) continue;
                        try {
                            Context ctx = part.getContext();
                            UndoStack undoStack = cp.getUndoStack(ctx);
                            if (isRedo) {
                                if (part.isAddition()) {
                                    undoStack.flush();
                                    undoStack.addToDoneStack(part);
                                    continue;
                                }
                                undoStack.redo();
                                continue;
                            }
                            undoStack.doit(part);
                        }
                        catch (Exception e) {
                            status = 1;
                        }
                    }
                }
                finally {
                    this._working = false;
                }
            }
            return status;
        }

        protected boolean canDo() {
            ArrayList<CommandPart> list = new ArrayList<CommandPart>(this.getParts());
            for (CommandPart part : list) {
                if (CompoundCommand.canDo(part)) continue;
                return false;
            }
            return true;
        }

        private static boolean canDo(CommandPart cmd) {
            if (cmd == null) {
                return false;
            }
            if (cmd.isAddition()) {
                return true;
            }
            UndoStack stack = CommandProcessor.getInstance().findUndoStack(cmd.getContext());
            if (stack != null) {
                if (stack.isUndone(cmd)) {
                    return stack.canRedo(cmd);
                }
                return !stack.isDone(cmd);
            }
            return false;
        }

        @Override
        public int undo() throws Exception {
            return this.undo(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int undo(CommandPart srcPart) throws Exception {
            ArrayList<CommandPart> list = new ArrayList<CommandPart>(this.getParts());
            for (CommandPart part : list) {
                if (CompoundCommand.canUndo(part)) continue;
                CompoundCommand.showErrorMessage(true);
                return 1;
            }
            if (Ide.getIdeArgs().getCreateUI() && this.isGlobal() && !MessageDialog.optionalConfirm((String)"oracle.ide.controller.CommandProcessor.undoConfirmation", (Component)((Object)Ide.getMainWindow()), (String)IdeArb.format(457, new String[]{this.getName()}), (String)IdeArb.format(80, new String[]{""}), (String)"f1_javaappdevgeneric_undo_html")) {
                return 1;
            }
            int status = this.undoCommands();
            if (status == 0) {
                try {
                    this._working = true;
                    list = new ArrayList<CommandPart>(this.getParts());
                    CommandProcessor cp = CommandProcessor.getInstance();
                    for (CommandPart part : list) {
                        if (part == srcPart || part.isAddition()) continue;
                        try {
                            UndoStack undoStack = cp.getUndoStack(part.getContext());
                            if (part.isDeletion()) {
                                undoStack.flush();
                                undoStack.addToUndoneStack(part);
                                continue;
                            }
                            undoStack.undo();
                        }
                        catch (Exception e) {
                            status = 1;
                        }
                    }
                }
                finally {
                    this._working = false;
                }
            }
            return status;
        }

        private static boolean canUndo(CommandPart cmd) {
            if (cmd == null) {
                return false;
            }
            if (cmd.isDeletion()) {
                return true;
            }
            UndoStack stack = CommandProcessor.getInstance().findUndoStack(cmd.getContext());
            return stack != null && stack.canUndo(cmd);
        }

        protected int doCommands() throws Exception {
            for (int i = 0; i < this._commands.length; ++i) {
                try {
                    if (this._commands[i].doit() == 0) continue;
                    while (--i >= 0) {
                        try {
                            this._commands[i].undo();
                        }
                        catch (Exception x) {}
                    }
                    return 1;
                }
                catch (Exception e) {
                    while (--i >= 0) {
                        try {
                            this._commands[i].undo();
                        }
                        catch (Exception exception) {}
                    }
                    throw e;
                }
            }
            this._firstTime = false;
            this._done = true;
            return 0;
        }

        protected int undoCommands() throws Exception {
            for (int i = this._commands.length - 1; i >= 0; --i) {
                try {
                    if (this._commands[i].undo() == 0) continue;
                    while (++i < this._commands.length) {
                        try {
                            this._commands[i].doit();
                        }
                        catch (Exception x) {}
                    }
                    return 1;
                }
                catch (Exception e) {
                    while (++i < this._commands.length) {
                        try {
                            this._commands[i].doit();
                        }
                        catch (Exception exception) {}
                    }
                    throw e;
                }
            }
            this._done = false;
            return 0;
        }

        @Override
        public Node[] getHistoriedNodes() {
            if (this._historied == null) {
                this._historied = new ArrayList();
                for (int i = 0; i < this._commands.length; ++i) {
                    Context ctx = this._commands[i].getContext();
                    Node node = ctx.getNode();
                    Node[] nodes = this._commands[i].getAffectedNodes();
                    if (node != null && !this._historied.contains(node)) {
                        this._historied.add(node);
                    }
                    if (nodes == null) continue;
                    for (int j = 0; j < nodes.length; ++j) {
                        if (nodes[j] == null || this._historied.contains(nodes[j])) continue;
                        this._historied.add(nodes[j]);
                    }
                }
            }
            Node[] result = new Node[this._historied.size()];
            this._historied.toArray(result);
            return result;
        }

        @Override
        public boolean isGeneratePrecedingState() {
            return true;
        }

        protected Collection<CommandPart> getParts() {
            if (this._parts == null) {
                this._parts = new LinkedHashMap<Node, CommandPart>();
                for (int i = 0; i < this._commands.length; ++i) {
                    Node[] nodes = this._commands[i].getAffectedNodes();
                    Context ctx = this._commands[i].getContext();
                    ctx = new Context(ctx);
                    this.addPart(ctx);
                    if (nodes == null) continue;
                    for (int j = 0; j < nodes.length; ++j) {
                        ctx = new Context(ctx);
                        ctx.setNode(nodes[j]);
                        this.addPart(ctx);
                    }
                }
            }
            return this._parts.values();
        }

        protected CommandPart addPart(Context ctx) {
            Node node = ctx != null ? ctx.getNode() : null;
            CommandPart part = this.getPart(node);
            if (part == null && (part = this.createPart(ctx)) != null) {
                this._parts.put(node, part);
            }
            return part;
        }

        protected CommandPart getPart(Node node) {
            return this._parts.get(node);
        }

        protected CommandPart createPart(Context ctx) {
            Node node = ctx != null ? ctx.getNode() : null;
            UndoStack undoStack = CommandProcessor.getInstance().getUndoStack(node);
            if (undoStack == null) {
                return null;
            }
            CommandPart part = new CommandPart(this);
            ctx.setNode(node);
            ctx.setSelection(null);
            part.setContext(ctx);
            undoStack.addUndoStackListener(this);
            return part;
        }

        protected void adjustParts() {
            Node node;
            if (this._adjusted) {
                return;
            }
            this._adjusted = true;
            ArrayList<Node> additions = new ArrayList<Node>();
            for (int i = 0; i < this._commands.length; ++i) {
                Context ctx = this._commands[i].getContext();
                Node[] nodes = this._commands[i].getAffectedNodes();
                node = ctx.getNode();
                if (node != null && !additions.contains(node)) {
                    additions.add(node);
                }
                if (nodes == null) continue;
                for (int j = 0; j < nodes.length; ++j) {
                    if (nodes[j] == null || additions.contains(nodes[j])) continue;
                    additions.add(nodes[j]);
                }
            }
            for (CommandPart cmd : this.getParts()) {
                Context ctx = cmd.getContext();
                node = ctx.getNode();
                if (!additions.contains(node)) {
                    cmd.setDeletion(true);
                    continue;
                }
                additions.remove(node);
            }
            for (int i = additions.size() - 1; i >= 0; --i) {
                CommandPart part = this.addPart(new Context((Node)additions.get(i)));
                part.setAddition(true);
            }
            additions.clear();
        }

        @Override
        public void commandsDropped(UndoStackEvent e) {
            Command[] commands = e.getCommands();
            for (int i = 0; i < commands.length; ++i) {
                Command dropped = commands[i];
                if (!this.getParts().contains(dropped)) continue;
                UndoStack undoStack = CommandProcessor.getInstance().findUndoStack(dropped.getContext());
                this.getParts().remove(dropped);
                if (undoStack != null) {
                    undoStack.removeUndoStackListener(this);
                }
                while (this.getParts().size() > 0) {
                    Command part = this.getParts().iterator().next();
                    Context ctx = part != null ? part.getContext() : null;
                    undoStack = CommandProcessor.getInstance().findUndoStack(ctx);
                    this.getParts().remove(part);
                    if (undoStack == null) continue;
                    undoStack.removeUndoStackListener(this);
                    undoStack.flush(part);
                }
                break;
            }
        }

        private static void showErrorMessage(boolean isUndo) {
            String errorMsg;
            String string = errorMsg = isUndo ? IdeArb.getString(426) : IdeArb.getString(427);
            if (Ide.getIdeArgs().getCreateUI()) {
                MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)errorMsg, (String)IdeArb.getString(236), null);
            } else {
                System.err.println(errorMsg);
            }
        }
    }

    private static final class MasterStack
    implements UndoStackListener {
        private final Object _lock = new Object();
        @GuardedBy(value="_lock")
        private int _maxSize;
        @GuardedBy(value="_lock")
        private boolean _enabled = true;
        @GuardedBy(value="_lock")
        private PairList<Command, UndoStack> _commandStackPairs = new ArrayPairList();

        private MasterStack() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int doit(Command cmd, UndoStack stack) throws Exception {
            int status;
            int n = status = stack != null ? stack.doit(cmd) : cmd.doit();
            if (status == 0) {
                Object object = this._lock;
                synchronized (object) {
                    this._commandStackPairs.add((Object)new Pair((Object)cmd, (Object)stack));
                    this.trim();
                }
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean canUndo() {
            Object object = this._lock;
            synchronized (object) {
                for (int i = this._commandStackPairs.size() - 1; i >= 0; --i) {
                    Command cmd = (Command)((Pair)this._commandStackPairs.get(i)).getFirst();
                    if (!cmd.isGlobal()) continue;
                    UndoStack stack = (UndoStack)((Pair)this._commandStackPairs.get(i)).getSecond();
                    if (stack == null) {
                        if (!((CompoundCommand)cmd).isDone()) continue;
                        return true;
                    }
                    if (!stack.isDone(cmd)) continue;
                    return stack.canUndo(cmd);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getUndoLabel() {
            Object object = this._lock;
            synchronized (object) {
                for (int i = this._commandStackPairs.size() - 1; i >= 0; --i) {
                    Command cmd = (Command)((Pair)this._commandStackPairs.get(i)).getFirst();
                    if (!cmd.isGlobal()) continue;
                    UndoStack stack = (UndoStack)((Pair)this._commandStackPairs.get(i)).getSecond();
                    if (stack == null) {
                        if (!((CompoundCommand)cmd).isDone()) continue;
                        return cmd.getName();
                    }
                    if (!stack.isDone(cmd)) continue;
                    return stack.canUndo(cmd) ? cmd.getName() : "";
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int undo() throws Exception {
            CommandExecutor exec = null;
            Object object = this._lock;
            synchronized (object) {
                for (int i = this._commandStackPairs.size() - 1; i >= 0; --i) {
                    boolean confirmed;
                    final Command cmd = (Command)((Pair)this._commandStackPairs.get(i)).getFirst();
                    if (!cmd.isGlobal()) continue;
                    final UndoStack stack = (UndoStack)((Pair)this._commandStackPairs.get(i)).getSecond();
                    if (stack == null) {
                        if (!((CompoundCommand)cmd).isDone()) continue;
                        exec = new CommandExecutor(){

                            @Override
                            public int run() throws Exception {
                                return cmd.undo();
                            }
                        };
                        break;
                    }
                    if (!stack.isDone(cmd)) continue;
                    boolean bl = confirmed = !Ide.getIdeArgs().getCreateUI();
                    if (!confirmed) {
                        confirmed = MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)IdeArb.format(457, new String[]{cmd.getName()}), (String)IdeArb.getString(80), null);
                    }
                    if (confirmed) {
                        exec = new CommandExecutor(){

                            @Override
                            public int run() throws Exception {
                                return stack.canUndo(cmd) ? stack.undo() : 1;
                            }
                        };
                        break;
                    }
                    return 1;
                }
            }
            if (exec != null) {
                return exec.run();
            }
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean canRedo() {
            Object object = this._lock;
            synchronized (object) {
                for (int i = this._commandStackPairs.size() - 1; i >= 0; --i) {
                    Command cmd = (Command)((Pair)this._commandStackPairs.get(i)).getFirst();
                    if (!cmd.isGlobal()) continue;
                    UndoStack stack = (UndoStack)((Pair)this._commandStackPairs.get(i)).getSecond();
                    if (stack == null) {
                        if (((CompoundCommand)cmd).isDone()) continue;
                        return true;
                    }
                    if (!stack.isUndone(cmd)) continue;
                    return stack.canRedo(cmd);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getRedoLabel() {
            Object object = this._lock;
            synchronized (object) {
                for (int i = this._commandStackPairs.size() - 1; i >= 0; --i) {
                    Command cmd = (Command)((Pair)this._commandStackPairs.get(i)).getFirst();
                    if (!cmd.isGlobal()) continue;
                    UndoStack stack = (UndoStack)((Pair)this._commandStackPairs.get(i)).getSecond();
                    if (stack == null) {
                        if (((CompoundCommand)cmd).isDone()) continue;
                        return cmd.getName();
                    }
                    if (!stack.isUndone(cmd)) continue;
                    return stack.canRedo(cmd) ? cmd.getName() : "";
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int redo() throws Exception {
            CommandExecutor exec = null;
            Object object = this._lock;
            synchronized (object) {
                for (int i = this._commandStackPairs.size() - 1; i >= 0; --i) {
                    boolean confirmed;
                    final Command cmd = (Command)((Pair)this._commandStackPairs.get(i)).getFirst();
                    if (!cmd.isGlobal()) continue;
                    final UndoStack stack = (UndoStack)((Pair)this._commandStackPairs.get(i)).getSecond();
                    if (stack == null) {
                        if (((CompoundCommand)cmd).isDone()) continue;
                        exec = new CommandExecutor(){

                            @Override
                            public int run() throws Exception {
                                return cmd.doit();
                            }
                        };
                        break;
                    }
                    if (!stack.isUndone(cmd)) continue;
                    boolean bl = confirmed = !Ide.getIdeArgs().getCreateUI();
                    if (!confirmed) {
                        confirmed = MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)IdeArb.format(458, new String[]{cmd.getName()}), (String)IdeArb.getString(83), null);
                    }
                    if (confirmed) {
                        exec = new CommandExecutor(){

                            @Override
                            public int run() throws Exception {
                                return stack.canRedo(cmd) ? stack.redo() : 1;
                            }
                        };
                        break;
                    }
                    return 1;
                }
            }
            if (exec != null) {
                return exec.run();
            }
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getStackSize() {
            Object object = this._lock;
            synchronized (object) {
                return this._maxSize;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setStackSize(int size) {
            if (!this.isEnabled()) {
                return;
            }
            if (size >= 0) {
                Object object = this._lock;
                synchronized (object) {
                    this._maxSize = size;
                    this.trim();
                }
                IdeAction action = IdeAction.find(5);
                if (action != null) {
                    Ide.getIdeController().update(action, null);
                }
                if ((action = IdeAction.find(6)) != null) {
                    Ide.getIdeController().update(action, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void enable() {
            Object object = this._lock;
            synchronized (object) {
                if (this._enabled) {
                    return;
                }
                this._enabled = true;
            }
            this.showEnabledDialog(true);
            this.setStackSize(EnvironOptions.getInstance(Preferences.getPreferences()).getUndoLevel());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void disable(String reason) {
            Object object = this._lock;
            synchronized (object) {
                if (!this._enabled) {
                    return;
                }
                this._enabled = false;
            }
            FeedbackManager.reportException(new IllegalStateException(reason));
            this.showEnabledDialog(false);
            this.setStackSize(0);
        }

        synchronized void disable() {
            this.disable("Cannot invoke Command from other thread, or with non undoable side effects, while in batch mode\nDisabling Undo support until batch completed.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized boolean isEnabled() {
            Object object = this._lock;
            synchronized (object) {
                return this._enabled;
            }
        }

        void showEnabledDialog(final boolean enabled) {
            try {
                new SwingClosure(true){

                    protected void runImpl() {
                        MessageDialog.information((Component)((Object)Ide.getMainWindow()), (Object)(enabled ? IdeArb.getString(460) : IdeArb.getString(459)), (String)IdeArb.format(80, ""), null);
                    }
                }.run();
            }
            catch (ClosureException closureException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void trim() {
            Object object = this._lock;
            synchronized (object) {
                int currentSize = this._commandStackPairs.size();
                while (currentSize > this._maxSize) {
                    Command cmd = (Command)((Pair)this._commandStackPairs.get(0)).getFirst();
                    UndoStack stack = (UndoStack)((Pair)this._commandStackPairs.get(0)).getSecond();
                    if (stack == null) {
                        CompoundCommand wrapper = (CompoundCommand)cmd;
                        boolean isDone = wrapper.isDone();
                        Collection<CommandPart> parts = wrapper.getParts();
                        Iterator<CommandPart> i = parts.iterator();
                        while (stack == null && i.hasNext()) {
                            CommandPart part = i.next();
                            if (part.isDeletion()) {
                                if (isDone || (stack = CommandProcessor.getInstance().getUndoStack(part.getContext())) == null) continue;
                                cmd = part;
                                continue;
                            }
                            if (part.isAddition()) {
                                if (!isDone || (stack = CommandProcessor.getInstance().getUndoStack(part.getContext())) == null) continue;
                                cmd = part;
                                continue;
                            }
                            stack = CommandProcessor.getInstance().getUndoStack(part.getContext());
                            if (stack == null) continue;
                            cmd = part;
                        }
                    }
                    if (stack != null) {
                        stack.flush(cmd);
                    } else {
                        this.commandsDropped(new UndoStackEvent(this, new Command[]{cmd}));
                    }
                    currentSize = this._commandStackPairs.size();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commandsDropped(UndoStackEvent e) {
            Command[] cmds;
            Command[] commandArray = cmds = e != null ? e.getCommands() : null;
            if (cmds != null) {
                Object object = this._lock;
                synchronized (object) {
                    for (int i = 0; i < cmds.length; ++i) {
                        Command cmd = cmds[i];
                        int index = this._commandStackPairs.indexOfFirstType((Object)cmd);
                        if (index < 0 && cmd instanceof CommandPart) {
                            cmd = ((CommandPart)cmd)._owner;
                            index = this._commandStackPairs.indexOfFirstType((Object)cmd);
                        }
                        if (index < 0) continue;
                        this._commandStackPairs.remove(index);
                    }
                }
            }
        }
    }

    private static interface CommandExecutor {
        public int run() throws Exception;
    }

    private static final class UndoStackEvent
    extends EventObject {
        private Command[] _commands;

        public UndoStackEvent(Object source, Command[] commands) {
            super(source);
            this._commands = commands;
        }

        public Command[] getCommands() {
            return this._commands;
        }
    }

    private static interface UndoStackListener {
        public void commandsDropped(UndoStackEvent var1);
    }

    private static final class UndoStack
    extends NodeListener {
        static final int DONE = 0;
        static final int UNDONE = 1;
        private final Object _stacksLock = new Object();
        @GuardedBy(value="_stacksLock")
        private final Stack<Command> _doneStack = new Stack();
        @GuardedBy(value="_stacksLock")
        private final Stack<Command> _undoneStack = new Stack();
        @GuardedBy(value="_listeners")
        private final List<UndoStackListener> _listeners = new ArrayList<UndoStackListener>();
        private final Node _node;

        UndoStack(Node node) {
            this._node = node;
            node.addNodeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addToUndoneStack(Command cmd) {
            if (cmd == null) {
                return;
            }
            Object object = this._stacksLock;
            synchronized (object) {
                this._undoneStack.push(cmd);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addToDoneStack(Command cmd) {
            if (cmd == null) {
                return;
            }
            Object object = this._stacksLock;
            synchronized (object) {
                this._doneStack.push(cmd);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int doit(Command cmd) throws Exception {
            int status = this.executeCommand(cmd);
            if (status == 0) {
                Object object = this._stacksLock;
                synchronized (object) {
                    this._doneStack.push(cmd);
                }
                this.trim(1, 0);
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean canUndo(Command cmd) {
            Object object = this._stacksLock;
            synchronized (object) {
                if (!this._doneStack.isEmpty()) {
                    return cmd == null || this._doneStack.get(this._doneStack.size() - 1) == cmd;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getUndoLabel() {
            Object object = this._stacksLock;
            synchronized (object) {
                Command cmd = !this._doneStack.isEmpty() ? (Command)this._doneStack.get(this._doneStack.size() - 1) : null;
                return cmd != null ? cmd.getName() : "";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int undo() throws Exception {
            boolean alreadyInProgress = Ide.isQuitting();
            Command cmd = null;
            int status = 1;
            try {
                cmd = this.peek(0);
                if (cmd != null) {
                    alreadyInProgress = alreadyInProgress || IdeAction.handlerStarting();
                    status = cmd.undo();
                    Object object = this._stacksLock;
                    synchronized (object) {
                        if (status == 0 && !this._doneStack.empty()) {
                            this._undoneStack.push(this._doneStack.pop());
                        }
                    }
                }
                int n = status;
                return n;
            }
            catch (ExternalModificationException e) {
                int n = status;
                return n;
            }
            finally {
                if (cmd != null) {
                    IdeAction.handlerFinished(alreadyInProgress, Controller.UPDATE_FROM_UNDO);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean canRedo(Command cmd) {
            Object object = this._stacksLock;
            synchronized (object) {
                if (!this._undoneStack.isEmpty()) {
                    return cmd == null || this._undoneStack.get(this._undoneStack.size() - 1) == cmd;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getRedoLabel() {
            Object object = this._stacksLock;
            synchronized (object) {
                Command cmd = !this._undoneStack.isEmpty() ? (Command)this._undoneStack.get(this._undoneStack.size() - 1) : null;
                return cmd != null ? cmd.getName() : null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int redo() throws Exception {
            boolean alreadyInProgress = Ide.isQuitting();
            Command cmd = null;
            int status = 1;
            try {
                cmd = this.peek(1);
                if (cmd != null) {
                    alreadyInProgress = alreadyInProgress || IdeAction.handlerStarting();
                    status = this.executeCommand(cmd);
                    if (status == 0) {
                        Object object = this._stacksLock;
                        synchronized (object) {
                            this._doneStack.push(this._undoneStack.pop());
                        }
                    }
                }
                int n = status;
                return n;
            }
            catch (ExternalModificationException e) {
                int n = status;
                return n;
            }
            finally {
                if (cmd != null) {
                    IdeAction.handlerFinished(alreadyInProgress, Controller.UPDATE_FROM_UNDO);
                }
            }
        }

        int executeCommand(Command cmd) throws Exception {
            int status = cmd.doit();
            if (status == 0) {
                CommandProcessor.getInstance().flush(cmd.getAffectedNodes());
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isDone(Command cmd) {
            Object object = this._stacksLock;
            synchronized (object) {
                if (!this._doneStack.isEmpty()) {
                    return this._doneStack.contains(cmd);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isUndone(Command cmd) {
            Object object = this._stacksLock;
            synchronized (object) {
                if (!this._undoneStack.isEmpty()) {
                    return this._undoneStack.contains(cmd);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Command peek(int state) throws Exception {
            Object object = this._stacksLock;
            synchronized (object) {
                Stack<Command> stack = state == 0 ? this._doneStack : this._undoneStack;
                return !stack.isEmpty() ? (Command)stack.lastElement() : null;
            }
        }

        void flush() {
            this.trim(0, 0);
            this.trim(1, 0);
        }

        void flush(Command cmd) {
            if (this.stacksHaveContent()) {
                this.trim(1, cmd);
                this.trim(0, cmd);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void trim(int state, Command cmd) {
            int trimBy = -1;
            Object object = this._stacksLock;
            synchronized (object) {
                Stack<Command> stack = state == 0 ? this._doneStack : this._undoneStack;
                int index = stack.indexOf(cmd);
                trimBy = stack.size() - ++index;
            }
            this.trim(state, trimBy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void trim(int state, int size) {
            Command[] commands = null;
            Object object = this._stacksLock;
            synchronized (object) {
                Stack<Command> stack;
                Stack<Command> stack2 = stack = state == 0 ? this._doneStack : this._undoneStack;
                if (stack != null && stack.size() > size) {
                    List sublist = stack.subList(0, stack.size() - size);
                    commands = new Command[sublist.size()];
                    sublist.toArray(commands);
                    for (int i = 0; i < commands.length; ++i) {
                        stack.remove(commands[i]);
                    }
                }
            }
            if (commands != null && commands.length > 0) {
                this.fireCommandsDropped(new UndoStackEvent(this, commands));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void release() {
            this.flush();
            List<UndoStackListener> list = this._stacksLock;
            synchronized (list) {
                this._doneStack.clear();
                this._undoneStack.clear();
            }
            list = this._listeners;
            synchronized (list) {
                this._listeners.clear();
            }
            this._node.removeNodeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addUndoStackListener(UndoStackListener listener) {
            List<UndoStackListener> list = this._listeners;
            synchronized (list) {
                if (!this._listeners.contains(listener)) {
                    this._listeners.add(listener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeUndoStackListener(UndoStackListener listener) {
            List<UndoStackListener> list = this._listeners;
            synchronized (list) {
                this._listeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireCommandsDropped(UndoStackEvent e) {
            UndoStackListener[] listeners;
            List<UndoStackListener> list = this._listeners;
            synchronized (list) {
                listeners = new UndoStackListener[this._listeners.size()];
                this._listeners.toArray(listeners);
            }
            if (listeners != null) {
                for (int i = 0; i < listeners.length; ++i) {
                    listeners[i].commandsDropped(e);
                }
            }
        }

        @Override
        public void nodeWillClose(NodeEvent e) {
            this.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean stacksHaveContent() {
            Object object = this._stacksLock;
            synchronized (object) {
                return this._doneStack.size() > 0 || this._undoneStack.size() > 0;
            }
        }
    }
}

