/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import oracle.ide.Ide;

public final class SplashScreenOptions {
    private static final String IS_SPLASH_FILE = ".issplash";
    private static final int DEFAULT_STEPS = 153;

    private SplashScreenOptions() {
    }

    public static void freshInstall() {
        SplashScreenOptions.createSplashFile(153);
    }

    public static boolean getShowSplashScreen() {
        return SplashScreenOptions.splashFileExists();
    }

    public static void setShowSplashScreen(boolean showSplashScreen) {
        if (showSplashScreen) {
            if (!SplashScreenOptions.splashFileExists()) {
                SplashScreenOptions.createSplashFile(-1);
            }
        } else {
            SplashScreenOptions.deleteSplashFile();
        }
    }

    public static void setSplashScreenCounter(int cnt) {
        if (SplashScreenOptions.getShowSplashScreen()) {
            SplashScreenOptions.createSplashFile(cnt);
        }
    }

    public static int getSplashScreenCounter() {
        if (SplashScreenOptions.splashFileExists()) {
            return SplashScreenOptions.readSplashCounter();
        }
        return -1;
    }

    private static File getSplashFile() {
        return new File(Ide.getSystemDirectory(), IS_SPLASH_FILE);
    }

    private static boolean splashFileExists() {
        File splashFile = SplashScreenOptions.getSplashFile();
        return splashFile.exists();
    }

    private static int readSplashCounter() {
        if (SplashScreenOptions.splashFileExists()) {
            File splashFile = SplashScreenOptions.getSplashFile();
            try {
                DataInputStream is = new DataInputStream(new FileInputStream(splashFile));
                int res = is.readInt();
                is.close();
                if (res > 0) {
                    return res;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return -1;
    }

    private static boolean createSplashFile(int cnt) {
        File splashFile = SplashScreenOptions.getSplashFile();
        try {
            DataOutputStream ds = new DataOutputStream(new FileOutputStream(splashFile));
            ds.writeInt(cnt);
            ds.close();
            return true;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private static boolean deleteSplashFile() {
        File splashFile = SplashScreenOptions.getSplashFile();
        return splashFile.delete();
    }
}

