/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.ide.config.SettingsFieldCustomizations;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public final class SettingsCustomizations
extends HashStructureAdapter {
    private SettingsCustomizations(HashStructure hs) {
        super(hs);
    }

    static SettingsCustomizations getInstance(HashStructure hs) {
        return new SettingsCustomizations(hs);
    }

    private HashStructure getPageHashStructure(String page) {
        List hs = this._hash.getAsList("page");
        if (hs == null) {
            return null;
        }
        for (HashStructure i : hs) {
            if (!page.equals(i.getString("idref"))) continue;
            return i;
        }
        return null;
    }

    public Set<String> getFieldIds(String pageId) {
        if (pageId.charAt(0) != '/') {
            throw new IllegalArgumentException("Bad page id: " + pageId);
        }
        HashStructure pageStructure = this.getPageHashStructure(pageId);
        if (pageStructure == null) {
            return Collections.emptySet();
        }
        HashSet<String> ids = new HashSet<String>();
        List fields = pageStructure.getAsList("field");
        for (HashStructure hs : fields) {
            ids.add(hs.getString("idref"));
        }
        return Collections.unmodifiableSet(ids);
    }

    public SettingsFieldCustomizations getFieldCustomizations(String fieldIdPath) {
        if (fieldIdPath.charAt(0) != '/') {
            throw new IllegalArgumentException("bad path " + fieldIdPath);
        }
        int lastSlash = fieldIdPath.lastIndexOf(47);
        if (lastSlash <= 0) {
            throw new IllegalArgumentException("bad path " + fieldIdPath);
        }
        if (lastSlash == fieldIdPath.length() - 1) {
            throw new IllegalArgumentException("bad path " + fieldIdPath);
        }
        String pageId = fieldIdPath.substring(0, lastSlash);
        String fieldId = fieldIdPath.substring(lastSlash + 1);
        HashStructure pageStructure = this.getPageHashStructure(pageId);
        if (pageStructure == null) {
            return null;
        }
        List fields = pageStructure.getAsList("field");
        for (HashStructure hs : fields) {
            SettingsFieldCustomizations customizations = SettingsFieldCustomizations.getInstance(hs);
            if (!fieldId.equals(customizations.getIdRef())) continue;
            return customizations;
        }
        return null;
    }

    public Collection<String> getHiddenPages() {
        List data = this._hash.getAsList("page");
        if (data == null) {
            return Collections.emptySet();
        }
        ArrayList<String> ids = new ArrayList<String>(data.size());
        for (HashStructure hash : data) {
            if (!hash.getBoolean("hidden/#text", false)) continue;
            ids.add(hash.getString("idref"));
        }
        return Collections.unmodifiableCollection(ids);
    }

    public String getHelpTopicId(String pageId) {
        List data = this._hash.getAsList("page");
        if (data == null) {
            return null;
        }
        for (HashStructure hs : data) {
            String id = hs.getString("idref");
            if (!pageId.equals(id)) continue;
            return hs.getString("help-topic-id/#text");
        }
        return null;
    }
}

