/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import oracle.ide.Ide;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.net.URLFilter;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.HashStructure;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.Pair;

public class GlobalIgnoreList
extends ChangeEventSource
implements Copyable {
    public static final String KEY_SETTINGS = "global-ignore-list";
    private List _filterList = new ArrayList();
    private static List _filterRegistry = new ArrayList();
    private static PatternFilters _patternFilters;

    public static final boolean isGloballyIgnored(URL url) {
        PatternFilter filter = GlobalIgnoreList.getPatternFilters().findMatchingFilter(url.getPath());
        return filter == null || !filter.isInclude();
    }

    public static void registerExcludeFilter(String excludeString) {
        _filterRegistry.add(excludeString);
    }

    public static PatternFilters getPatternFilters() throws TransientMarker {
        return GlobalIgnoreList._getPatternFiltersImpl();
    }

    public static URLFilter getURLFilter() {
        return new URLFilter(){
            final PatternFilters _filters = GlobalIgnoreList.getPatternFilters();

            public boolean accept(URL url) {
                return this._filters.isIncluded(url.getPath());
            }

            public boolean equals(Object o) {
                return o != null && o.getClass() == this.getClass();
            }
        };
    }

    public List getList() {
        this._ensureFilterListInitialized();
        return this._filterList;
    }

    public void setList(List list) {
        this._filterList = list;
        _patternFilters = null;
    }

    @Override
    public Object copyTo(Object target) {
        GlobalIgnoreList copy = target != null ? (GlobalIgnoreList)((Object)target) : new GlobalIgnoreList();
        this._copyToImpl(copy);
        return copy;
    }

    static List createDefaults() {
        ArrayList<Pair> defaultList = new ArrayList<Pair>();
        String excludeFiltersString = Ide.isRunning() ? Ide.getProperty("Ide.GlobalIgnoreListFilters", "") : System.getProperty("Ide.GlobalIgnoreListFilters", "");
        Pattern seperate = Pattern.compile(";");
        String[] tokens = seperate.split(excludeFiltersString);
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i].length() <= 0) continue;
            defaultList.add(new Pair((Object)tokens[i], (Object)true));
        }
        int registeredFilters = _filterRegistry.size();
        String newFilter = null;
        for (int i = 0; i < registeredFilters; ++i) {
            newFilter = (String)_filterRegistry.get(i);
            if (GlobalIgnoreList._containsFilter(newFilter, defaultList)) continue;
            defaultList.add(new Pair(_filterRegistry.get(i), (Object)true));
        }
        return defaultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _ensureFilterListInitialized() {
        List list = this._filterList;
        synchronized (list) {
            int listLen = this._filterList.size();
            if (listLen == 0) {
                List defaultList = GlobalIgnoreList.createDefaults();
                this._filterList.addAll(defaultList);
            }
        }
    }

    private PatternFilters _createPatternFilters() {
        HashStructure hashStructure = HashStructure.newInstance();
        PatternFilters patternFilters = PatternFilters.getInstance(hashStructure);
        patternFilters.addInclude("**");
        int listLen = this._filterList.size();
        Pair pair = null;
        Boolean enabled = null;
        for (int i = 0; i < listLen; ++i) {
            pair = (Pair)this._filterList.get(i);
            enabled = (Boolean)pair.getSecond();
            if (!enabled.booleanValue()) continue;
            patternFilters.addExclude((String)pair.getFirst());
        }
        return patternFilters;
    }

    private static boolean _containsFilter(String filter, List listToCheck) {
        int listLen = listToCheck.size();
        Pair pair = null;
        String excludeString = null;
        for (int i = 0; i < listLen; ++i) {
            pair = (Pair)listToCheck.get(i);
            excludeString = (String)pair.getFirst();
            if (!excludeString.equals(filter)) continue;
            return true;
        }
        return false;
    }

    private static synchronized PatternFilters _getPatternFiltersImpl() {
        if (_patternFilters == null) {
            GlobalIgnoreList ignoreList;
            GlobalIgnoreList globalIgnoreList = ignoreList = Ide.isRunning() && Ide.getSettings() != null ? (GlobalIgnoreList)((Object)Ide.getSettings().getData(KEY_SETTINGS)) : new GlobalIgnoreList();
            if (ignoreList == null) {
                ignoreList = new GlobalIgnoreList();
            }
            ignoreList._ensureFilterListInitialized();
            _patternFilters = ignoreList._createPatternFilters();
        }
        return _patternFilters;
    }

    private final void _copyToImpl(GlobalIgnoreList copy) {
        copy._filterList.clear();
        int listlen = this._filterList.size();
        Pair pair = null;
        for (int i = 0; i < listlen; ++i) {
            pair = (Pair)this._filterList.get(i);
            copy._filterList.add(new Pair(pair.getFirst(), pair.getSecond()));
        }
        _patternFilters = null;
        copy.fireChangeEvent();
    }
}

