/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.composite;

import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.ide.composite.AbstractCompositeFileElementProxy;
import oracle.ide.composite.CompositeFileElementEvent;
import oracle.ide.composite.CompositeFileElementListener;
import oracle.ide.composite.CompositeFileElementProxy;
import oracle.ide.model.Element;
import oracle.ide.net.URLFileSystem;

public class CompositeFileElementRegistry {
    static final String APPLICATION_NAVIGATOR_WINDOW_ID = "ApplicationNavigatorWindow";
    private static final Collection<CompositeFileElementListener> _compositeListeners = Collections.synchronizedList(new ArrayList());
    private static final CopyOnWriteArrayList<CompositeFileElementProxy> _compositeProxies = new CopyOnWriteArrayList();
    private static final Map<Element, Collection<URL>> _compositeStateCache = Collections.synchronizedMap(new WeakHashMap());

    private CompositeFileElementRegistry() {
    }

    public static final void registerCompositeProxy(CompositeFileElementProxy compositeProxy) {
        _compositeProxies.addIfAbsent(compositeProxy);
        CompositeFileElementRegistry.fireCompositeStateChanged(compositeProxy.getCompositeElementClass());
    }

    public static final void deregisterCompositeProxy(CompositeFileElementProxy compositeProxy) {
        _compositeProxies.remove(compositeProxy);
        CompositeFileElementRegistry.fireCompositeStateChanged(compositeProxy.getCompositeElementClass());
    }

    public static final void fireCompositeStateChanged(Element compositeElement) {
        CompositeFileElementRegistry.fireCompositeStateChanged(new Element[]{compositeElement});
    }

    public static final void fireCompositeStateChanged(Class compositeElementClass) {
        if (!Element.class.isAssignableFrom(compositeElementClass)) {
            throw new IllegalArgumentException();
        }
        Element[] compositeElements = CompositeFileElementRegistry.getCachedCompositeElements(compositeElementClass);
        if (compositeElements.length > 0) {
            CompositeFileElementRegistry.fireCompositeStateChanged(compositeElements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void fireCompositeStateChanged(Element[] compositeElements) {
        CompositeFileElementListener[] l;
        for (Element compositeElement : compositeElements) {
            _compositeStateCache.remove(compositeElement);
        }
        if (_compositeListeners.isEmpty()) {
            return;
        }
        Collection<CompositeFileElementListener> len$ = _compositeListeners;
        synchronized (len$) {
            l = _compositeListeners.toArray(new CompositeFileElementListener[0]);
        }
        CompositeFileElementEvent e = new CompositeFileElementEvent(compositeElements, 1);
        for (int i = l.length - 1; i >= 0; --i) {
            l[i].compositeStateChanged(e);
        }
    }

    public static final void addCompositeListener(CompositeFileElementListener l) {
        _compositeListeners.add(l);
    }

    public static final void removeCompositeListener(CompositeFileElementListener l) {
        _compositeListeners.remove(l);
    }

    public static final boolean isCompositeElement(Element element) {
        return CompositeFileElementRegistry.isCompositeElement(element, APPLICATION_NAVIGATOR_WINDOW_ID);
    }

    public static final boolean isCompositeElement(Element element, String viewType) {
        for (CompositeFileElementProxy compositeProxy : _compositeProxies.toArray(new CompositeFileElementProxy[0])) {
            if (!CompositeFileElementRegistry.isCompositeProxyForView(compositeProxy, viewType) || !compositeProxy.getCompositeElementClass().isInstance(element)) continue;
            return true;
        }
        return false;
    }

    public static final URL[] getCompositeFileURLs(Element compositeElement) {
        return CompositeFileElementRegistry.getCompositeFileURLs(compositeElement, APPLICATION_NAVIGATOR_WINDOW_ID);
    }

    public static final URL[] getCompositeFileURLs(Element compositeElement, String viewType) {
        if (_compositeStateCache.containsKey(compositeElement)) {
            return _compositeStateCache.get(compositeElement).toArray(new URL[0]);
        }
        AbstractCollection compositeFileUrls = new LinkedHashSet();
        for (CompositeFileElementProxy compositeProxy : _compositeProxies.toArray(new CompositeFileElementProxy[0])) {
            URL[] urls;
            if (!CompositeFileElementRegistry.isCompositeProxyForView(compositeProxy, viewType) || !compositeProxy.getCompositeElementClass().isInstance(compositeElement) || (urls = compositeProxy.getCompositeFileURLs(compositeElement)) == null) continue;
            compositeFileUrls.addAll(Arrays.asList(urls));
        }
        compositeFileUrls.remove(null);
        compositeFileUrls = new ArrayList(compositeFileUrls);
        Collections.sort((ArrayList)compositeFileUrls, new SystemOrderComparator());
        _compositeStateCache.put(compositeElement, compositeFileUrls);
        return compositeFileUrls.toArray(new URL[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Element[] getCachedCompositeElements(URL[] urls) {
        LinkedHashSet<Element> compositeElements = new LinkedHashSet<Element>();
        Map<Element, Collection<URL>> map = _compositeStateCache;
        synchronized (map) {
            for (Element compositeElement : _compositeStateCache.keySet()) {
                if (!CompositeFileElementRegistry.isCompositeElementOwner(compositeElement, urls)) continue;
                compositeElements.add(compositeElement);
            }
        }
        return compositeElements.toArray(new Element[0]);
    }

    static final boolean isRegisteredCompositeProxy(CompositeFileElementProxy compositeProxy) {
        return Arrays.asList(_compositeProxies.toArray()).contains(compositeProxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element[] getCachedCompositeElements(Class compositeElementClass) {
        ArrayList<Element> compositeElements = new ArrayList<Element>();
        Map<Element, Collection<URL>> map = _compositeStateCache;
        synchronized (map) {
            for (Element compositeElement : _compositeStateCache.keySet()) {
                if (!compositeElementClass.isInstance(compositeElement)) continue;
                compositeElements.add(compositeElement);
            }
        }
        return compositeElements.toArray(new Element[0]);
    }

    private static final boolean isCompositeProxyForView(CompositeFileElementProxy compositeProxy, String viewType) {
        if (viewType == null) {
            return true;
        }
        String viewType0 = APPLICATION_NAVIGATOR_WINDOW_ID;
        if (compositeProxy instanceof AbstractCompositeFileElementProxy) {
            AbstractCompositeFileElementProxy compositeProxy0 = (AbstractCompositeFileElementProxy)compositeProxy;
            viewType0 = compositeProxy0.getViewType();
        }
        return viewType0 == null || viewType.equals(viewType0);
    }

    private static final boolean isCompositeElementOwner(Element compositeElement, URL[] urls) {
        Collection<URL> compositeFileUrls = _compositeStateCache.get(compositeElement);
        for (URL url : urls) {
            if (!compositeFileUrls.contains(url)) continue;
            return true;
        }
        return false;
    }

    private static class SystemOrderComparator
    implements Comparator<URL> {
        private SystemOrderComparator() {
        }

        @Override
        public int compare(URL url1, URL url2) {
            return this.getWeight(url1) - this.getWeight(url2);
        }

        private int getWeight(URL url) {
            String suffix = URLFileSystem.getSuffix((URL)url);
            if (suffix.equals(".jpr")) {
                return -1;
            }
            if (suffix.equals(".jws")) {
                return -2;
            }
            return 0;
        }
    }
}

