/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd.buffer;

import oracle.ide.cmd.buffer.Edit;
import oracle.ide.cmd.buffer.EditCommand;
import oracle.ide.cmd.buffer.SimpleEdit;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Node;

public final class EditProcessor {
    private EditProcessor() {
    }

    public static void doInsert(char[] insertData, int insertOffset, Node node, boolean isUndoable, String editName, Object origin) {
        SimpleEdit edit = new SimpleEdit(1, insertData, insertOffset, -1, isUndoable, editName);
        EditProcessor.doEdit(edit, node, origin);
    }

    public static void doRemove(int removeOffset, int removeCount, Node node, boolean isUndoable, String editName, Object origin) {
        int removeEnd = removeOffset + removeCount;
        SimpleEdit edit = new SimpleEdit(2, null, removeOffset, removeEnd, isUndoable, editName);
        EditProcessor.doEdit(edit, node, origin);
    }

    public static void doReplace(char[] replaceData, int replaceStartOffset, int replaceEndOffset, Node node, boolean isUndoable, String editName, Object origin) {
        SimpleEdit edit = new SimpleEdit(3, replaceData, replaceStartOffset, replaceEndOffset, isUndoable, editName);
        EditProcessor.doEdit(edit, node, origin);
    }

    public static void doReplaceAll(char[] replaceData, Node node, boolean isUndoable, String editName, Object origin) {
        SimpleEdit edit = new SimpleEdit(4, replaceData, -1, -1, isUndoable, editName);
        EditProcessor.doEdit(edit, node, origin);
    }

    public static void doEdit(Edit edit, Node node, Object origin) {
        EditCommand command = new EditCommand(edit, node, origin);
        try {
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            commandProcessor.invoke(command);
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

