/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd.buffer;

import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.buffer.Edit;
import oracle.ide.controller.Command;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.buffer.TextBuffer;

final class EditCommand
extends Command {
    private static final int EB_COMMAND_ID = Ide.findOrCreateCmdID(EditCommand.class.getName());
    private static final UndoableEdit EDIT_NOT_APPLIED = new CompoundEdit();
    private TextNode textNode;
    private Object origin;
    private Edit edit;
    private UndoableEdit undoableEdit;

    EditCommand(Edit edit, Node node, Object origin) {
        super(EB_COMMAND_ID, edit.isUndoable() ? 0 : 2, edit.getUndoName());
        this.edit = edit;
        Context context = Context.newIdeContext(node);
        this.setContext(context);
        this.textNode = (TextNode)node;
        this.origin = origin;
        this.undoableEdit = EDIT_NOT_APPLIED;
    }

    private void notifyObservers() {
        TextNode subject = this.textNode;
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CONTENT_MODIFIED, this.origin);
        subject.notifyObservers(subject, updateMessage);
    }

    private boolean isReadOnly() {
        return this.textNode.isReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int doit() throws Exception {
        int result = 1;
        if (this.isReadOnly()) {
            return result;
        }
        if (this.edit != null) {
            boolean rollback = false;
            TextBuffer textBuffer = this.textNode.acquireTextBuffer();
            textBuffer.beginEdit();
            try {
                this.edit.applyEdit(textBuffer);
            }
            catch (RuntimeException e) {
                rollback = true;
            }
            finally {
                this.undoableEdit = textBuffer.endEdit();
                this.edit = null;
                this.textNode.releaseTextBuffer();
            }
            if (this.undoableEdit != null) {
                if (rollback) {
                    try {
                        this.undoableEdit.undo();
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                    this.undoableEdit = null;
                } else {
                    result = 0;
                    if (this.getType() != 0) {
                        this.undoableEdit = null;
                    }
                }
            }
        } else if (this.undoableEdit != null) {
            this.undoableEdit.redo();
            result = 0;
        }
        if (result == 0) {
            this.notifyObservers();
        }
        this.origin = null;
        return result;
    }

    @Override
    public final int undo() throws Exception {
        int result = 1;
        if (this.isReadOnly()) {
            return result;
        }
        if (this.undoableEdit == EDIT_NOT_APPLIED) {
            throw new IllegalStateException("edit not applied yet");
        }
        if (this.undoableEdit == null) {
            throw new IllegalStateException("no edit to undo");
        }
        this.undoableEdit.undo();
        result = 0;
        if (result == 0) {
            this.notifyObservers();
        }
        return result;
    }
}

