/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.io.IOException;
import java.net.URL;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controls.WaitCursor;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;

public class SaveCommand
extends Command {
    public SaveCommand() {
        super(11);
    }

    @Override
    public int doit() {
        int savedNodes = 0;
        Context context = this.getContext();
        Element[] selection = context.getSelection();
        Node doc = null;
        CheckBoxListModel listModel = new CheckBoxListModel();
        if (selection == null || selection.length == 0 || !(selection[0] instanceof Node)) {
            doc = context.getNode();
            String err = null;
            try {
                if (!this._saveNode(doc, true)) {
                    err = doc != null ? URLFileSystem.getPlatformPathName((URL)doc.getURL()) : "<null>";
                }
            }
            catch (Exception ex) {
                err = IdeArb.format(303, URLFileSystem.getPlatformPathName((URL)doc.getURL()), ex.getLocalizedMessage());
            }
            if (err != null && doc != null) {
                listModel.addElement((Object)doc, doc.getIcon(), false, false, err);
            }
        } else {
            for (Element elem : selection) {
                if (!(elem instanceof Node)) continue;
                doc = (Node)elem;
                String err = null;
                try {
                    if (this._saveNode(doc, false)) {
                        ++savedNodes;
                    } else {
                        err = URLFileSystem.getPlatformPathName((URL)doc.getURL());
                    }
                }
                catch (Exception ex) {
                    err = IdeArb.format(303, URLFileSystem.getPlatformPathName((URL)doc.getURL()), ex.getLocalizedMessage());
                }
                if (err == null) continue;
                listModel.addElement((Object)doc, doc.getIcon(), false, false, err);
            }
            String statusText = IdeArb.format(299, savedNodes);
            Ide.getStatusBar().setText(statusText);
        }
        if (listModel.getSize() > 0) {
            SelectFilesPanel.showDialog(IdeArb.getString(287), IdeArb.format(302, listModel.findTextForElement(0)), IdeArb.getString(301), listModel, false, -1, "f1_idedunabletosavefiles_html");
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _saveNode(Node doc, boolean updateStatus) throws IOException {
        if (doc != null) {
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            try {
                if (doc.isReadOnly()) {
                    URLFileSystem.setReadOnly((URL)doc.getURL(), (boolean)false);
                    doc.isReadOnly();
                }
                doc.save();
                if (updateStatus) {
                    String statusText = IdeArb.format(298, URLFileSystem.getPlatformPathName((URL)doc.getURL()));
                    Ide.getStatusBar().setText(statusText);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                wc.hide();
            }
        }
        return false;
    }
}

