/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Command;
import oracle.ide.controls.WaitCursor;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.docking.DockStation;
import oracle.ide.layout.IdeProperties;
import oracle.ide.layout.Layouts;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;

public class SaveAllCommand
extends Command {
    public SaveAllCommand() {
        super(13);
    }

    public static int saveAll() throws Exception {
        return SaveAllCommand.saveAll(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int saveAll(boolean silent) throws Exception {
        int openNodesCount = 0;
        int savedNodes = 0;
        CheckBoxListModel listModel = new CheckBoxListModel();
        WaitCursor wc = Ide.getWaitCursor();
        wc.show();
        try {
            Iterator<Node> nodes = NodeFactory.getCachedNodes();
            while (nodes.hasNext()) {
                Node node = nodes.next();
                if (!node.isOpen()) continue;
                ++openNodesCount;
                if (!node.isDirty()) continue;
                URL url = node.getURL();
                if (node.isReadOnly()) {
                    URLFileSystem.setReadOnly((URL)url, (boolean)false);
                }
                try {
                    node.save();
                    ++savedNodes;
                }
                catch (Exception e) {
                    String err = IdeArb.format(303, URLFileSystem.getPlatformPathName((URL)url), e.getLocalizedMessage());
                    listModel.addElement((Object)node, node.getIcon(), true, true, err);
                }
            }
        }
        finally {
            wc.hide();
        }
        if (!silent && listModel.getSize() > 0) {
            SelectFilesPanel.showDialog(IdeArb.getString(287), IdeArb.format(302, listModel.findTextForElement(0)), IdeArb.getString(301), listModel, false, -1, "f1_idedunabletosavefiles_html");
        }
        String statusText = IdeArb.format(300, openNodesCount, savedNodes);
        Ide.getStatusBar().setText(statusText);
        return 0;
    }

    @Override
    public int doit() throws Exception {
        SaveAllCommand.saveAll();
        SaveAllCommand.saveSystemFiles();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSystemFiles() {
        WaitCursor wc = Ide.getWaitCursor();
        boolean isQuitting = Ide.isQuitting();
        if (!isQuitting) {
            wc.show();
        }
        try {
            if (isQuitting) {
                Ide.getSettings().save();
                try {
                    Preferences.getPreferences().save();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Ide.getDTCache().save();
            Layouts layouts = Layouts.getLayouts();
            if (layouts != null) {
                if (!isQuitting) {
                    DockStation.getDockStation().saveLayout(layouts.getActiveLayout());
                }
                layouts.saveAll();
            }
            FileOpenHistory.getInstance().save();
            IdeProperties props = Ide.getIdeProperties();
            if (props != null) {
                try {
                    props.save();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            if (!isQuitting) {
                wc.hide();
            }
        }
    }
}

