/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.net.URL;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.cmd.SaveAsCommand;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Recognizer;
import oracle.ide.model.RecognizerException;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.VetoableSubject;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ModelUtil;
import oracle.javatools.dialogs.MessageDialog;

public class RenameCommand
extends SaveAsCommand {
    public RenameCommand() {
        super(14);
    }

    @Override
    public int doit() throws Exception {
        Element selected;
        Context context = this.getContext();
        Node node = null;
        Element[] selection = context.getSelection();
        if (selection != null && selection.length == 1 && (selected = selection[0]) instanceof Node) {
            node = (Node)selected;
        }
        if (node == null) {
            node = context.getNode();
        }
        return this.doFileRename(context, node);
    }

    private int doFileRename(Context context, Node node) {
        String dialogTitle;
        int status;
        URL oldURL = node.getURL();
        Folder owner = RenameCommand.getElementOwner(node, context);
        if (owner instanceof VetoableSubject) {
            try {
                UpdateMessage.fireCanRenameChild((VetoableSubject)((Object)owner), node);
            }
            catch (Exception e) {
                return 2;
            }
        }
        if ((status = this.doSaveAs(dialogTitle = IdeArb.getString(345))) == 2 || status == 1) {
            return 1;
        }
        if (URLFileSystem.exists((URL)oldURL) && !URLFileSystem.isDirectory((URL)oldURL) && !URLFileSystem.equals((URL)oldURL, (URL)this._newURL) && !URLFileSystem.delete((URL)oldURL)) {
            String msg = IdeArb.format(246, URLFileSystem.getPlatformPathName((URL)oldURL), URLFileSystem.getPlatformPathName((URL)this._newURL));
            JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), msg, IdeArb.getString(241), 0);
        }
        return 0;
    }

    @Override
    protected int saveNode(Node doc) {
        URL oldURL = doc.getURL();
        if (!URLFileSystem.exists((URL)oldURL)) {
            return super.saveNode(doc);
        }
        if (URLFileSystem.exists((URL)this._newURL) && !URLFileSystem.equals((URL)oldURL, (URL)this._newURL) && !URLFileSystem.delete((URL)this._newURL)) {
            String msg = IdeArb.format(253, URLFileSystem.getPlatformPathName((URL)this._newURL));
            JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), msg, IdeArb.getString(241), 0);
            return 2;
        }
        if (!URLFileSystem.renameTo((URL)oldURL, (URL)this._newURL)) {
            String msg = IdeArb.format(254, URLFileSystem.getPlatformPathName((URL)oldURL), URLFileSystem.getPlatformPathName((URL)this._newURL));
            JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), msg, IdeArb.getString(241), 0);
            return 2;
        }
        doc.setURL(this._newURL);
        return 0;
    }

    @Override
    protected int saveAsNewNode(Node doc) {
        int result;
        URL oldURL = doc.getURL();
        Subject ownerSubject = null;
        if (this._elementOwner instanceof Subject) {
            ownerSubject = (Subject)((Object)this._elementOwner);
            RenameMessage.firePreChildRenamed(ownerSubject, this._context);
        }
        if ((result = this.saveNode(doc)) == 0) {
            RenameMessage.fireObjectRenamed(doc, oldURL, this._context);
            if (ownerSubject != null) {
                RenameMessage.fireChildRenamed(ownerSubject, oldURL, doc, this._context);
            }
        }
        return result;
    }

    @Override
    protected int saveAsDupNode(Node doc) {
        int result = 1;
        URL oldURL = doc.getURL();
        try {
            this._duplicate.close();
            if (doc.isNew()) {
                doc.save();
            }
            if (URLFileSystem.delete((URL)this._newURL)) {
                result = this.saveAsNewNode(doc);
            }
        }
        catch (Exception e) {
            String msg = IdeArb.format(248, oldURL.getPath(), e.toString());
            MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)msg, (String)IdeArb.getString(241), null);
        }
        return result;
    }

    @Override
    protected int handleNodeOwnership(Node doc, Node node, URL oldURL) throws Exception {
        List list;
        EditorManager editorMgr = EditorManager.getEditorManager();
        if (editorMgr != null && (list = editorMgr.findEditors(this._context)).size() > 0) {
            this._noPlaceToAdd = true;
        }
        if (this._elementOwner != null) {
            this._elementOwner.remove(doc);
            this._elementOwner.add(node);
        }
        RenameMessage.fireObjectRenamed(doc, oldURL, node, this._context);
        if (this._elementOwner instanceof Subject) {
            Subject subject = (Subject)((Object)this._elementOwner);
            RenameMessage.fireChildRenamed(subject, doc, oldURL, node, this._context);
        }
        doc.close();
        NodeFactory.uncache(oldURL);
        return 0;
    }

    @Override
    protected boolean isSameFile(URL newURL, URL elementURL) {
        return ModelUtil.areEqual((Object)newURL, (Object)elementURL);
    }

    @Override
    protected URL validateNewURL(Recognizer recognizer, URL newURL, URL oldURL) {
        try {
            String oldExt = URLFileSystem.getSuffix((URL)oldURL);
            String newExt = URLFileSystem.getSuffix((URL)newURL);
            if (ModelUtil.hasLength((String)oldExt) && !ModelUtil.hasLength((String)newExt) || ModelUtil.hasLength((String)oldExt) && oldExt.equals(".jws") && !newExt.equals(".jws") || ModelUtil.hasLength((String)oldExt) && oldExt.equals(".jpr") && !newExt.equals(".jpr")) {
                return recognizer.validate(newURL, oldURL);
            }
            recognizer.validate(newURL, oldURL);
            return newURL;
        }
        catch (RecognizerException e) {
            String msg = e.getLocalizedMessage();
            if (msg == null || msg.length() == 0) {
                msg = IdeArb.format(245, URLFileSystem.getPlatformPathName((URL)newURL));
            }
            JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), msg, IdeArb.getString(241), 0);
            return null;
        }
    }
}

