/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.editor.FileSaveHook;
import oracle.ide.editor.FileSaveListener;
import oracle.ide.editor.FilesToSaveGroup;
import oracle.ide.editor.SaveFilesEvent;
import oracle.ide.editor.SaveFilesResponse;
import oracle.ide.model.Node;
import oracle.ide.resource.IdeArb;

class FilesToSaveOnCloseCollector {
    private final List<Node> individualNodes = new ArrayList<Node>();
    private final List<FilesToSaveGroup> groupedNodesGroups = new ArrayList<FilesToSaveGroup>();
    private boolean onlyOneFileToCloseWithDirtyGroupedFiles;

    static FilesToSaveOnCloseCollector collectFilesToSave(List<Node> dirty) {
        return new FilesToSaveOnCloseCollector(dirty);
    }

    private FilesToSaveOnCloseCollector(List<Node> dirty) {
        this.collect(dirty);
    }

    private void collect(List<Node> dirty) {
        if (dirty.isEmpty()) {
            return;
        }
        this.individualNodes.addAll(dirty);
        boolean onlyOneDirtyNode = dirty.size() == 1;
        this.findGroupedNodes();
        this.onlyOneFileToCloseWithDirtyGroupedFiles = onlyOneDirtyNode && this.individualNodes.isEmpty();
    }

    private void findGroupedNodes() {
        List<FileSaveListener> listeners = FileSaveHook.getHook().fileSaveListeners();
        SaveFilesEvent event = new SaveFilesEvent(this.individualNodes);
        for (FileSaveListener l : listeners) {
            this.findGroupedNodes(event, l);
        }
    }

    private void findGroupedNodes(SaveFilesEvent event, FileSaveListener l) {
        SaveFilesResponse response = l.fileClosing(event);
        if (response == null || !response.isHandled()) {
            return;
        }
        FilesToSaveGroup toSaveTogether = response.nodesToSave();
        if (toSaveTogether == null) {
            return;
        }
        List<Node> nodesToSave = toSaveTogether.nodesToSave();
        if (nodesToSave == null || nodesToSave.size() <= 1) {
            return;
        }
        this.individualNodes.removeAll(nodesToSave);
        this.groupedNodesGroups.add(toSaveTogether);
    }

    List<Node> individualNodes() {
        return this.individualNodes;
    }

    List<FilesToSaveGroup> groupedNodesGroups() {
        return this.groupedNodesGroups;
    }

    boolean onlyOneFileToCloseWithDirtyGroupedFiles() {
        return this.onlyOneFileToCloseWithDirtyGroupedFiles;
    }

    boolean isGrouped(Node n) {
        if (this.groupedNodesGroups.isEmpty()) {
            return false;
        }
        for (FilesToSaveGroup group : this.groupedNodesGroups) {
            if (!group.contains(n)) continue;
            return true;
        }
        return false;
    }

    String actionDescription() {
        String description = null;
        if (!this.groupedNodesGroups().isEmpty()) {
            description = IdeArb.getString(492);
        }
        return description;
    }
}

